/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.model.schema.impl;

import com.metamatrix.modeler.schema.tools.model.schema.Relationship;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.impl.BaseRelationship;

public class MergedRelationship
extends BaseRelationship {
    private Relationship parent;
    private Relationship child;

    public MergedRelationship(Relationship parent, Relationship child) {
        this.parent = parent;
        this.child = child;
    }

    public String getParentRelativeXpath() {
        String parentPart = this.parent.getParentRelativeXpath();
        String childPart = this.child.getParentRelativeXpath();
        String retval = childPart + "/" + parentPart;
        return retval;
    }

    public String getChildRelativeXpath() {
        String parentPart = this.parent.getChildRelativeXpath();
        String childPart = this.child.getChildRelativeXpath();
        String retval = parentPart + "/" + childPart;
        return retval;
    }

    public SchemaObject getParent() {
        SchemaObject retval = this.parent.getParent();
        return retval;
    }

    public SchemaObject getChild() {
        SchemaObject retval = this.child.getChild();
        return retval;
    }

    public int getMinOccurs() {
        int parentMinOccurs = this.parent.getMinOccurs();
        int childMinOccurs = this.child.getMinOccurs();
        int retval = this.multiplyCardinalities(parentMinOccurs, childMinOccurs);
        return retval;
    }

    public int getMaxOccurs() {
        int parentMinOccurs = this.parent.getMinOccurs();
        int childMinOccurs = this.child.getMinOccurs();
        int retval = this.multiplyCardinalities(parentMinOccurs, childMinOccurs);
        return retval;
    }

    public int getRepresentation() {
        return this.child.getType();
    }

    public String toString() {
        String childName = this.child.toString();
        String parentName = this.parent.toString();
        return parentName + ":" + childName;
    }

    public void printDebug() {
        System.out.println("MergedRelationship: ");
        System.out.println("Begin Parent");
        this.parent.printDebug();
        System.out.println("parentRelativeXPath = " + this.getParentRelativeXpath());
        System.out.println("End Parent");
        System.out.println("Begin Child");
        this.child.printDebug();
        System.out.println("childRelativeXPath = " + this.getChildRelativeXpath());
        System.out.println("End Child");
    }
}

