/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.soap;

import com.metamatrix.connector.xml.SOAPConnectorState;
import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.internal.core.text.MessageFormat;
import java.util.Properties;

public class SOAPConnectorStateImpl
implements SOAPConnectorState {
    public static final String ENCODING_STYLE_PROPERTY_NAME = "EncodingStyle";
    public static final String RPC_ENC_STYLE = "RPC - Encoded";
    public static final String RPC_LITERAL_STYLE = "RPC - Literal";
    public static final String DOC_ENCODED_STYLE = "Document - Encoded";
    public static final String DOC_LITERAL_STYLE = "Document - Literal";
    public static final String AUTH_REGIME_PROPERTY_NAME = "AuthRegime";
    public static final String AUTH_REGIME_NONE = "None";
    public static final String AUTH_REGIME_BASIC = "SOAP-BASIC";
    public static final String AUTH_REGIME_WSSEC = "WS-Security";
    public static final String AUTH_USER_PROPERTY_NAME = "AuthUserName";
    public static final String AUTH_PASSWORD_PROPERTY_NAME = "AuthPassword";
    public static final String CONNECTOR_EXCEPTION_ON_SOAP_FAULT = "ExceptionOnSOAPFault";
    private boolean m_encoded;
    private boolean m_RPC;
    private boolean m_useBasicAuth;
    private boolean m_useWSSec;
    private String m_authUser;
    private String m_authPassword;
    private boolean m_exceptionOnFault;
    private ConnectorLogger logger;

    public SOAPConnectorStateImpl() {
        this.setEncoded(true);
        this.setRPC(true);
        this.setUseBasicAuth(false);
        this.setUseWSSec(false);
        this.setAuthUser(new String());
        this.setAuthPassword(new String());
        this.setExceptionOnFault(false);
    }

    private boolean isNotNullOrEmpty(String value) {
        return value != null && !value.equals("");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setState(Properties props) throws ConnectorException {
        String strExceptionOnFault;
        String enc = props.getProperty(ENCODING_STYLE_PROPERTY_NAME);
        if (!this.isNotNullOrEmpty(enc)) throw new ConnectorException(Messages.getString("SOAPConnectorStateImpl.empty.ENCODING_STYLE_PROPERTY_NAME"));
        if (enc.equalsIgnoreCase(RPC_ENC_STYLE) || enc.equalsIgnoreCase(RPC_LITERAL_STYLE) || enc.equalsIgnoreCase(DOC_ENCODED_STYLE) || enc.equalsIgnoreCase(DOC_LITERAL_STYLE)) {
            if (enc.equalsIgnoreCase(RPC_ENC_STYLE) || enc.equalsIgnoreCase(RPC_LITERAL_STYLE)) {
                this.setRPC(true);
            } else {
                this.setRPC(false);
            }
            if (enc.equalsIgnoreCase(RPC_ENC_STYLE) || enc.equalsIgnoreCase(DOC_ENCODED_STYLE)) {
                this.setEncoded(true);
            } else {
                this.setEncoded(false);
            }
        } else {
            String rawMsg = Messages.getString("SOAPConnectorStateImpl.invalid.ENCODING_STYLE_PROPERTY_NAME");
            Object[] objs = new Object[]{RPC_ENC_STYLE, RPC_LITERAL_STYLE, DOC_ENCODED_STYLE, DOC_LITERAL_STYLE};
            String msg = MessageFormat.format((String)rawMsg, (Object[])objs);
            throw new ConnectorException(msg);
        }
        String authRegime = props.getProperty(AUTH_REGIME_PROPERTY_NAME);
        boolean useAuth = false;
        if (this.isNotNullOrEmpty(authRegime)) {
            if (authRegime.equals(AUTH_REGIME_NONE)) {
                this.setUseBasicAuth(false);
                this.setUseWSSec(false);
            } else if (authRegime.equals(AUTH_REGIME_BASIC)) {
                this.setUseBasicAuth(true);
                this.setUseWSSec(false);
                useAuth = true;
            } else if (authRegime.equals(AUTH_REGIME_WSSEC)) {
                this.setUseBasicAuth(false);
                this.setUseWSSec(true);
                useAuth = true;
            }
        } else {
            this.setUseBasicAuth(false);
            this.setUseWSSec(false);
        }
        if (useAuth) {
            String user = props.getProperty(AUTH_USER_PROPERTY_NAME);
            if (!this.isNotNullOrEmpty(user)) {
                throw new ConnectorException(Messages.getString("SOAPConnectorStateImpl.empty.AUTH_USER_PROPERTY_NAME"));
            }
            this.setAuthUser(user);
            String pwd = props.getProperty(AUTH_PASSWORD_PROPERTY_NAME);
            if (!this.isNotNullOrEmpty(pwd)) throw new ConnectorException(Messages.getString("SOAPConnectorStateImpl.empty.AUTH_PASSWORD_PROPERTY_NAME"));
            this.setAuthPassword(pwd);
        }
        if (!this.isNotNullOrEmpty(strExceptionOnFault = props.getProperty(CONNECTOR_EXCEPTION_ON_SOAP_FAULT))) {
            throw new ConnectorException(Messages.getString("SOAPConnectorStateImpl.empty.CONNECTOR_EXCEPTION_ON_SOAP_FAULT"));
        }
        boolean exOnFault = false;
        exOnFault = Boolean.valueOf(strExceptionOnFault);
        this.setExceptionOnFault(exOnFault);
    }

    public Properties getState() {
        Properties props = new Properties();
        String style = null;
        style = this.isRPC() ? (this.isEncoded() ? RPC_ENC_STYLE : RPC_LITERAL_STYLE) : (this.isEncoded() ? DOC_ENCODED_STYLE : DOC_LITERAL_STYLE);
        props.setProperty(ENCODING_STYLE_PROPERTY_NAME, style);
        props.setProperty(AUTH_REGIME_PROPERTY_NAME, Boolean.toString(this.isUseBasicAuth()));
        props.setProperty(AUTH_USER_PROPERTY_NAME, this.getAuthUser());
        props.setProperty(AUTH_PASSWORD_PROPERTY_NAME, this.getAuthPassword());
        props.setProperty(CONNECTOR_EXCEPTION_ON_SOAP_FAULT, Boolean.toString(this.isExceptionOnFault()));
        return props;
    }

    private void setEncoded(boolean encoded) {
        this.m_encoded = encoded;
    }

    public boolean isEncoded() {
        return this.m_encoded;
    }

    private void setRPC(boolean rpc) {
        this.m_RPC = rpc;
    }

    public boolean isRPC() {
        return this.m_RPC;
    }

    private void setUseBasicAuth(boolean basicAuth) {
        this.m_useBasicAuth = basicAuth;
    }

    public boolean isUseBasicAuth() {
        return this.m_useBasicAuth;
    }

    private void setUseWSSec(boolean wsSec) {
        this.m_useWSSec = wsSec;
    }

    public boolean isUseWSSec() {
        return this.m_useWSSec;
    }

    private void setAuthUser(String authUser) {
        this.m_authUser = authUser;
    }

    public String getAuthUser() {
        return this.m_authUser;
    }

    private void setAuthPassword(String authPassword) {
        this.m_authPassword = authPassword;
    }

    public String getAuthPassword() {
        return this.m_authPassword;
    }

    private void setExceptionOnFault(boolean exceptionOnFault) {
        this.m_exceptionOnFault = exceptionOnFault;
    }

    public boolean isExceptionOnFault() {
        return this.m_exceptionOnFault;
    }

    public void setLogger(ConnectorLogger logger) {
        this.logger = logger;
    }

    public ConnectorLogger getLogger() {
        return this.logger;
    }
}

