/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.base.FileLifeManager;
import com.metamatrix.connector.xml.base.LargeTextValueReference;
import com.metamatrix.data.exception.ConnectorException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileBackedValueReference
implements LargeTextValueReference {
    private RandomAccessFile file;
    private long length;
    private FileLifeManager fileLifeManager;
    private static final String encoding = "UTF-16BE";

    protected FileBackedValueReference(FileLifeManager fileLifeManager) throws IOException {
        this.fileLifeManager = fileLifeManager;
        this.file = fileLifeManager.createRandomAccessFile();
        this.length = FileBackedValueReference.charCountFromByteCount(this.file.length());
    }

    public Object getValue() {
        return this.file;
    }

    public long getSize() {
        return this.length;
    }

    public String getContentAsString() throws ConnectorException {
        try {
            Long len = new Long(this.file.length());
            byte[] bytes = new byte[len.intValue()];
            int count = this.file.read(bytes);
            String str = new String(bytes, 0, count, FileBackedValueReference.getEncoding());
            return str;
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public boolean isBinary() {
        return false;
    }

    public static String getEncoding() {
        return encoding;
    }

    private static final long charCountFromByteCount(long byteCount) throws IOException {
        return byteCount / 2L;
    }

    private static final long byteCountFromCharCount(long charCount) {
        return charCount * 2L;
    }

    private static final int charCountFromByteCount(int byteCount) throws IOException {
        return (int)FileBackedValueReference.charCountFromByteCount((long)byteCount);
    }

    private static final int byteCountFromCharCount(int charCount) {
        return (int)FileBackedValueReference.byteCountFromCharCount((long)charCount);
    }
}

