/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.util;

import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import java.util.HashMap;
import java.util.Map;

public class VariableContext {
    private Map variableMap = new HashMap();
    private VariableContext parentContext;

    public VariableContext() {
        this.variableMap = new HashMap();
    }

    public VariableContext(Map variableMap) {
        if (variableMap == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0019"));
        }
        this.variableMap = variableMap;
    }

    public void setValue(ElementSymbol variable, Object value) {
        this.variableMap.put(variable, value);
    }

    public Object getValue(ElementSymbol variable) {
        if (this.variableMap.containsKey(variable)) {
            return this.variableMap.get(variable);
        }
        if (this.parentContext != null) {
            return this.parentContext.getValue(variable);
        }
        return null;
    }

    public void setParentContext(VariableContext parent) {
        this.parentContext = parent;
    }

    public VariableContext getParentContext() {
        return this.parentContext;
    }

    public void getFlattenedContextMap(Map values) {
        if (this.parentContext != null) {
            this.parentContext.getFlattenedContextMap(values);
        }
        values.putAll(this.variableMap);
    }

    public boolean containsVariable(ElementSymbol variable) {
        if (!this.variableMap.containsKey(variable)) {
            if (this.parentContext != null) {
                return this.parentContext.containsVariable(variable);
            }
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        if (this.variableMap.isEmpty() && this.parentContext != null) {
            return this.parentContext.isEmpty();
        }
        return false;
    }
}

