/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.dqp.exception.PartialResultsException;
import com.metamatrix.dqp.exception.SourceFailureDetails;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.api.PartialResultsWarning;
import java.sql.SQLWarning;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class WarningUtil {
    private WarningUtil() {
    }

    static SQLWarning createWarning(Throwable ex) {
        if (ex instanceof PartialResultsException) {
            return WarningUtil.convertToWarning((PartialResultsException)ex);
        }
        return new SQLWarning(ex.getMessage());
    }

    static Throwable getChildException(Throwable parent) {
        Throwable exception = parent instanceof MetaMatrixException ? ((MetaMatrixException)parent).getChild() : (parent instanceof SQLWarning ? ((SQLWarning)parent).getNextException() : null);
        return exception;
    }

    static PartialResultsWarning convertToWarning(PartialResultsException exception) {
        PartialResultsWarning warning = new PartialResultsWarning(JDBCPlugin.Util.getString("WarningUtil.Failures_occurred"));
        Collection failures = exception.getSourceFailureDetails();
        Iterator iter = failures.iterator();
        while (iter.hasNext()) {
            SourceFailureDetails details = (SourceFailureDetails)iter.next();
            String connectorName = details.getConnectorBindingName();
            MetaMatrixException sourceEx = details.getException();
            warning.addConnectorFailure(connectorName, MMSQLException.create(sourceEx));
        }
        return warning;
    }

    static SQLWarning convertWarnings(List exceptions) {
        if (exceptions == null || exceptions.size() == 0) {
            return null;
        }
        if (exceptions.size() == 1) {
            return WarningUtil.createWarning((Exception)exceptions.get(0));
        }
        Iterator exIter = exceptions.iterator();
        SQLWarning warning = null;
        Throwable childException = (Throwable)exIter.next();
        while (childException != null) {
            SQLWarning newWarning = WarningUtil.createWarning(childException);
            if (warning == null) {
                warning = newWarning;
            } else {
                warning.setNextWarning(newWarning);
            }
            if ((childException = WarningUtil.getChildException(childException)) != null || !exIter.hasNext()) continue;
            childException = (Throwable)exIter.next();
        }
        return warning;
    }
}

