/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.aop;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.BaseInterceptor;
import com.metamatrix.core.log.Logger;
import dynaop.Invocation;
import java.util.Arrays;

public class TraceLoggerAspect
extends BaseInterceptor {
    private static final String BLANK = "";
    private static final String NULL = "null";
    private static final String COMMA = ", ";
    private static final char SPACE = ' ';
    ThreadLocal indent = new ThreadLocal();

    public Object intercept(Invocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        String className = invocation.getMethod().getDeclaringClass().getName();
        Logger logger = null;
        String indent = BLANK;
        if (AOP.tracing) {
            logger = this.findLogger(invocation.getProxy());
            indent = this.indent();
            className = className.substring(className.lastIndexOf(46) + 1);
            this.logTrace(logger, CommonPlugin.Util.getString("TraceLogger.entering", new Object[]{indent, className, methodName, this.getParams(invocation.getArguments())}));
        }
        Object anObj = invocation.proceed();
        if (AOP.tracing) {
            this.logTrace(logger, CommonPlugin.Util.getString("TraceLogger.exit", new Object[]{indent, className, methodName}));
            this.deindent();
        }
        return anObj;
    }

    String getParams(Object[] args) {
        if (args != null && args.length > 0) {
            if (args.length == 1) {
                return args[0].toString();
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) {
                    sb.append(args[i].toString());
                    if (i >= args.length - 1) continue;
                    sb.append(COMMA);
                    continue;
                }
                sb.append(NULL);
            }
            return sb.toString();
        }
        return BLANK;
    }

    private String indent() {
        int index = 0;
        Integer obj = (Integer)this.indent.get();
        if (obj != null) {
            index = obj + 1;
        }
        this.indent.set(new Integer(index));
        char[] blanks = new char[index];
        Arrays.fill(blanks, ' ');
        return new String(blanks);
    }

    private void deindent() {
        Integer obj = (Integer)this.indent.get();
        if (obj != null) {
            int index = obj - 1;
            this.indent.set(new Integer(index));
        }
    }
}

