/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.api.exception;

import com.metamatrix.common.CommonPlugin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MultipleRuntimeException
extends RuntimeException
implements Serializable {
    private List throwables;
    private String code;

    public MultipleRuntimeException() {
        this(null, null, (List)null);
    }

    public MultipleRuntimeException(String message) {
        this(message, null, (List)null);
    }

    public MultipleRuntimeException(List throwables) {
        this(null, null, throwables);
    }

    public MultipleRuntimeException(Throwable[] throwables) {
        this(null, null, Arrays.asList(throwables));
    }

    public MultipleRuntimeException(String message, String code) {
        this(message, code, (List)null);
    }

    public MultipleRuntimeException(String message, List throwables) {
        this(message, null, throwables);
    }

    public MultipleRuntimeException(String message, Throwable[] throwables) {
        this(message, null, Arrays.asList(throwables));
    }

    public MultipleRuntimeException(String message, String code, Throwable[] throwables) {
        this(message, code, Arrays.asList(throwables));
    }

    public MultipleRuntimeException(String message, String code, List throwables) {
        super(message);
        this.constructMultipleRuntimeException(code, throwables);
    }

    public void addThrowable(Throwable throwable) {
        this.addThrowable(throwable, this.throwables.size());
    }

    public void addThrowable(Throwable throwable, int index) {
        if (throwable == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("MultipleRuntimeException.Throwable_param_null"));
        }
        if (index < 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("MultipleRuntimeException.Index_param_negative"));
        }
        this.throwables.add(index, throwable);
    }

    protected void constructMultipleRuntimeException(String code, List throwables) {
        this.setCode(code);
        this.setThrowables(throwables);
    }

    public String getCode() {
        return this.code;
    }

    public List getThrowables() {
        return this.throwables;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setThrowables(List throwables) {
        this.throwables = throwables == null ? new ArrayList() : throwables;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.throwables.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next().toString());
        }
        return buf.toString();
    }
}

