/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class OrderBy
implements LanguageObject {
    public static final boolean ASC = Boolean.TRUE;
    public static final boolean DESC = Boolean.FALSE;
    private List sortOrder;
    private List orderTypes;
    private List resolvedVariables;

    public OrderBy() {
        this.sortOrder = new ArrayList();
        this.orderTypes = new ArrayList();
    }

    public OrderBy(List parameters) {
        this.sortOrder = new ArrayList(parameters);
        this.orderTypes = new ArrayList(parameters.size());
        for (int i = 0; i < parameters.size(); ++i) {
            this.orderTypes.add(Boolean.TRUE);
        }
    }

    public OrderBy(List parameters, List types) {
        this.sortOrder = new ArrayList(parameters);
        this.orderTypes = new ArrayList(types);
    }

    public int getVariableCount() {
        return this.sortOrder.size();
    }

    public List getVariables() {
        return this.sortOrder;
    }

    public List getTypes() {
        return this.orderTypes;
    }

    public SingleElementSymbol getVariable(int index) {
        return (SingleElementSymbol)this.sortOrder.get(index);
    }

    public Boolean getOrderType(int index) {
        return (Boolean)this.orderTypes.get(index);
    }

    public void addVariable(SingleElementSymbol element) {
        if (element != null) {
            this.sortOrder.add(element);
            this.orderTypes.add(ASC);
        }
    }

    public void addVariable(SingleElementSymbol element, boolean type) {
        if (element != null) {
            this.sortOrder.add(element);
            this.orderTypes.add(type);
        }
    }

    public void replaceVariables(Collection elements) {
        if (elements == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0004"));
        }
        if (elements.size() != this.sortOrder.size()) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0005"));
        }
        this.sortOrder = new ArrayList(elements);
    }

    public boolean containsVariable(SingleElementSymbol element) {
        return this.sortOrder.contains(element);
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        List thisSymbols = this.getVariables();
        ArrayList<Object> copySymbols = new ArrayList<Object>(thisSymbols.size());
        Iterator iter = thisSymbols.iterator();
        while (iter.hasNext()) {
            SingleElementSymbol ses = (SingleElementSymbol)iter.next();
            copySymbols.add(ses.clone());
        }
        ArrayList<Object> copyVariables = null;
        if (this.resolvedVariables != null) {
            copyVariables = new ArrayList<Object>(this.resolvedVariables.size());
            iter = this.resolvedVariables.iterator();
            while (iter.hasNext()) {
                SingleElementSymbol ses = (SingleElementSymbol)iter.next();
                copyVariables.add(ses.clone());
            }
        }
        OrderBy result = new OrderBy(copySymbols, this.getTypes());
        result.setResolvedVariables(copyVariables);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        OrderBy other = (OrderBy)obj;
        return EquivalenceUtil.areEqual(this.getVariables(), other.getVariables()) && EquivalenceUtil.areEqual(this.getTypes(), other.getTypes());
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode(0, this.getVariables());
        hc = HashCodeUtil.hashCode(hc, this.getTypes());
        return hc;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public List getResolvedVariables() {
        return this.resolvedVariables;
    }

    public void setResolvedVariables(List resolvedVariables) {
        this.resolvedVariables = resolvedVariables;
    }
}

