/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.api.exception.security.MetaBaseResourceNotResolvedException;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.AuthorizationResource;
import java.io.Serializable;

public class MetaBaseResource
implements AuthorizationResource,
Serializable {
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    public static final String ROOT = "/";
    public static final String ROOT_NAME = "Repository Root";
    public static final String RECURSIVE = "*";
    public static final String SEPARATOR_WITH_RECURSIVE = "/*";
    public static final String ROOT_RECURSIVE = "/*";
    private String name;
    private String canonicalName;
    private boolean isRecursive;
    private String uuid;

    public MetaBaseResource(String path) {
        if (path == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0051"));
        }
        this.init(path);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MetaBaseResource) {
            return this.name.equals(((MetaBaseResource)obj).name);
        }
        return false;
    }

    public boolean isCannonicallyEquivalent(AuthorizationResource resource) {
        if (resource instanceof MetaBaseResource) {
            MetaBaseResource thatResource = (MetaBaseResource)resource;
            return this.canonicalName.equals(thatResource.canonicalName);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.name;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0052"));
        }
        this.name = name;
        this.canonicalName = name.toLowerCase();
    }

    public boolean isResolved() {
        return this.name != null;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    void setRecursive(boolean recursive) {
        this.isRecursive = recursive;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0053"));
        }
        if (!(o instanceof MetaBaseResource)) {
            throw new ClassCastException(PlatformPlugin.Util.getString("ERR.014.107.0054", o.getClass()));
        }
        return this.name.compareTo(((MetaBaseResource)o).name);
    }

    public boolean implies(AuthorizationResource thatResource) throws MetaBaseResourceNotResolvedException {
        if (!(thatResource instanceof MetaBaseResource)) {
            return false;
        }
        MetaBaseResource that = (MetaBaseResource)thatResource;
        if (this.isRecursive && that.canonicalName.startsWith(this.canonicalName)) {
            return true;
        }
        return this.canonicalName.equals(that.canonicalName);
    }

    private void init(String path) {
        if (path.equals("/*")) {
            this.isRecursive = true;
            this.name = "/";
        } else if (path.equals("/")) {
            this.name = "/";
        } else if (path.endsWith("/*")) {
            this.isRecursive = true;
            this.name = path.substring(0, path.length() - 2);
        } else {
            this.name = path;
        }
        this.canonicalName = this.name.toLowerCase();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<ID: " + this.name);
        buf.append(" UUID: " + this.name);
        buf.append(" Name: " + this.name + ">");
        return buf.toString();
    }
}

