/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.core.log.Logger;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.api.ResultSetMetaData;
import java.sql.SQLException;

public class FilteredResultsMetadata
implements ResultSetMetaData {
    private ResultSetMetaData delegate;
    private int actualColumnCount;
    Logger logger;
    static /* synthetic */ Class class$com$metamatrix$jdbc$FilteredResultsMetadata;
    static /* synthetic */ Class class$com$metamatrix$jdbc$api$ResultSetMetaData;
    static /* synthetic */ Class class$com$metamatrix$core$log$Logger;

    static FilteredResultsMetadata newInstance(ResultSetMetaData rsmd, int actualColumnCount, Logger logger) {
        if (AOP.useproxy()) {
            return (FilteredResultsMetadata)ProxyFactory.extend(class$com$metamatrix$jdbc$FilteredResultsMetadata == null ? (class$com$metamatrix$jdbc$FilteredResultsMetadata = FilteredResultsMetadata.class$("com.metamatrix.jdbc.FilteredResultsMetadata")) : class$com$metamatrix$jdbc$FilteredResultsMetadata, new Class[]{class$com$metamatrix$jdbc$api$ResultSetMetaData == null ? (class$com$metamatrix$jdbc$api$ResultSetMetaData = FilteredResultsMetadata.class$("com.metamatrix.jdbc.api.ResultSetMetaData")) : class$com$metamatrix$jdbc$api$ResultSetMetaData, Integer.TYPE, class$com$metamatrix$core$log$Logger == null ? (class$com$metamatrix$core$log$Logger = FilteredResultsMetadata.class$("com.metamatrix.core.log.Logger")) : class$com$metamatrix$core$log$Logger}, new Object[]{rsmd, new Integer(actualColumnCount), logger});
        }
        return new FilteredResultsMetadata(rsmd, actualColumnCount, logger);
    }

    FilteredResultsMetadata(ResultSetMetaData rsmd, int actualColumnCount, Logger logger) {
        this.delegate = rsmd;
        this.actualColumnCount = actualColumnCount;
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getColumnCount() throws SQLException {
        return this.actualColumnCount;
    }

    private void verifyColumnIndex(int index) throws SQLException {
        if (index > this.actualColumnCount) {
            throw new SQLException(JDBCPlugin.Util.getString("FilteredResultsMetadata.Invalid_index", index));
        }
    }

    public String getVirtualDatabaseName(int index) throws SQLException {
        this.verifyColumnIndex(index);
        return this.delegate.getVirtualDatabaseName(index);
    }

    public String getVirtualDatabaseVersion(int index) throws SQLException {
        this.verifyColumnIndex(index);
        return this.delegate.getVirtualDatabaseVersion(index);
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isAutoIncrement(column);
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isCaseSensitive(column);
    }

    public boolean isSearchable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isSearchable(column);
    }

    public boolean isCurrency(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isCurrency(column);
    }

    public int isNullable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isNullable(column);
    }

    public boolean isSigned(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isSigned(column);
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnDisplaySize(column);
    }

    public String getColumnLabel(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnLabel(column);
    }

    public String getColumnName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnName(column);
    }

    public String getSchemaName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getSchemaName(column);
    }

    public int getPrecision(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getPrecision(column);
    }

    public int getScale(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getScale(column);
    }

    public String getTableName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getTableName(column);
    }

    public String getCatalogName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getCatalogName(column);
    }

    public int getColumnType(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnType(column);
    }

    public String getColumnTypeName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnTypeName(column);
    }

    public boolean isReadOnly(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isReadOnly(column);
    }

    public boolean isWritable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isWritable(column);
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isDefinitelyWritable(column);
    }

    public String getColumnClassName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnClassName(column);
    }

    public int getParameterCount() {
        return this.delegate.getParameterCount();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

