/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.client.impl;

import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.client.PortableContext;
import com.metamatrix.dqp.client.impl.PortableStringUtil;
import com.metamatrix.dqp.client.impl.ServerConnectionInfo;
import java.util.Properties;

class ServerSessionContext
implements PortableContext {
    private static final String HEADER = "ServerSessionContext:";
    private ServerConnectionInfo connectionInfo;
    private String connectionContext;
    private String instanceContext;

    ServerSessionContext(ServerConnectionInfo connInfo, String connectionContext) {
        this.connectionInfo = connInfo;
        this.connectionContext = connectionContext;
    }

    ServerSessionContext(PortableContext context) throws MetaMatrixProcessingException {
        String[] parts = PortableStringUtil.getParts(context.getPortableString(), PortableStringUtil.CTX_SEPARATOR);
        if (parts == null || parts.length != 2 || !parts[0].startsWith(HEADER)) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerSessionContext.invalid_context", context.getPortableString()));
        }
        parts[0] = parts[0].substring(HEADER.length());
        this.connectionInfo = new ServerConnectionInfo(parts[0]);
        this.connectionContext = PortableStringUtil.unescapeString(parts[1]);
        if (parts.length == 3) {
            this.instanceContext = PortableStringUtil.unescapeString(parts[2]);
        }
    }

    String getConnectionContext() {
        return this.connectionContext;
    }

    Properties getConnectionProperties() {
        return this.connectionInfo.getConnectionProperties();
    }

    void setInstanceContext(String context) {
        this.instanceContext = context;
    }

    String getInstanceContext() {
        return this.instanceContext;
    }

    String getUserName() {
        return this.connectionInfo.getUser();
    }

    String getVDBName() {
        return this.connectionInfo.getVDBName();
    }

    String getVDBVersion() {
        return this.connectionInfo.getVDBVersion();
    }

    public String getPortableString() {
        StringBuffer buf = new StringBuffer(HEADER).append(this.connectionInfo.getPortableString()).append(PortableStringUtil.CTX_SEPARATOR).append(PortableStringUtil.escapeString(this.connectionContext));
        if (this.instanceContext != null) {
            buf.append(PortableStringUtil.CTX_SEPARATOR).append(PortableStringUtil.escapeString(this.instanceContext));
        }
        return buf.toString();
    }

    public int hashCode() {
        int hash = HashCodeUtil.hashCode(0, this.connectionInfo);
        return HashCodeUtil.hashCode(hash, this.connectionContext);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ServerSessionContext)) {
            return false;
        }
        ServerSessionContext context = (ServerSessionContext)obj;
        return EquivalenceUtil.areEqual(this.connectionInfo, context.connectionInfo) && EquivalenceUtil.areEqual(this.connectionContext, context.connectionContext);
    }

    static ServerSessionContext createSessionContextFromPortableContext(PortableContext context) throws MetaMatrixProcessingException {
        if (context == null) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerSessionContext.null_context"));
        }
        if (context instanceof ServerSessionContext) {
            return (ServerSessionContext)context;
        }
        return new ServerSessionContext(context);
    }
}

