/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.client.impl;

import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.lob.LobChunkProducer;
import com.metamatrix.common.types.Streamable;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.client.impl.ResponseReceiver;
import com.metamatrix.dqp.client.impl.ServerFacadeImpl;
import com.metamatrix.dqp.message.CloseLobRequestMessage;
import com.metamatrix.dqp.message.LobRequestMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.ResultsMessage;
import java.io.IOException;

public class FacadeLobChunkProducer
implements LobChunkProducer {
    static int counter = 0;
    int streamRequestId = counter++;
    Streamable streamable = null;
    long requestId;
    ServerFacadeImpl.ConnectionHolder connectionHolder;

    public FacadeLobChunkProducer(Streamable streamable, long requestId, ServerFacadeImpl.ConnectionHolder connectionHolder) {
        this.streamable = streamable;
        this.requestId = requestId;
        this.connectionHolder = connectionHolder;
    }

    public LobChunk getNextChunk() throws IOException {
        try {
            LobRequestMessage request = new LobRequestMessage();
            request.setStreamId(this.streamable.getReferenceStreamId());
            request.setStreamRequestId(this.streamRequestId);
            request.setRequestID(new RequestID(this.requestId));
            request.setMessageKey("LOB_" + this.requestId);
            ResponseReceiver receiver = new ResponseReceiver();
            this.connectionHolder.getConnection().send(request, receiver, request.getMessageKey(), this.connectionHolder.getInstance());
            ResultsMessage response = ResponseReceiver.waitForResponseMessage(receiver, 0L);
            if (response == null) {
                throw new IOException("no_response_server");
            }
            if (response.getException() != null) {
                throw new IOException(response.getException().getMessage());
            }
            return response.getLobChunk();
        }
        catch (Exception e) {
            IOException ex = new IOException(DQPPlugin.Util.getString("Unable_to_read_data_from_stream", e.getMessage()));
            ex.initCause(e);
            throw ex;
        }
    }

    public void close() throws IOException {
        try {
            CloseLobRequestMessage request = new CloseLobRequestMessage();
            request.setStreamId(this.streamable.getReferenceStreamId());
            request.setStreamRequestId(this.streamRequestId);
            request.setRequestID(new RequestID(this.requestId));
            request.setMessageKey("LOB_" + this.requestId);
            ResponseReceiver receiver = new ResponseReceiver();
            this.connectionHolder.getConnection().send(request, receiver, request.getMessageKey(), this.connectionHolder.getInstance());
        }
        catch (CommunicationException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }
}

