/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.queue;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import com.metamatrix.common.queue.WorkerPoolStats;

class MonitoredChannel
implements Channel {
    private Channel channel;
    private Object statsLock = new Object();
    private int enqueues = 0;
    private int dequeues = 0;
    private int highwaterMark = 0;
    private int size = 0;
    private int totalHighwaterMark = 0;
    private long totalEnqueues = 0L;
    private long totalDequeues = 0L;

    public MonitoredChannel(Channel channel) {
        this.channel = channel;
    }

    public void put(Object arg0) throws InterruptedException {
        this.channel.put(arg0);
        this.markEnqueue();
    }

    public boolean offer(Object arg0, long arg1) throws InterruptedException {
        boolean accepted = this.channel.offer(arg0, arg1);
        if (accepted) {
            this.markEnqueue();
        }
        return accepted;
    }

    public Object poll(long arg0) throws InterruptedException {
        Object obj = this.channel.poll(arg0);
        if (obj != null) {
            this.markDequeue();
        }
        return obj;
    }

    public Object take() throws InterruptedException {
        Object obj = this.channel.take();
        if (obj != null) {
            this.markDequeue();
        }
        return obj;
    }

    public Object peek() {
        return this.channel.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markEnqueue() {
        Object object = this.statsLock;
        synchronized (object) {
            ++this.size;
            ++this.enqueues;
            ++this.totalEnqueues;
            if (this.size > this.highwaterMark) {
                this.highwaterMark = this.size;
                if (this.size > this.totalHighwaterMark) {
                    this.totalHighwaterMark = this.size;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDequeue() {
        Object object = this.statsLock;
        synchronized (object) {
            --this.size;
            ++this.dequeues;
            ++this.totalDequeues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fillStats(WorkerPoolStats stats) {
        Object object = this.statsLock;
        synchronized (object) {
            stats.enqueues = this.enqueues;
            stats.dequeues = this.dequeues;
            stats.highwaterMark = this.highwaterMark;
            stats.queued = this.size;
            stats.totalEnqueues = this.totalEnqueues;
            stats.totalDequeues = this.totalDequeues;
            stats.totalHighwaterMark = this.totalHighwaterMark;
            this.enqueues = 0;
            this.dequeues = 0;
            this.highwaterMark = 0;
        }
    }
}

