/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.service;

import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerInstance;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.core.proxy.ServiceInvocation;
import com.metamatrix.core.proxy.ServiceInvocationStruct;
import com.metamatrix.core.proxy.TerminalServiceInterceptor;
import java.io.Serializable;

public abstract class AbstractMessageClientInterceptor
implements TerminalServiceInterceptor {
    private String subSelector;

    AbstractMessageClientInterceptor(String subSelector) {
        this.subSelector = subSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ServiceInvocation invocation) throws Throwable {
        this.startingInvocation();
        try {
            ServerConnection serverConnection = this.getServerConnection();
            ServerInstance serverInstance = serverConnection.selectServerInstance(this.subSelector);
            MessageHolder requestMessage = this.createRequestMessage(invocation);
            MessageHolder responseMessage = (MessageHolder)serverConnection.send(requestMessage, serverInstance);
            Serializable result = this.getResult(responseMessage);
            if (result instanceof ExceptionHolder) {
                throw ((ExceptionHolder)result).exception;
            }
            Serializable serializable = result;
            return serializable;
        }
        finally {
            this.endingInvocation();
        }
    }

    protected MessageHolder createRequestMessage(ServiceInvocation invocation) {
        ServiceInvocationStruct serializedInvocation = invocation.toStruct();
        MessageHolder message = new MessageHolder();
        message.contents = serializedInvocation;
        return message;
    }

    private Serializable getResult(MessageHolder responseMessage) {
        return responseMessage.contents;
    }

    protected abstract void endingInvocation();

    protected abstract void startingInvocation();

    protected abstract ServerConnection getServerConnection() throws ConnectionException, CommunicationException;
}

