/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.server;

import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.platform.server.MessageServiceAgent;
import com.metamatrix.core.proxy.ServiceEndpoint;
import com.metamatrix.core.proxy.ServiceInterceptor;
import com.metamatrix.core.proxy.ServiceInvocationStruct;
import com.metamatrix.core.proxy.TerminalServiceInterceptor;

public class FilteringMessageServiceAgent
extends MessageServiceAgent
implements ServerListener {
    private ServerListener nextServerListener;

    public FilteringMessageServiceAgent(Class serviceInterface, ServiceInterceptor[] interceptors, TerminalServiceInterceptor terminalInterceptor, ServerListener nextServerListener) {
        super(serviceInterface, interceptors, terminalInterceptor);
        this.nextServerListener = nextServerListener;
    }

    public void receive(ClientConnection connection, Message message, String messageKey) {
        this.nextServerListener.receive(connection, message, messageKey);
    }

    public Message receive(ClientConnection connection, Message message) throws ApplicationException {
        if (message instanceof MessageHolder) {
            ServiceInvocationStruct serviceInvocationStruct;
            MessageHolder requestMessage = (MessageHolder)message;
            if (requestMessage.contents instanceof ServiceInvocationStruct && ServiceEndpoint.matches(serviceInvocationStruct = (ServiceInvocationStruct)requestMessage.contents, this.serviceInterface)) {
                return super.receive(connection, message);
            }
        }
        return this.nextServerListener.receive(connection, message);
    }

    public void connectionAdded(ClientConnection connection) {
        this.nextServerListener.connectionAdded(connection);
    }

    public void connectionRemoved(ClientConnection connection) {
        this.nextServerListener.connectionRemoved(connection);
    }

    public String toString() {
        return "FilteringMessageServiceAgent:  className= " + this.serviceInterface.getName() + " next= " + this.nextServerListener;
    }
}

