/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.api;

import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.core.util.HashCodeUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostInfo {
    public static final String DEFAULT_CLUSTER = "DEFAULT_CLUSTER";
    private String hostName = "";
    private InetAddress inetAddress;
    private int portNumber = 0;
    private boolean ssl = false;
    private String clusterName = "DEFAULT_CLUSTER";

    public HostInfo(String host, String port) {
        this.hostName = this.getLocalHost(host);
        try {
            this.inetAddress = InetAddress.getByName(this.hostName);
        }
        catch (UnknownHostException err) {
            // empty catch block
        }
        try {
            this.portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            this.portNumber = 0;
            throw new IllegalArgumentException("port must be numeric:" + port);
        }
    }

    public HostInfo(String host, int port) {
        this.hostName = this.getLocalHost(host);
        try {
            this.inetAddress = InetAddress.getByName(this.hostName);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.portNumber = port;
    }

    public HostInfo(String host, int port, InetAddress inetAddress) {
        this.hostName = this.getLocalHost(host);
        this.inetAddress = inetAddress;
        this.portNumber = port;
        this.validateHostInfo();
    }

    public HostInfo(String host, int port, InetAddress inetAddress, String cluster, boolean ssl) {
        this.hostName = this.getLocalHost(host);
        this.portNumber = port;
        this.inetAddress = inetAddress;
        this.clusterName = cluster;
        this.ssl = ssl;
        this.validateHostInfo();
    }

    public void validateHostInfo() {
        if (this.portNumber < 0 || this.portNumber > 65535) {
            throw new IllegalArgumentException("port out of range:" + this.portNumber);
        }
        if (this.hostName == null) {
            throw new IllegalArgumentException("hostname can't be null");
        }
    }

    private String getLocalHost(String host) {
        String result = null;
        if (host == null || host.equals("")) {
            throw new IllegalArgumentException("hostname can't be null");
        }
        try {
            result = host.equalsIgnoreCase("localhost") ? InetAddress.getLocalHost().getHostName() : host.toLowerCase();
        }
        catch (UnknownHostException err) {
            throw new MetaMatrixRuntimeException(err, err.getMessage());
        }
        return result;
    }

    public void setHostName(String theHostName) {
        this.hostName = theHostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setPortNumber(int thePortNumber) {
        this.portNumber = thePortNumber;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setSSL(boolean ssl) {
        this.ssl = ssl;
    }

    public void setClusterName(String name) {
        this.clusterName = name;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public boolean getSSL() {
        return this.ssl;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("HostInfo: ");
        sb.append(" hostName:  " + this.hostName);
        sb.append(" portNumber:  " + this.portNumber);
        sb.append(" inetAddress: ");
        if (this.inetAddress != null) {
            sb.append(this.inetAddress);
        }
        sb.append(" ssl:  " + this.ssl);
        sb.append(" clusterName:  " + this.clusterName);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        HostInfo hostInfo = (HostInfo)obj;
        if (this.inetAddress == null || hostInfo.getInetAddress() == null) {
            return this.hostName.equals(hostInfo.getHostName()) && this.portNumber == hostInfo.getPortNumber() && this.ssl == hostInfo.ssl;
        }
        return this.inetAddress.equals(hostInfo.getInetAddress()) && this.portNumber == hostInfo.getPortNumber() && this.ssl == hostInfo.ssl;
    }

    public int hashCode() {
        int hc = 0;
        hc = this.inetAddress != null ? HashCodeUtil.hashCode(hc, this.inetAddress.getHostAddress()) : HashCodeUtil.hashCode(hc, this.hostName);
        hc = HashCodeUtil.hashCode(hc, this.portNumber);
        hc = HashCodeUtil.hashCode(hc, this.ssl);
        return hc;
    }
}

