/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;

public class ImportPackageSpecificationImpl
extends VersionConstraintImpl
implements ImportPackageSpecification {
    private static final String ALL_PACKAGES = "*";
    private String resolution = "static";
    private String symbolicName;
    private VersionRange bundleVersionRange;
    private Map attributes;

    public Map getDirectives() {
        HashMap<String, String> result = new HashMap<String, String>(5);
        if (this.resolution != null) {
            result.put("resolution", this.resolution);
        }
        return result;
    }

    public Object getDirective(String key) {
        if (key.equals("resolution")) {
            return this.resolution;
        }
        return null;
    }

    public Object setDirective(String key, Object value) {
        if (key.equals("resolution")) {
            this.resolution = (String)value;
            return this.resolution;
        }
        return null;
    }

    public void setDirectives(Map directives) {
        if (directives == null) {
            return;
        }
        this.resolution = (String)directives.get("resolution");
    }

    public String getBundleSymbolicName() {
        return this.symbolicName;
    }

    public VersionRange getBundleVersionRange() {
        if (this.bundleVersionRange == null) {
            return VersionRange.emptyRange;
        }
        return this.bundleVersionRange;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public boolean isSatisfiedBy(BaseDescription supplier) {
        String[] mandatory;
        String name;
        boolean strict;
        if (!(supplier instanceof ExportPackageDescription)) {
            return false;
        }
        ExportPackageDescription pkgDes = (ExportPackageDescription)supplier;
        String[] friends = (String[])pkgDes.getDirective("x-friends");
        Boolean internal = (Boolean)pkgDes.getDirective("x-internal");
        if ((internal.booleanValue() || friends != null) && (strict = ((StateImpl)this.getBundle().getContainingState()).inStrictMode())) {
            if (internal.booleanValue()) {
                return false;
            }
            boolean found = false;
            if (friends != null) {
                for (int i = 0; i < friends.length; ++i) {
                    if (!this.getBundle().getSymbolicName().equals(friends[i])) continue;
                    found = true;
                }
            }
            if (!found) {
                return false;
            }
        }
        boolean matchName = false;
        if (this.symbolicName != null) {
            BundleDescription exporter = pkgDes.getExporter();
            if (!this.symbolicName.equals(exporter.getSymbolicName())) {
                return false;
            }
            if (this.getBundleVersionRange() != null && !this.getBundleVersionRange().isIncluded(exporter.getVersion())) {
                return false;
            }
        }
        if (ALL_PACKAGES.equals(name = this.getName()) || ALL_PACKAGES.equals(pkgDes.getName())) {
            matchName = true;
        } else if (name.endsWith(".*")) {
            if (pkgDes.getName().startsWith(name.substring(0, name.length() - 1))) {
                matchName = true;
            }
        } else if (pkgDes.getName().equals(name)) {
            matchName = true;
        } else if (pkgDes.getName().endsWith(".*") && name.startsWith(pkgDes.getName().substring(0, name.length() - 1))) {
            matchName = true;
        }
        if (!matchName) {
            return false;
        }
        if (this.getVersionRange() != null && !this.getVersionRange().isIncluded(pkgDes.getVersion())) {
            return false;
        }
        Map importAttrs = this.getAttributes();
        if (importAttrs != null) {
            Map exportAttrs = pkgDes.getAttributes();
            if (exportAttrs == null) {
                return false;
            }
            Iterator i = importAttrs.keySet().iterator();
            while (i.hasNext()) {
                String importKey = (String)i.next();
                String importValue = (String)importAttrs.get(importKey);
                String exportValue = (String)exportAttrs.get(importKey);
                if (exportValue != null && importValue.equals(exportValue)) continue;
                return false;
            }
        }
        if ((mandatory = (String[])pkgDes.getDirective("mandatory")) != null) {
            for (int i = 0; i < mandatory.length; ++i) {
                if ("bundle-symbolic-name".equals(mandatory[i])) {
                    if (this.symbolicName != null) continue;
                    return false;
                }
                if ("bundle-version".equals(mandatory[i])) {
                    if (this.bundleVersionRange != null) continue;
                    return false;
                }
                if ("specification-version".equals(mandatory[i]) || "version".equals(mandatory[i])) {
                    if (this.getVersionRange() != null) continue;
                    return false;
                }
                if (importAttrs == null) {
                    return false;
                }
                if (importAttrs.get(mandatory[i]) != null) continue;
                return false;
            }
        }
        return true;
    }

    protected void setBundleSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    protected void setBundleVersionRange(VersionRange bundleVersionRange) {
        this.bundleVersionRange = bundleVersionRange;
    }

    protected void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        return "Import-Package: " + this.getName() + " - version: " + this.getVersionRange();
    }
}

