/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.ConsoleMsg;
import org.eclipse.osgi.framework.internal.core.FrameworkConsole;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class FrameworkCommandInterpreter
implements CommandInterpreter {
    private StringTokenizer tok;
    private Object[] commandProviders;
    private FrameworkConsole con;
    private PrintWriter out;
    private String tab = "\t";
    private String newline = "\r\n";
    private boolean firstCommand = true;
    protected static int maxLineCount;
    protected int currentLineCount;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$console$CommandInterpreter;
    static /* synthetic */ Class class$java$lang$Throwable;

    public FrameworkCommandInterpreter(String cmdline, Object[] commandProviders, FrameworkConsole con) {
        this.tok = new StringTokenizer(cmdline);
        this.commandProviders = commandProviders;
        this.con = con;
        this.out = con.getWriter();
    }

    public String nextArgument() {
        if (this.tok == null || !this.tok.hasMoreElements()) {
            return null;
        }
        String token = this.tok.nextToken();
        int index = token.indexOf(34);
        if (index != -1) {
            if (index == token.lastIndexOf(34)) {
                token = token + this.tok.nextToken("\"");
            }
            StringBuffer buf = new StringBuffer(token);
            while (index != -1) {
                buf.deleteCharAt(index);
                token = buf.toString();
                index = token.indexOf(34);
            }
            return buf.toString();
        }
        return token;
    }

    public Object execute(String cmd) {
        int i;
        if (!this.firstCommand) {
            return this.innerExecute(cmd);
        }
        this.firstCommand = false;
        this.resetLineCount();
        Object retval = null;
        if (cmd.equalsIgnoreCase("more")) {
            try {
                this._more();
            }
            catch (Exception e) {
                this.printStackTrace(e);
            }
            return retval;
        }
        if (cmd.equalsIgnoreCase("disconnect") && this.con.getUseSocketStream()) {
            try {
                this._disconnect();
            }
            catch (Exception e) {
                this.printStackTrace(e);
            }
            return retval;
        }
        Class[] parameterTypes = new Class[]{class$org$eclipse$osgi$framework$console$CommandInterpreter == null ? (class$org$eclipse$osgi$framework$console$CommandInterpreter = FrameworkCommandInterpreter.class$("org.eclipse.osgi.framework.console.CommandInterpreter")) : class$org$eclipse$osgi$framework$console$CommandInterpreter};
        Object[] parameters = new Object[]{this};
        boolean executed = false;
        int size = this.commandProviders.length;
        for (i = 0; !executed && i < size; ++i) {
            try {
                Object target = this.commandProviders[i];
                Method method = target.getClass().getMethod("_" + cmd, parameterTypes);
                retval = method.invoke(target, parameters);
                executed = true;
                continue;
            }
            catch (NoSuchMethodException ite) {
                continue;
            }
            catch (InvocationTargetException ite) {
                executed = true;
                this.printStackTrace(ite.getTargetException());
                continue;
            }
            catch (Exception ee) {
                executed = true;
                this.printStackTrace(ee);
            }
        }
        if (!executed) {
            for (i = 0; i < size; ++i) {
                try {
                    CommandProvider commandProvider = (CommandProvider)this.commandProviders[i];
                    this.out.print(commandProvider.getHelp());
                    this.out.flush();
                    continue;
                }
                catch (Exception ee) {
                    this.printStackTrace(ee);
                }
            }
            this.out.print(this.getHelp());
            this.out.flush();
        }
        return retval;
    }

    private Object innerExecute(String cmd) {
        FrameworkCommandInterpreter intcp;
        String command;
        if (cmd != null && cmd.length() > 0 && (command = (intcp = new FrameworkCommandInterpreter(cmd, this.commandProviders, this.con)).nextArgument()) != null) {
            return intcp.execute(command);
        }
        return null;
    }

    private int getMaximumLinesToScroll() {
        return maxLineCount;
    }

    private void setMaximumLinesToScroll(int lines) {
        if (lines < 0) {
            throw new IllegalArgumentException(ConsoleMsg.CONSOLE_LINES_TO_SCROLL_NEGATIVE_ERROR);
        }
        maxLineCount = lines;
    }

    private void resetLineCount() {
        this.currentLineCount = 0;
    }

    private void printline(Object o) {
        this.print(o + this.newline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object o) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.check4More();
            this.out.print(o);
            this.out.flush();
        }
    }

    public void println() {
        this.println("");
    }

    public void printStackTrace(Throwable t) {
        t.printStackTrace(this.out);
        Method[] methods = t.getClass().getMethods();
        int size = methods.length;
        Class throwable = class$java$lang$Throwable == null ? (class$java$lang$Throwable = FrameworkCommandInterpreter.class$("java.lang.Throwable")) : class$java$lang$Throwable;
        for (int i = 0; i < size; ++i) {
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !method.getName().startsWith("get") || !throwable.isAssignableFrom(method.getReturnType()) || method.getParameterTypes().length != 0) continue;
            try {
                Throwable nested = (Throwable)method.invoke((Object)t, null);
                if (nested == null || nested == t) continue;
                this.out.println(ConsoleMsg.CONSOLE_NESTED_EXCEPTION);
                this.printStackTrace(nested);
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object o) {
        if (o == null) {
            return;
        }
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.check4More();
            this.printline(o);
            ++this.currentLineCount;
            this.currentLineCount += o.toString().length() / 80;
        }
    }

    public void printDictionary(Dictionary dic, String title) {
        if (dic == null) {
            return;
        }
        int count = dic.size();
        Object[] keys = new String[count];
        Enumeration keysEnum = dic.keys();
        int i = 0;
        while (keysEnum.hasMoreElements()) {
            keys[i++] = (String)keysEnum.nextElement();
        }
        Util.sort(keys);
        if (title != null) {
            this.println(title);
        }
        for (i = 0; i < count; ++i) {
            this.println(" " + (String)keys[i] + " = " + dic.get(keys[i]));
        }
        this.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printBundleResource(Bundle bundle, String resource) {
        URL entry = null;
        entry = bundle.getEntry(resource);
        if (entry != null) {
            try {
                this.println(resource);
                InputStream in = entry.openStream();
                byte[] buffer = new byte[1024];
                int read = 0;
                try {
                    while ((read = in.read(buffer)) != -1) {
                        this.print(new String(buffer, 0, read));
                    }
                    Object var8_8 = null;
                    if (in == null) return;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    in.close();
                    return;
                }
                catch (IOException e) {}
                return;
            }
            catch (Exception e) {
                System.err.println(NLS.bind(ConsoleMsg.CONSOLE_ERROR_READING_RESOURCE, resource));
            }
            return;
        }
        this.println(NLS.bind(ConsoleMsg.CONSOLE_RESOURCE_NOT_IN_BUNDLE, resource, bundle.toString()));
    }

    private void check4More() {
        int max = this.getMaximumLinesToScroll();
        if (max > 0 && this.currentLineCount >= max) {
            this.out.print(ConsoleMsg.CONSOLE_MORE);
            this.out.flush();
            this.con.getInput();
            this.resetLineCount();
        }
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer(256);
        help.append(this.newline);
        help.append(ConsoleMsg.CONSOLE_HELP_CONTROLLING_CONSOLE_HEADING);
        help.append(this.newline);
        help.append(this.tab);
        help.append("more - ");
        help.append(ConsoleMsg.CONSOLE_HELP_MORE);
        if (this.con.getUseSocketStream()) {
            help.append(this.newline);
            help.append(this.tab);
            help.append("disconnect - ");
            help.append(ConsoleMsg.CONSOLE_HELP_DISCONNECT);
        }
        return help.toString();
    }

    public void _more() throws Exception {
        if (this.confirm(ConsoleMsg.CONSOLE_CONFIRM_MORE, true)) {
            int lines = this.prompt(this.newline + ConsoleMsg.CONSOLE_MORE_ENTER_LINES, 24);
            this.setMaximumLinesToScroll(lines);
        } else {
            this.setMaximumLinesToScroll(0);
        }
    }

    private void _disconnect() throws Exception {
        if (this.confirm(ConsoleMsg.CONSOLE_CONFIRM_DISCONNECT, true)) {
            this.con.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean confirm(String string, boolean defaultAnswer) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            if (string.length() > 0) {
                this.print(string);
            } else {
                this.print(ConsoleMsg.CONSOLE_CONFIRM);
            }
            this.print(" (" + ConsoleMsg.CONSOLE_CONFIRM_VALUES);
            if (defaultAnswer) {
                this.print(ConsoleMsg.CONSOLE_Y + ") ");
            } else {
                this.print(ConsoleMsg.CONSOLE_N + ") ");
            }
        }
        String input = this.con.getInput();
        this.resetLineCount();
        if (input.length() == 0) {
            return defaultAnswer;
        }
        return input.toLowerCase().charAt(0) == ConsoleMsg.CONSOLE_Y.charAt(0);
    }

    protected String prompt(String string, String defaultAnswer) {
        if (string.length() > 0) {
            if (defaultAnswer.length() > 0) {
                StringBuffer buf = new StringBuffer(256);
                buf.append(string);
                buf.append(" ");
                buf.append(ConsoleMsg.CONSOLE_PROMPT_DEFAULT);
                buf.append("=");
                buf.append(defaultAnswer);
                buf.append(") ");
                this.print(buf.toString());
            } else {
                this.print(string);
            }
        }
        String input = this.con.getInput();
        this.resetLineCount();
        if (input.length() > 0) {
            return input;
        }
        return defaultAnswer;
    }

    protected int prompt(String string, int defaultAnswer) {
        Integer i = new Integer(defaultAnswer);
        for (int j = 0; j < 3; ++j) {
            String s = this.prompt(string, i.toString());
            try {
                int answer = Integer.parseInt(s);
                if (answer >= 0) {
                    return answer;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.println(ConsoleMsg.CONSOLE_INVALID_INPUT);
        }
        this.println(ConsoleMsg.CONSOLE_TOO_MUCH_INVALID_INPUT);
        return defaultAnswer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

