/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.common.types.MMJDBCSQLTypeInfo;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.log.Logger;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.message.XMLSchemaMessage;
import com.metamatrix.dqp.metadata.ResultsMetadataConstants;
import com.metamatrix.dqp.metadata.ResultsMetadataDefaults;
import com.metamatrix.jdbc.BaseDriver;
import com.metamatrix.jdbc.CursorResultsImpl;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.ResultsImpl;
import com.metamatrix.jdbc.ResultsMetadataWithProvider;
import com.metamatrix.jdbc.StaticMetadataProvider;
import com.metamatrix.jdbc.api.DatabaseMetaData;
import com.metamatrix.jdbc.api.ResultSetMetaData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MMDatabaseMetaData
implements DatabaseMetaData {
    private static final String PERCENT = "%";
    private static final int NO_LIMIT = 0;
    private static final String SCHEMA_TERM = "VirtualDatabase";
    private static final String EMPTY_STRING = "";
    private static final String ESCAPE_SEARCH_STRING = "\\";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String EXTRA_CHARS = ".@";
    private static final String KEY_WORDS = "OPTION, SHOWPLAN, DEBUG";
    private static final String PROCEDURE_TERM = "StoredProcedure";
    private static final String NUMERIC_FUNCTIONS = "ABS, ACOS, ASIN, ATAN, ATAN2, BITAND, BITNOT, BITOR, BITXOR, CEILING, COS, COT, DEGREES, EXP, FLOOR, FORMATBIGDECIMAL, FORMATBIGINTEGER, FORMATDOUBLE, FORMATFLOAT, FORMATINTEGER, FORMATLONG, LOG, LOG10, MOD, PARSEBIGDECIMAL, PARSEBIGINTEGER, PARSEDOUBLE, PARSEFLOAT, PARSEINTEGER, PARSELONG, PI, POWER, RADIANS, RAND, ROUND, SIGN, SIN, SQRT, TAN";
    private static final String STRING_FUNCTIONS = "ASCII, CHR, CHAR, CONCAT, INITCAP, INSERT, LCASE, LEFT, LENGTH, LOCATE, LOWER, LPAD, LTRIM, REPEAT, REPLACE, RIGHT, RPAD, RTRIM, SUBSTRING, TRANSLATE, UCASE, UPPER";
    private static final String DATE_FUNCTIONS = "CURDATE, CURTIME, NOW, DAYNAME, DAYOFMONTH, DAYOFWEEK, DAYOFYEAR, FORMATDATE, FORMATTIME, FORMATTIMESTAMP, HOUR, MINUTE, MONTH, MONTHNAME, PARSEDATE, PARSETIME, PARSETIMESTAMP, QUARTER, SECOND, TIMESTAMPADD, TIMESTAMPDIFF, WEEK, YEAR";
    private static final String SYSTEM_FUNCTIONS = "CAST, CONVERT, DECODESTRING, DECODEINTEGER, IFNULL, NVL, LOOKUP";
    private static final int MAX_CATALOG_NAME_LENGTH = 0;
    private static final int MAX_PROCEDURE_NAME_LENGTH = 255;
    private static final int MAX_TABLE_NAME_LENGTH = 255;
    private static final int MAX_COLUMN_NAME_LENGTH = 255;
    private static final int MAX_USER_NAME_LENGTH = 255;
    private static final String LIKE_ESCAPE = " LIKE ? ESCAPE '\\' ";
    private static final String TYPE_MAPPING;
    private static final String PRECISION_MAPPING;
    private static final String NULLABILITY_MAPPING;
    private static final String PROC_COLUMN_NULLABILITY_MAPPING;
    private static final String PARAM_DIRECTION_MAPPING;
    private static final String DATATYPES_WITH_NO_PRECISION;
    private static final String QUERY_REFERENCE_KEYS;
    private static final String QUERY_CROSS_REFERENCES;
    private static final String QUERY_EXPORTED_KEYS;
    private static final String QUERY_IMPORTED_KEYS;
    private static final String QUERY_COLUMNS;
    private static final String QUERY_INDEX_INFO;
    private static final String QUERY_MODELS;
    private static final String QUERY_PRIMARY_KEYS;
    private static final String QUERY_PROCEDURES;
    private static final String QUERY_PROCEDURE_COLUMNS;
    private static final String QUERY_SCHEMAS;
    private static final String QUERY_TABLES;
    private MMConnection driverConnection;
    private BaseDriver driver;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMDatabaseMetaData;
    static /* synthetic */ Class class$com$metamatrix$jdbc$BaseDriver;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMConnection;

    static MMDatabaseMetaData newInstance(BaseDriver driver, MMConnection connection) throws SQLException {
        if (AOP.useproxy()) {
            return (MMDatabaseMetaData)ProxyFactory.extend(class$com$metamatrix$jdbc$MMDatabaseMetaData == null ? (class$com$metamatrix$jdbc$MMDatabaseMetaData = MMDatabaseMetaData.class$("com.metamatrix.jdbc.MMDatabaseMetaData")) : class$com$metamatrix$jdbc$MMDatabaseMetaData, new Class[]{class$com$metamatrix$jdbc$BaseDriver == null ? (class$com$metamatrix$jdbc$BaseDriver = MMDatabaseMetaData.class$("com.metamatrix.jdbc.BaseDriver")) : class$com$metamatrix$jdbc$BaseDriver, class$com$metamatrix$jdbc$MMConnection == null ? (class$com$metamatrix$jdbc$MMConnection = MMDatabaseMetaData.class$("com.metamatrix.jdbc.MMConnection")) : class$com$metamatrix$jdbc$MMConnection}, new Object[]{driver, connection});
        }
        return new MMDatabaseMetaData(driver, connection);
    }

    MMDatabaseMetaData(BaseDriver driver, MMConnection connection) throws SQLException {
        this.driver = driver;
        this.driverConnection = connection;
    }

    public Logger getLogger() {
        return this.driverConnection.getLogger();
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{this.getColumnMetadata(null, "SCOPE", "short", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "COLUMN_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "DATA_TYPE", "short", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "TYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "COLUMN_SIZE", "integer", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "BUFFER_LENGTH", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE), this.getColumnMetadata(null, "DECIMAL_DIGITS", "short", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "PSEUDO_COLUMN", "short", ResultsMetadataConstants.NULL_TYPES.NOT_NULL)};
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.Best_row_sucess", table);
        this.getLogger().log(4, logMsg);
        return this.createResultSet(records, metadataList);
    }

    public ResultSet getCatalogs() throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{this.getColumnMetadata(null, "TABLE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE)};
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.Catalog_success");
        this.getLogger().log(4, logMsg);
        return this.createResultSet(records, metadataList);
    }

    private ResultSet createResultSet(List records, Map[] columnMetadata) {
        ResultsMetadataWithProvider rsmd = ResultsMetadataWithProvider.newInstance(StaticMetadataProvider.createWithData(columnMetadata, 0, this.getLogger()), this.getLogger());
        return this.createResultSet(records, rsmd);
    }

    private ResultSet createResultSet(List records, java.sql.ResultSetMetaData rsmd) {
        ResultsMessage resultsMsg = this.createDummyResultsMessage(null, null, records);
        MMStatement stmt = MMStatement.newInstance(this.driverConnection, 1004, 1007);
        return CursorResultsImpl.newInstance(resultsMsg, stmt, (ResultSetMetaData)rsmd);
    }

    private ResultSet createEmptyResultSet(String[] columnNames, String[] dataTypes) throws SQLException {
        ResultsMessage resultsMsg = this.createDummyResultsMessage(columnNames, dataTypes, Collections.EMPTY_LIST);
        MMStatement stmt = MMStatement.newInstance(this.driverConnection, 1004, 1007);
        try {
            stmt.setFetchSize(500);
        }
        catch (SQLException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        Map[] metadata = new Map[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            metadata[i] = this.getColumnMetadata(null, columnNames[i], dataTypes[i], ResultsMetadataConstants.NULL_TYPES.UNKNOWN);
        }
        return CursorResultsImpl.newInstance(resultsMsg, stmt, ResultsMetadataWithProvider.newInstance(StaticMetadataProvider.createWithData(metadata, 0, this.getLogger()), this.getLogger()));
    }

    private ResultsMessage createDummyResultsMessage(String[] columnNames, String[] dataTypes, List records) {
        ResultsMessage resultsMsg = new ResultsMessage();
        resultsMsg.setColumnNames(columnNames);
        resultsMsg.setDataTypes(dataTypes);
        resultsMsg.setPartialResults(false);
        resultsMsg.setFirstRow(1);
        resultsMsg.setLastRow(records.size());
        resultsMsg.setFinalRow(records.size());
        resultsMsg.setResults(records.toArray(new List[records.size()]));
        resultsMsg.setFetchSize(500);
        return resultsMsg;
    }

    public String getCatalogSeparator() throws SQLException {
        return EMPTY_STRING;
    }

    public String getCatalogTerm() throws SQLException {
        return EMPTY_STRING;
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnName) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{this.getColumnMetadata(null, "TABLE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE), this.getColumnMetadata(null, "TABLE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE), this.getColumnMetadata(null, "TABLE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "COLUMN_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "GRANTOR", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE), this.getColumnMetadata(null, "GRANTEE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "PRIVILEGE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "IS_GRANTABLE", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE)};
        return this.createResultSet(records, metadataList);
    }

    public ResultSet getColumns(String catalog, String schema, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (catalog != null) {
            return this.emptyColumnsResultSet();
        }
        if (schema == null) {
            schema = PERCENT;
        }
        if (tableNamePattern == null) {
            tableNamePattern = PERCENT;
        }
        if (columnNamePattern == null) {
            columnNamePattern = PERCENT;
        }
        ArrayList records = new ArrayList();
        java.sql.ResultSetMetaData rmetadata = null;
        ResultsImpl results = null;
        PreparedStatement prepareQuery = null;
        try {
            prepareQuery = this.driverConnection.prepareStatement(QUERY_COLUMNS);
            prepareQuery.setObject(1, schema.toUpperCase());
            prepareQuery.setObject(2, tableNamePattern.toUpperCase());
            prepareQuery.setObject(3, columnNamePattern.toUpperCase());
            results = (ResultsImpl)prepareQuery.executeQuery();
            if (results.getException() != null) {
                throw results.getException();
            }
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(18);
                for (int i = 0; i < 18; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getCols_error", columnNamePattern, tableNamePattern, e.getMessage());
            this.getLogger().log(2, e, logMsg);
            throw MMSQLException.create(e, logMsg);
        }
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getCols_success", columnNamePattern, tableNamePattern);
        this.getLogger().log(4, logMsg);
        return this.createResultSet(records, rmetadata);
    }

    private ResultSet emptyColumnsResultSet() throws SQLException {
        String[] columnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
        String[] dataTypes = new String[]{"string", "string", "string", "string", "integer", "string", "integer", "integer", "integer", "integer", "integer", "string", "string", "integer", "integer", "integer", "integer", "string"};
        return this.createEmptyResultSet(columnNames, dataTypes);
    }

    public Connection getConnection() throws SQLException {
        return this.driverConnection;
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (primaryCatalog != null || foreignCatalog != null) {
            return this.emptyCrossReference();
        }
        if (primarySchema == null) {
            primarySchema = PERCENT;
        }
        if (foreignSchema == null) {
            foreignSchema = PERCENT;
        }
        if (primaryTable == null) {
            primaryTable = PERCENT;
        }
        if (foreignTable == null) {
            foreignTable = PERCENT;
        }
        ResultsImpl results = null;
        try {
            PreparedStatement prepareQuery = this.driverConnection.prepareStatement(QUERY_CROSS_REFERENCES);
            prepareQuery.setObject(1, primarySchema.toUpperCase());
            prepareQuery.setObject(2, foreignSchema.toUpperCase());
            prepareQuery.setObject(3, primaryTable.toUpperCase());
            prepareQuery.setObject(4, foreignTable.toUpperCase());
            results = (ResultsImpl)prepareQuery.executeQuery();
            if (results.getException() != null) {
                throw results.getException();
            }
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getCrossRef_error", primaryTable, foreignTable, e.getMessage());
            this.getLogger().log(2, e, logMsg);
            throw MMSQLException.create(e, logMsg);
        }
        ResultSet resultSet = this.getReferenceKeys(results);
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getCrossRef_success", primaryTable, foreignTable);
        this.getLogger().log(4, logMsg);
        return resultSet;
    }

    private ResultSet emptyCrossReference() throws SQLException {
        String[] columnNames = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        String[] dataTypes = new String[]{"string", "string", "string", "string", "string", "string", "string", "string", "short", "short", "short", "string", "string", "short"};
        return this.createEmptyResultSet(columnNames, dataTypes);
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.driver.getMinorVersion();
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.driver.getMajorVersion();
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public String getDatabaseProductName() throws SQLException {
        return this.driverConnection.getDatabaseName();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.driver.getMajorVersion() + "." + this.driver.getMinorVersion();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    public int getDriverMajorVersion() {
        return this.driver.getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return this.driver.getMinorVersion();
    }

    public String getDriverName() throws SQLException {
        return this.driver.getDriverName();
    }

    public String getDriverVersion() throws SQLException {
        return this.getDriverMajorVersion() + "." + this.getDriverMinorVersion();
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        if (catalog != null) {
            return this.emptyExportedKeys();
        }
        if (schema == null) {
            schema = PERCENT;
        }
        if (table == null) {
            table = PERCENT;
        }
        ResultsImpl results = null;
        try {
            PreparedStatement prepareQuery = this.driverConnection.prepareStatement(QUERY_EXPORTED_KEYS);
            prepareQuery.setObject(1, schema.toUpperCase());
            prepareQuery.setObject(2, table.toUpperCase());
            results = (ResultsImpl)prepareQuery.executeQuery();
            if (results.getException() != null) {
                throw results.getException();
            }
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getExpKey_error", table, e.getMessage());
            this.getLogger().log(2, e, logMsg);
            throw MMSQLException.create(e, logMsg);
        }
        ResultSet resultSet = this.getReferenceKeys(results);
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getExpKey_success", table);
        this.getLogger().log(4, logMsg);
        return resultSet;
    }

    private ResultSet emptyExportedKeys() throws SQLException {
        return this.emptyCrossReference();
    }

    public String getExtraNameCharacters() throws SQLException {
        return EXTRA_CHARS;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return DOUBLE_QUOTE;
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        if (catalog != null) {
            return this.emptyImportedKeys();
        }
        if (schema == null) {
            schema = PERCENT;
        }
        if (table == null) {
            table = PERCENT;
        }
        ResultsImpl results = null;
        try {
            PreparedStatement prepareQuery = this.driverConnection.prepareStatement(QUERY_IMPORTED_KEYS);
            prepareQuery.setObject(1, schema.toUpperCase());
            prepareQuery.setObject(2, table.toUpperCase());
            results = (ResultsImpl)prepareQuery.executeQuery();
            if (results.getException() != null) {
                throw results.getException();
            }
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getImpKey_error", table, e.getMessage());
            this.getLogger().log(2, e, logMsg);
            throw MMSQLException.create(e, logMsg);
        }
        ResultSet resultSet = this.getReferenceKeys(results);
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getImpKey_success", table);
        this.getLogger().log(4, logMsg);
        return resultSet;
    }

    private ResultSet emptyImportedKeys() throws SQLException {
        return this.emptyCrossReference();
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (catalog != null) {
            return this.emptyIndexInfo();
        }
        if (schema == null) {
            schema = PERCENT;
        }
        if (table == null) {
            table = PERCENT;
        }
        ArrayList records = new ArrayList();
        java.sql.ResultSetMetaData rmetadata = null;
        ResultsImpl results = null;
        PreparedStatement prepareQuery = null;
        try {
            prepareQuery = this.driverConnection.prepareStatement(QUERY_INDEX_INFO);
            prepareQuery.setObject(1, schema.toUpperCase());
            prepareQuery.setObject(2, table.toUpperCase());
            results = (ResultsImpl)prepareQuery.executeQuery();
            if (results.getException() != null) {
                throw results.getException();
            }
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(13);
                for (int i = 0; i < 13; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getIndex_error", table, e.getMessage());
            this.getLogger().log(2, e, logMsg);
            throw MMSQLException.create(e, logMsg);
        }
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getIndex_success", table);
        this.getLogger().log(4, logMsg);
        return this.createResultSet(records, rmetadata);
    }

    private ResultSet emptyIndexInfo() throws SQLException {
        String[] columnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
        String[] dataTypes = new String[]{"string", "string", "string", "boolean", "string", "string", "short", "short", "string", "string", "integer", "integer", "string"};
        return this.createEmptyResultSet(columnNames, dataTypes);
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 255;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 255;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 255;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 255;
    }

    public String getNumericFunctions() throws SQLException {
        return NUMERIC_FUNCTIONS;
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (catalog != null) {
            return this.emptyPrimaryKeys();
        }
        if (schema == null) {
            schema = PERCENT;
        }
        if (table == null) {
            table = PERCENT;
        }
        ArrayList records = new ArrayList();
        java.sql.ResultSetMetaData rmetadata = null;
        ResultsImpl results = null;
        PreparedStatement prepareQuery = null;
        try {
            prepareQuery = this.driverConnection.prepareStatement(QUERY_PRIMARY_KEYS);
            prepareQuery.setObject(1, schema.toUpperCase());
            prepareQuery.setObject(2, table.toUpperCase());
            results = (ResultsImpl)prepareQuery.executeQuery();
            if (results.getException() != null) {
                throw results.getException();
            }
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(7);
                for (int i = 0; i < 6; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getPrimaryKey_error", table, e.getMessage());
            this.getLogger().log(2, e, logMsg);
            throw MMSQLException.create(e, logMsg);
        }
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getPrimaryKey_success");
        this.getLogger().log(4, logMsg);
        return this.createResultSet(records, rmetadata);
    }

    private ResultSet emptyPrimaryKeys() throws SQLException {
        String[] columnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
        String[] dataTypes = new String[]{"string", "string", "string", "string", "short", "string"};
        return this.createEmptyResultSet(columnNames, dataTypes);
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (catalog != null) {
            return this.emptyProcedureColumns();
        }
        if (schemaPattern == null) {
            schemaPattern = PERCENT;
        }
        if (procedureNamePattern == null) {
            procedureNamePattern = PERCENT;
        }
        if (columnNamePattern == null) {
            columnNamePattern = PERCENT;
        }
        ArrayList records = new ArrayList();
        java.sql.ResultSetMetaData rmetadata = null;
        ResultsImpl results = null;
        PreparedStatement prepareQuery = null;
        try {
            prepareQuery = this.driverConnection.prepareStatement(QUERY_PROCEDURE_COLUMNS);
            prepareQuery.setObject(1, schemaPattern.toUpperCase());
            prepareQuery.setObject(2, procedureNamePattern.toUpperCase());
            prepareQuery.setObject(3, columnNamePattern.toUpperCase());
            results = (ResultsImpl)prepareQuery.executeQuery();
            if (results.getException() != null) {
                throw results.getException();
            }
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(13);
                for (int i = 0; i < 14; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getProcCol_error", columnNamePattern, e.getMessage());
            this.getLogger().log(2, e, logMsg);
            throw MMSQLException.create(e, logMsg);
        }
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getProcCol_success", columnNamePattern, procedureNamePattern);
        this.getLogger().log(4, logMsg);
        return this.createResultSet(records, rmetadata);
    }

    private ResultSet emptyProcedureColumns() throws SQLException {
        String[] columnNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "POSITION"};
        String[] dataTypes = new String[]{"string", "string", "string", "string", "short", "integer", "string", "integer", "integer", "short", "short", "short", "string", "short"};
        return this.createEmptyResultSet(columnNames, dataTypes);
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (catalog != null) {
            return this.emptyProcedures();
        }
        if (schemaPattern == null) {
            schemaPattern = PERCENT;
        }
        if (procedureNamePattern == null) {
            procedureNamePattern = PERCENT;
        }
        ArrayList records = new ArrayList();
        java.sql.ResultSetMetaData rmetadata = null;
        ResultsImpl results = null;
        PreparedStatement prepareQuery = null;
        try {
            prepareQuery = this.driverConnection.prepareStatement(QUERY_PROCEDURES);
            prepareQuery.setObject(1, schemaPattern.toUpperCase());
            prepareQuery.setObject(2, procedureNamePattern.toUpperCase());
            results = (ResultsImpl)prepareQuery.executeQuery();
            if (results.getException() != null) {
                throw results.getException();
            }
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(8);
                for (int i = 0; i < 8; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getProc_error", procedureNamePattern, e.getMessage());
            this.getLogger().log(2, e, logMsg);
            throw MMSQLException.create(e, logMsg);
        }
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getProc_success", procedureNamePattern);
        this.getLogger().log(4, logMsg);
        return this.createResultSet(records, rmetadata);
    }

    private ResultSet emptyProcedures() throws SQLException {
        String[] columnNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "RESERVED_1", "RESERVED_2", "RESERVED_3", "REMARKS", "PROCEDURE_TYPE"};
        String[] dataTypes = new String[]{"string", "string", "string", "string", "string", "string", "string", "short"};
        return this.createEmptyResultSet(columnNames, dataTypes);
    }

    public String getProcedureTerm() throws SQLException {
        return PROCEDURE_TERM;
    }

    public int getResultSetHoldability() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public ResultSet getSchemas() throws SQLException {
        ArrayList records = new ArrayList();
        java.sql.ResultSetMetaData rmetadata = null;
        ResultsImpl results = null;
        PreparedStatement prepareQuery = null;
        try {
            prepareQuery = this.driverConnection.prepareStatement(QUERY_SCHEMAS);
            results = (ResultsImpl)prepareQuery.executeQuery();
            if (results.getException() != null) {
                throw results.getException();
            }
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(2);
                for (int i = 0; i < 2; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getschema_error", e.getMessage());
            this.getLogger().log(2, e, logMsg);
            throw MMSQLException.create(e, logMsg);
        }
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getschema_success");
        this.getLogger().log(4, logMsg);
        return this.createResultSet(records, rmetadata);
    }

    public String getSchemaTerm() throws SQLException {
        return SCHEMA_TERM;
    }

    public String getSearchStringEscape() throws SQLException {
        return ESCAPE_SEARCH_STRING;
    }

    public String getSQLKeywords() throws SQLException {
        return KEY_WORDS;
    }

    public int getSQLStateType() throws SQLException {
        return 2;
    }

    public String getStringFunctions() throws SQLException {
        return STRING_FUNCTIONS;
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{this.getColumnMetadata(null, "TABLE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE), this.getColumnMetadata(null, "TABLE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE), this.getColumnMetadata(null, "TABLE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "SUPERTABLE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL)};
        return this.createResultSet(records, metadataList);
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{this.getColumnMetadata(null, "TYPE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE), this.getColumnMetadata(null, "TYPE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE), this.getColumnMetadata(null, "TYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "SUPERTYPE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE), this.getColumnMetadata(null, "SUPERTYPE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE), this.getColumnMetadata(null, "SUPERTYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL)};
        return this.createResultSet(records, metadataList);
    }

    public String getSystemFunctions() throws SQLException {
        return SYSTEM_FUNCTIONS;
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableName) throws SQLException {
        ArrayList records = new ArrayList(0);
        Map[] metadataList = new Map[]{this.getColumnMetadata(null, "TABLE_CAT", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE), this.getColumnMetadata(null, "TABLE_SCHEM", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE), this.getColumnMetadata(null, "TABLE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "GRANTOR", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE), this.getColumnMetadata(null, "GRANTEE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "PRIVILEGE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL), this.getColumnMetadata(null, "IS_GRANTABLE", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE)};
        return this.createResultSet(records, metadataList);
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (catalog != null) {
            return this.emptyTablesResultSet();
        }
        if (schemaPattern == null) {
            schemaPattern = PERCENT;
        }
        if (tableNamePattern == null) {
            tableNamePattern = PERCENT;
        }
        ArrayList records = new ArrayList();
        StringBuffer sqlQuery = new StringBuffer(QUERY_TABLES);
        StringBuffer typesString = new StringBuffer();
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == null || types[i].length() <= 0) continue;
                if (i > 0) {
                    typesString.append(" OR UCASE(Type) LIKE ?");
                    continue;
                }
                typesString.append("(UCASE(Type) LIKE ?");
            }
        }
        if (typesString.length() != 0) {
            typesString.append(")");
            sqlQuery.append(" AND ").append(typesString.toString()).append(" AND Type IS NOT NULL");
        }
        sqlQuery.append(" ORDER BY TABLE_TYPE, TABLE_SCHEM, TABLE_NAME");
        java.sql.ResultSetMetaData rmetadata = null;
        ResultsImpl results = null;
        PreparedStatement prepareQuery = null;
        try {
            prepareQuery = this.driverConnection.prepareStatement(sqlQuery.toString());
            int columnIndex = 0;
            prepareQuery.setObject(++columnIndex, schemaPattern.toUpperCase());
            prepareQuery.setObject(++columnIndex, tableNamePattern.toUpperCase());
            if (types != null) {
                for (int i = 0; i < types.length; ++i) {
                    if (types[i] == null || types[i].length() <= 0) continue;
                    prepareQuery.setObject(++columnIndex, types[i].toUpperCase());
                }
            }
            if ((results = (ResultsImpl)prepareQuery.executeQuery()).getException() != null) {
                throw results.getException();
            }
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(11);
                for (int i = 0; i < 11; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getTable_error", tableNamePattern, e.getMessage());
            this.getLogger().log(2, e, logMsg);
            throw MMSQLException.create(e, logMsg);
        }
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getTable_success", tableNamePattern);
        this.getLogger().log(4, logMsg);
        return this.createResultSet(records, rmetadata);
    }

    private ResultSet emptyTablesResultSet() throws SQLException {
        String[] columnNames = new String[]{"TABLE_CAT", "TYPE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION", "ISPHYSICAL"};
        String[] dataTypes = new String[]{"string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "boolean"};
        return this.createEmptyResultSet(columnNames, dataTypes);
    }

    public ResultSet getTableTypes() throws SQLException {
        ArrayList<List<String>> records = new ArrayList<List<String>>(4);
        records.add(Arrays.asList("Document"));
        records.add(Arrays.asList("Table"));
        records.add(Arrays.asList("View"));
        records.add(Arrays.asList("XmlStagingTable"));
        Map[] metadataList = new Map[]{this.getColumnMetadata(null, "TABLE_TYPE", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL)};
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getTableType_success");
        this.getLogger().log(4, logMsg);
        return this.createResultSet(records, metadataList);
    }

    public String getTimeDateFunctions() throws SQLException {
        return DATE_FUNCTIONS;
    }

    public ResultSet getTypeInfo() throws SQLException {
        ArrayList<List<Object>> records = new ArrayList<List<Object>>();
        records.add(Arrays.asList(this.createTypeInfoRow("boolean", "{b'", "}", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("byte", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("long", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("char", "'", "'", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("bigdecimal", null, null, Boolean.FALSE, Boolean.TRUE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("biginteger", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("integer", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("short", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("float", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("double", null, null, Boolean.FALSE, Boolean.FALSE, 10)));
        records.add(Arrays.asList(this.createTypeInfoRow("string", "'", "'", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("xml", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("date", "{d'", "}", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("time", "{t'", "}", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("timestamp", "{ts'", "}", Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("object", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("blob", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        records.add(Arrays.asList(this.createTypeInfoRow("clob", null, null, Boolean.TRUE, Boolean.TRUE, 0)));
        Map[] metadataList = new Map[]{this.getColumnMetadata("System.DataTypes", "TYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "DATA_TYPE", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "PRECISION", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "LITERAL_PREFIX", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "LITERAL_SUFFIX", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "CREATE_PARAMS", "string", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "NULLABLE", "short", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "CASE_SENSITIVE", "boolean", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE), this.getColumnMetadata("System.DataTypes", "SEARCHABLE", "short", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "UNSIGNED_ATTRIBUTE", "boolean", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "FIXED_PREC_SCALE", "boolean", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "AUTO_INCREMENT", "boolean", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE), this.getColumnMetadata("System.DataTypes", "LOCAL_TYPE_NAME", "string", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "MINIMUM_SCALE", "short", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "MAXIMUM_SCALE", "short", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "SQL_DATA_TYPE", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "SQL_DATETIME_SUB", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE), this.getColumnMetadata("System.DataTypes", "NUM_PREC_RADIX", "integer", ResultsMetadataConstants.NULL_TYPES.NULLABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE)};
        ResultsMetadataWithProvider rmetadata = ResultsMetadataWithProvider.newInstance(StaticMetadataProvider.createWithData(metadataList, 0, this.getLogger()), this.getLogger());
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getTypes_success");
        this.getLogger().log(4, logMsg);
        return this.createResultSet(records, rmetadata);
    }

    private Object[] createTypeInfoRow(String typeName, String prefix, String suffix, Boolean unsigned, Boolean fixedPrecScale, int radix) {
        return new Object[]{typeName, new Integer(MMJDBCSQLTypeInfo.getSQLType(typeName)), ResultsMetadataDefaults.getDefaultPrecision(typeName), prefix, suffix, null, new Short(1), Boolean.FALSE, new Short(3), unsigned, fixedPrecScale, Boolean.FALSE, typeName, new Short(0), new Short(255), null, null, new Integer(radix)};
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.emptyUDTSResultSet();
    }

    private ResultSet emptyUDTSResultSet() throws SQLException {
        String[] columnNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"};
        String[] dataTypes = new String[]{"string", "string", "string", "string", "string", "string", "short"};
        return this.createEmptyResultSet(columnNames, dataTypes);
    }

    public String getURL() throws SQLException {
        return this.driverConnection.getUrl();
    }

    public String getUserName() throws SQLException {
        return this.driverConnection.getUserName();
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        ResultSet resultSet = this.getBestRowIdentifier(catalog, schema, table, 0, true);
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getVersionCols_success");
        this.getLogger().log(4, logMsg);
        return resultSet;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        if (fromType == 1 || fromType == 12 || fromType == -1) {
            return toType == 1 || toType == 12 || toType == -1 || toType == -7 || toType == 5 || toType == -6 || toType == 4 || toType == -5 || toType == 6 || toType == 7 || toType == 8 || toType == 2 || toType == 3 || toType == 91 || toType == 92 || toType == 93;
        }
        if (fromType == 4 || fromType == -6 || fromType == 5 || fromType == -7 || fromType == -5 || fromType == 6 || fromType == 7 || fromType == 8 || fromType == 2 || fromType == 3) {
            return toType == 1 || toType == 12 || toType == -1 || toType == -7 || toType == 5 || toType == -6 || toType == 4 || toType == -5 || toType == 6 || toType == 7 || toType == 8 || toType == 2 || toType == 3;
        }
        if (fromType == 91) {
            return toType == 91 || toType == 93 || toType == 1 || toType == 12 || toType == -1;
        }
        if (fromType == 92) {
            return toType == 92 || toType == 93 || toType == 1 || toType == 12 || toType == -1;
        }
        if (fromType == 93) {
            return toType == 91 || toType == 92 || toType == 93 || toType == 1 || toType == 12 || toType == -1;
        }
        if (fromType == 2000) {
            return toType == 2000;
        }
        return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (type == 1003 || type == 1004) {
            return concurrency == 1007;
        }
        return false;
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003 || type == 1004;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    public boolean supportsTransactions() throws SQLException {
        return this.driverConnection.allowExplicitTransactions();
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    private ResultSet getReferenceKeys(ResultsImpl results) throws SQLException {
        ArrayList records = new ArrayList();
        java.sql.ResultSetMetaData rmetadata = null;
        try {
            while (results.next()) {
                ArrayList<Object> currentRow = new ArrayList<Object>(15);
                for (int i = 0; i < 14; ++i) {
                    currentRow.add(results.getObject(i + 1));
                }
                records.add(currentRow);
            }
            rmetadata = results.getMetaData();
        }
        catch (Exception e) {
            String msg = JDBCPlugin.Util.getString("MMDatabaseMetadata.Err_getting_primary_keys");
            throw MMSQLException.create(e, msg);
        }
        String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getRefKey_success");
        this.getLogger().log(4, logMsg);
        return this.createResultSet(records, rmetadata);
    }

    private Map getColumnMetadata(String tableName, String columnName, String dataType, Integer nullable) throws SQLException {
        return this.getColumnMetadata(tableName, columnName, dataType, nullable, ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
    }

    private Map getColumnMetadata(String tableName, String columnName, String dataType, Integer nullable, Integer searchable, Boolean writable, Boolean signed, Boolean caseSensitive) throws SQLException {
        HashMap<Integer, Object> metadataMap = new HashMap<Integer, Object>();
        metadataMap.put(ResultsMetadataConstants.VIRTUAL_DATABASE_NAME, this.driverConnection.getSchema());
        metadataMap.put(ResultsMetadataConstants.GROUP_NAME, tableName);
        metadataMap.put(ResultsMetadataConstants.ELEMENT_NAME, columnName);
        metadataMap.put(ResultsMetadataConstants.DATA_TYPE, dataType);
        metadataMap.put(ResultsMetadataConstants.PRECISION, ResultsMetadataDefaults.getDefaultPrecision(dataType));
        metadataMap.put(ResultsMetadataConstants.RADIX, new Integer(10));
        metadataMap.put(ResultsMetadataConstants.SCALE, new Integer(0));
        metadataMap.put(ResultsMetadataConstants.AUTO_INCREMENTING, Boolean.FALSE);
        metadataMap.put(ResultsMetadataConstants.CASE_SENSITIVE, caseSensitive);
        metadataMap.put(ResultsMetadataConstants.NULLABLE, nullable);
        metadataMap.put(ResultsMetadataConstants.SEARCHABLE, searchable);
        metadataMap.put(ResultsMetadataConstants.SIGNED, signed);
        metadataMap.put(ResultsMetadataConstants.WRITABLE, writable);
        metadataMap.put(ResultsMetadataConstants.CURRENCY, Boolean.FALSE);
        metadataMap.put(ResultsMetadataConstants.DISPLAY_SIZE, ResultsMetadataDefaults.getMaxDisplaySize(dataType));
        return metadataMap;
    }

    public ResultSet getModels(String catalog, String schemaPattern, String modelNamePattern) throws SQLException {
        if (modelNamePattern == null) {
            modelNamePattern = PERCENT;
        }
        try {
            PreparedStatement prepareQuery = this.driverConnection.prepareStatement(QUERY_MODELS);
            prepareQuery.setObject(1, modelNamePattern.toUpperCase());
            ResultsImpl results = (ResultsImpl)prepareQuery.executeQuery();
            if (results.getException() != null) {
                throw results.getException();
            }
            return results;
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMDatabaseMetadata.getModels_error", modelNamePattern, e.getMessage());
            this.getLogger().log(2, e, logMsg);
            throw MMSQLException.create(e, logMsg);
        }
    }

    public List getXMLSchemas(String documentName) throws SQLException {
        XMLSchemaMessage schemaMsg = new XMLSchemaMessage(documentName);
        schemaMsg.setVdbName(this.driverConnection.getSchema());
        schemaMsg.setVdbVersion(this.driverConnection.getVDBVersion());
        MMStatement stmt = (MMStatement)this.driverConnection.createStatement();
        Message results = stmt.executeAsynchAndWait(schemaMsg, false);
        if (results instanceof MessageHolder) {
            MessageHolder holder = (MessageHolder)results;
            ExceptionHolder exHolder = (ExceptionHolder)holder.contents;
            throw MMSQLException.create(exHolder.exception);
        }
        XMLSchemaMessage returnedMsg = (XMLSchemaMessage)results;
        if (returnedMsg.getException() != null) {
            throw MMSQLException.create(returnedMsg.getException());
        }
        return returnedMsg.getSchemas();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String[] internalTypes = MMJDBCSQLTypeInfo.getMMTypeNames();
        StringBuffer typeMapping = new StringBuffer();
        StringBuffer precisionMapping = new StringBuffer();
        for (int i = 0; i < internalTypes.length; ++i) {
            if (i != 0) {
                typeMapping.append(",");
                precisionMapping.append(",");
            }
            typeMapping.append(internalTypes[i]).append(",").append(MMJDBCSQLTypeInfo.getSQLType(internalTypes[i]));
            precisionMapping.append(internalTypes[i]).append(",").append(ResultsMetadataDefaults.getDefaultPrecision(internalTypes[i]));
        }
        TYPE_MAPPING = typeMapping.toString();
        PRECISION_MAPPING = precisionMapping.toString();
        NULLABILITY_MAPPING = "No Nulls, " + 0 + ", Nullable, " + 1 + ", Unknown, " + 2;
        PROC_COLUMN_NULLABILITY_MAPPING = "No Nulls, " + 0 + ", Nullable, " + 1 + ", Unknown, " + 2;
        PARAM_DIRECTION_MAPPING = "In," + 1 + ", Out," + 4 + ", InOut," + 2 + ", ReturnValue," + 5 + ", ResultSet," + 3;
        DATATYPES_WITH_NO_PRECISION = "'" + "string" + "', '" + "char" + "', '" + "clob" + "', '" + "blob" + "', '" + "boolean" + "', '" + "date" + "', '" + "time" + "', '" + "timestamp" + "', '" + "object" + "'";
        QUERY_REFERENCE_KEYS = "SELECT PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM" + ", FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM " + "System.JDBC" + ".ReferenceKeyColumns";
        QUERY_CROSS_REFERENCES = QUERY_REFERENCE_KEYS + "," + "System" + ".VirtualDatabases v WHERE UCASE(v.Name)" + LIKE_ESCAPE + "AND UCASE(v.Name) LIKE ?" + " AND UCASE(PKTABLE_SCHEM) = UCASE(v.Name) AND " + " UCASE(PKTABLE_NAME)" + LIKE_ESCAPE + "AND UCASE(FKTABLE_NAME)" + LIKE_ESCAPE + "ORDER BY FKTABLE_NAME, KEY_SEQ";
        QUERY_EXPORTED_KEYS = QUERY_REFERENCE_KEYS + "," + "System" + ".VirtualDatabases v WHERE UCASE(v.Name)" + LIKE_ESCAPE + " AND UCASE(PKTABLE_SCHEM) = UCASE(v.Name) AND " + " UCASE(PKTABLE_NAME)" + LIKE_ESCAPE + "ORDER BY FKTABLE_NAME, KEY_SEQ";
        QUERY_IMPORTED_KEYS = QUERY_REFERENCE_KEYS + "," + "System" + ".VirtualDatabases v WHERE UCASE(v.Name)" + LIKE_ESCAPE + " AND UCASE(PKTABLE_SCHEM) = UCASE(v.Name) AND " + " UCASE(FKTABLE_NAME)" + LIKE_ESCAPE + "ORDER BY PKTABLE_NAME, KEY_SEQ";
        QUERY_COLUMNS = "SELECT NULL AS TABLE_CAT" + ", v.Name AS TABLE_SCHEM, GroupFullName AS TABLE_NAME, e.Name AS COLUMN_NAME" + ", convert(decodeString(DataType, '" + TYPE_MAPPING + "', ','), short) AS DATA_TYPE" + ", DataType AS TYPE_NAME" + ", CASE WHEN (DataType IN (" + DATATYPES_WITH_NO_PRECISION + ")) THEN CASE WHEN ElementLength <= 0 THEN convert(decodeString(DataType,'" + PRECISION_MAPPING + "',','), integer) ELSE ElementLength END ELSE CASE WHEN Precision <= 0 THEN convert(decodeString(DataType,'" + PRECISION_MAPPING + "',','), integer) ELSE Precision END END AS COLUMN_SIZE" + ", NULL AS BUFFER_LENGTH, Scale AS DECIMAL_DIGITS, Radix AS NUM_PREC_RADIX" + ", convert(decodeString(NullType, '" + NULLABILITY_MAPPING + "', ','), integer) AS NULLABLE" + ", Description AS REMARKS, DefaultValue AS COLUMN_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB" + ", CharOctetLength AS CHAR_OCTET_LENGTH, Position AS ORDINAL_POSITION" + ", decodeString(NullType, 'No Nulls, YES, Nullable, NO, Unknown, '' ''', ',') AS IS_NULLABLE" + " FROM " + "System" + ".Elements e CROSS JOIN " + "System" + ".VirtualDatabases v" + " WHERE UCASE(v.Name)" + LIKE_ESCAPE + "AND UCASE(GroupFullName)" + LIKE_ESCAPE + "AND UCASE(e.Name)" + LIKE_ESCAPE + " ORDER BY TABLE_NAME, ORDINAL_POSITION";
        QUERY_INDEX_INFO = "SELECT NULL AS TABLE_CAT, v.Name AS TABLE_SCHEM, GroupFullName AS TABLE_NAME" + ", convert(0, boolean) AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, KeyName AS INDEX_NAME" + ", 0 AS TYPE, convert(Position, short) AS ORDINAL_POSITION, k.Name AS COLUMN_NAME" + ", NULL AS ASC_OR_DESC, 0 AS CARDINALITY, 1 AS PAGES, NULL AS FILTER_CONDITION" + " FROM " + "System" + ".KeyElements k CROSS JOIN " + "System" + ".VirtualDatabases v" + " WHERE UCASE(v.Name)" + LIKE_ESCAPE + "AND KeyType LIKE 'Index' AND UCASE(GroupFullName) LIKE ?" + " ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION";
        QUERY_MODELS = "SELECT NULL AS MODEL_CAT, v.name AS MODEL_SCHEM, m.Name AS MODEL_NAME," + " Description AS DESCRIPTION, IsPhysical AS IS_PHYSICAL, SupportsWhereAll AS SUP_WHERE_ALL, " + " SupportsDistinct AS SUP_DISTINCT, SupportsJoin AS SUP_JOIN, SupportsOuterJoin AS SUP_OUTER_JOIN, " + " SupportsOrderBy AS SUP_ORDER_BY " + " FROM " + "System" + ".Models m CROSS JOIN " + "System" + ".VirtualDatabases v " + "WHERE UCASE(m.Name)" + LIKE_ESCAPE + "ORDER BY MODEL_NAME";
        QUERY_PRIMARY_KEYS = "SELECT NULL AS TABLE_CAT, v.Name AS TABLE_SCHEM, GroupFullName AS TABLE_NAME" + ", k.Name AS COLUMN_NAME, convert(Position, short) AS KEY_SEQ, KeyName AS PK_NAME" + " FROM " + "System" + ".KeyElements k CROSS JOIN " + "System" + ".VirtualDatabases v " + " WHERE UCASE(v.Name)" + LIKE_ESCAPE + "AND KeyType LIKE 'Primary' AND UCASE(GroupFullName) LIKE ?" + " ORDER BY COLUMN_NAME, KEY_SEQ";
        QUERY_PROCEDURES = "SELECT convert(null, string) AS PROCEDURE_CAT, v.Name AS PROCEDURE_SCHEM" + ", p.FullName AS PROCEDURE_NAME, convert(null, string) AS RESERVED_1" + ", convert(null, string) AS RESERVED_2, convert(null, string) AS RESERVED_3, p.Description AS REMARKS" + ", convert(decodeString(p.ReturnsResults, 'true, " + 2 + ", false, " + 1 + "'), short) AS PROCEDURE_TYPE FROM " + "System" + ".Procedures as p CROSS JOIN " + "System" + ".VirtualDatabases v WHERE UCASE(v.Name)" + LIKE_ESCAPE + "AND UCASE(p.Name)" + LIKE_ESCAPE + " ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME";
        QUERY_PROCEDURE_COLUMNS = "SELECT convert(null, string) AS PROCEDURE_CAT, v.Name AS PROCEDURE_SCHEM" + ", ProcedureName AS PROCEDURE_NAME, p.Name AS COLUMN_NAME" + ", convert(decodeString(TYPE, '" + PARAM_DIRECTION_MAPPING + "', ','), short) AS COLUMN_TYPE" + ", convert(decodeString(DataType, '" + TYPE_MAPPING + "', ','), integer) AS DATA_TYPE" + ", DataType AS TYPE_NAME, CASE WHEN Precision <= 0 THEN convert(decodeString(DataType,'" + PRECISION_MAPPING + "',','), integer) ELSE Precision END AS PRECISION, CASE WHEN TypeLength <= 0 THEN convert(decodeString(DataType,'" + PRECISION_MAPPING + "',','), integer) ELSE TypeLength END AS LENGTH, convert(Scale, short) AS SCALE" + ", Radix AS RADIX, convert(decodeString(NullType, '" + PROC_COLUMN_NULLABILITY_MAPPING + "', ','), integer) AS NULLABLE" + ", convert(null, string) AS REMARKS, Position AS POSITION FROM " + "System" + ".ProcedureParams as p CROSS JOIN " + "System" + ".VirtualDatabases v WHERE UCASE(v.Name)" + LIKE_ESCAPE + "AND UCASE(p.ProcedureName)" + LIKE_ESCAPE + "AND UCASE(p.Name) LIKE ?" + " ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, COLUMN_TYPE, POSITION";
        QUERY_SCHEMAS = "SELECT Name AS TABLE_SCHEM, NULL AS TABLE_CATALOG" + " FROM " + "System" + ".VirtualDatabases ORDER BY TABLE_SCHEM";
        QUERY_TABLES = "SELECT NULL AS TABLE_CAT, v.Name AS TABLE_SCHEM, FullName AS TABLE_NAME" + ", Type AS TABLE_TYPE, Description AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM" + ", NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, NULL AS REF_GENERATION, IsPhysical AS ISPHYSICAL" + " FROM " + "System" + ".Groups g CROSS JOIN " + "System" + ".VirtualDatabases v" + " WHERE UCASE(v.Name)" + LIKE_ESCAPE + "AND UCASE(FullName) LIKE ?";
    }

    private static final class RUNTIME_MODEL {
        public static final String VIRTUAL_MODEL_NAME = "System";
        public static final String ODBC_SYSTEM_MODEL_NAME = "System.ODBC";
        public static final String WSDL_SYSTEM_MODEL_NAME = "DataServiceSystemModel";
        public static final String JDBC_SYSTEM_MODEL_NAME = "System.JDBC";

        private RUNTIME_MODEL() {
        }
    }
}

