/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.api.MMURL;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.log.Logger;
import com.metamatrix.core.log.NullLogger;
import com.metamatrix.jdbc.BaseDataSource;
import com.metamatrix.jdbc.DriverManagerLogger;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMDriver;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMXAConnection;
import com.metamatrix.jdbc.util.MMJDBCURL;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class MMDataSource
extends BaseDataSource
implements XADataSource {
    protected static final int DEFAULT_TIMEOUT = 0;
    protected static final int DEFAULT_LOG_LEVEL = 0;
    private int portNumber;
    private String serverName;
    private String socketsPerVM;
    private String stickyConnections;
    private String credentials;
    private boolean secure = false;
    private String alternateServers = null;
    static final String SERVER_URL = "serverURL";
    static final String HOST = "host";
    static final String PORT = "port";
    private Logger logger;

    protected Properties buildProperties(String userName, String password) {
        Properties props = super.buildProperties(userName, password);
        props.setProperty(SERVER_URL, this.buildServerURL());
        if (this.alternateServers != null) {
            String hostList = this.serverName;
            String portList = "" + this.portNumber;
            String[] as = this.alternateServers.split(",");
            for (int i = 0; i < as.length; ++i) {
                String[] server = as[i].split(":");
                if (server.length <= 0) continue;
                hostList = hostList + "," + server[0];
                portList = server.length > 1 ? portList + "," + server[1] : portList + "," + this.portNumber;
            }
            props.setProperty(HOST, hostList);
            props.setProperty(PORT, portList);
        } else {
            props.setProperty(HOST, this.serverName);
            props.setProperty(PORT, String.valueOf(this.portNumber));
        }
        if (this.getSocketsPerVM() != null) {
            props.setProperty("socketsPerVM", this.getSocketsPerVM());
        }
        if (this.getStickyConnections() != null) {
            props.setProperty("stickyConnections", this.getStickyConnections());
        }
        if (this.getCredentials() != null) {
            props.setProperty("credentials", this.getCredentials());
        }
        return props;
    }

    protected String buildServerURL() {
        if (this.alternateServers == null) {
            return new MMURL(this.serverName, this.portNumber, this.secure).getAppServerURL();
        }
        String serverURL = "";
        serverURL = "" + (this.secure ? "mms://" : "mm://");
        serverURL = serverURL + "" + this.serverName;
        if (this.portNumber != 0) {
            serverURL = serverURL + ":" + this.portNumber;
        }
        if (this.alternateServers.length() > 0) {
            String[] as = this.alternateServers.split(",");
            for (int i = 0; i < as.length; ++i) {
                String[] server = as[i].split(":");
                if (server.length <= 0) continue;
                serverURL = serverURL + "," + server[0];
                serverURL = server.length > 1 ? serverURL + ":" + server[1] : serverURL + ":" + this.portNumber;
            }
        }
        return new MMURL(serverURL).getAppServerURL();
    }

    protected String buildURL() {
        return new MMJDBCURL(this.getDatabaseName(), this.buildServerURL(), this.buildProperties(this.getUser(), this.getPassword())).getJDBCURL();
    }

    protected void validateProperties(String userName, String password) throws SQLException {
        super.validateProperties(userName, password);
        String reason = MMDataSource.reasonWhyInvalidPortNumber(this.portNumber);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
        reason = MMDataSource.reasonWhyInvalidServerName(this.serverName);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
        reason = MMDataSource.reasonWhyInvalidSocketsPerVM(this.socketsPerVM);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
        reason = MMDataSource.reasonWhyInvalidStickyConnections(this.stickyConnections);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
        reason = MMDataSource.reasonWhyInvalidAlternateServers(this.alternateServers);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
    }

    private MMSQLException createConnectionError(String reason) {
        String msg = JDBCPlugin.Util.getString("MMDataSource.Err_connecting", reason);
        return new MMSQLException(msg);
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    public Connection getConnection(String userName, String password) throws SQLException {
        try {
            this.validateProperties(userName, password);
            Properties props = this.buildProperties(userName, password);
            MMDriver driver = new MMDriver();
            return driver.createMMConnection(null, props);
        }
        catch (MetaMatrixCoreException e) {
            this.getLogger().log(1, e, e.getMessage());
            throw MMSQLException.create(e, e.getMessage());
        }
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(null, null);
    }

    public XAConnection getXAConnection(String userName, String password) throws SQLException {
        try {
            this.validateProperties(userName, password);
            Properties props = this.buildProperties(userName, password);
            String url = this.buildURL();
            return this.createMMXAConnection(url, props);
        }
        catch (Exception e) {
            String msg = JDBCPlugin.Util.getString("MMDataSource.Err_creating_XAConn", e.getMessage());
            this.getLogger().log(1, e, msg);
            if (e instanceof MMSQLException) {
                throw (MMSQLException)e;
            }
            throw MMSQLException.create(e, msg);
        }
    }

    protected MMXAConnection createMMXAConnection(String url, Properties props) throws Exception {
        MMXAConnection mc = MMXAConnection.newInstance(url, props);
        mc.setMmDataSource(this);
        return mc;
    }

    public String toString() {
        return this.buildURL().substring(16);
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getSocketsPerVM() {
        return this.socketsPerVM;
    }

    public String getStickyConnections() {
        return this.stickyConnections;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getAlternateServers() {
        if (this.alternateServers != null && this.alternateServers.length() < 1) {
            return null;
        }
        return this.alternateServers;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setSocketsPerVM(String socketsPerVM) {
        this.socketsPerVM = socketsPerVM;
    }

    public void setStickyConnections(String stickyConnections) {
        this.stickyConnections = stickyConnections;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setAlternateServers(String servers) {
        this.alternateServers = servers;
        if (this.alternateServers != null && this.alternateServers.length() < 1) {
            this.alternateServers = null;
        }
    }

    public static String reasonWhyInvalidPortNumber(int portNumber) {
        if (portNumber == 0) {
            return null;
        }
        if (portNumber < 1) {
            return JDBCPlugin.Util.getString("MMDataSource.Port_number_must_be_positive");
        }
        return null;
    }

    public static String reasonWhyInvalidServerName(String serverName) {
        if (serverName == null || serverName.trim().length() == 0) {
            return JDBCPlugin.Util.getString("MMDataSource.Server_name_required");
        }
        return null;
    }

    public static String reasonWhyInvalidSocketsPerVM(String socketsPerVM) {
        if (socketsPerVM != null) {
            int value = -1;
            try {
                value = Integer.parseInt(socketsPerVM);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value <= 0) {
                return JDBCPlugin.Util.getString("MMDataSource.Sockets_per_vm_invalid");
            }
        }
        return null;
    }

    public static String reasonWhyInvalidStickyConnections(String stickyConnections) {
        if (stickyConnections != null && !stickyConnections.equalsIgnoreCase("true") && !stickyConnections.equalsIgnoreCase("false")) {
            return JDBCPlugin.Util.getString("MMDataSource.Sticky_connections_invalid");
        }
        return null;
    }

    public static String reasonWhyInvalidAlternateServers(String alternateServers) {
        if (alternateServers == null || alternateServers.trim().length() < 1) {
            return null;
        }
        String[] as = alternateServers.split(",");
        String sReason = null;
        String reason = "";
        int reasonCount = 0;
        String newline = System.getProperty("line.separator");
        for (int i = 0; i < as.length; ++i) {
            String[] server = as[i].split(":");
            if (server.length < 1 || server.length > 2) {
                return JDBCPlugin.Util.getString("MMDataSource.Alternate_Servers_format");
            }
            sReason = MMDataSource.reasonWhyInvalidServerName(server[0]);
            if (sReason != null) {
                reason = reason + (reason.length() > 0 ? newline : "") + sReason;
                ++reasonCount;
                sReason = null;
            }
            if (server.length <= 1) continue;
            int port = 0;
            try {
                port = Integer.parseInt(server[1]);
            }
            catch (NumberFormatException e) {
                reason = reason + (reason.length() > 0 ? newline : "") + JDBCPlugin.Util.getString("MMDataSource.serverPort_must_be_a_number");
                ++reasonCount;
            }
            sReason = MMDataSource.reasonWhyInvalidPortNumber(port);
            if (sReason == null) continue;
            reason = reason + (reason.length() > 0 ? newline : "") + sReason;
            ++reasonCount;
            sReason = null;
        }
        if (reasonCount < 1) {
            return null;
        }
        return JDBCPlugin.Util.getString("MMDataSource.alternateServer_is_invalid", new String[]{"" + reasonCount, reason});
    }

    public Logger getLogger() {
        if (this.logger == null) {
            try {
                this.logger = this.getLogFile() != null ? new DriverManagerLogger(this.getLogLevel(), new PrintWriter(new FileWriter(this.getLogFile()))) : new DriverManagerLogger(this.getLogLevel(), this.getLogWriter());
            }
            catch (Exception e) {
                this.logger = new NullLogger();
            }
        }
        return this.logger;
    }

    static {
        try {
            Class.forName("com.metamatrix.jdbc.MMDriver");
        }
        catch (ClassNotFoundException e) {
            String msg = JDBCPlugin.Util.getString("MMDataSource.Cant_load_driver");
            DriverManager.println(msg);
        }
    }
}

