/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.data.pool;

import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.data.DataPlugin;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.monitor.AliveStatus;
import com.metamatrix.data.monitor.ConnectionStatus;
import com.metamatrix.data.pool.ConnectionPool;
import com.metamatrix.data.pool.ConnectionPoolException;
import com.metamatrix.data.pool.ConnectorIdentity;
import com.metamatrix.data.pool.SourceConnection;
import com.metamatrix.data.pool.SourceConnectionFactory;
import java.util.Properties;

public class DisabledConnectionPool
implements ConnectionPool {
    public static final String WAIT_FOR_SOURCE_TIME = "com.metamatrix.data.pool.wait_for_source_time";
    private static final String CTX_CONNECTOR = "CONNECTOR";
    private int waitForSourceTime = 120000;
    private SourceConnectionFactory connectionFactory;
    private Object lock;
    protected boolean lastConnectionAttemptFailed = false;

    public DisabledConnectionPool(SourceConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.lock = new WriterPreferenceReadWriteLock();
    }

    public void initialize(Properties poolProperties) throws ConnectionPoolException {
        ArgCheck.isNotNull(poolProperties);
        String property = null;
        String value = null;
        try {
            property = WAIT_FOR_SOURCE_TIME;
            value = poolProperties.getProperty(property);
            if (value != null) {
                this.waitForSourceTime = Integer.parseInt(value);
            }
            DataPlugin.Util.log(1, DataPlugin.Util.getString("ConnectionPool.Connection_pool_created_1"));
        }
        catch (NumberFormatException nfe) {
            throw new ConnectionPoolException(DataPlugin.Util.getString("ConnectionPool.The_value__6", value, property));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceConnection obtain(SecurityContext securityContext) throws ConnectionPoolException {
        long startTime = System.currentTimeMillis();
        ConnectorIdentity id = null;
        try {
            id = this.connectionFactory.createIdentity(securityContext);
            if (System.currentTimeMillis() - startTime <= (long)this.waitForSourceTime) {
                Object object = this.lock;
                synchronized (object) {
                    this.lastConnectionAttemptFailed = true;
                    SourceConnection connection = this.connectionFactory.createConnection(id);
                    this.lastConnectionAttemptFailed = false;
                    if (LogManager.isMessageToBeRecorded(CTX_CONNECTOR, 6)) {
                        LogManager.logTrace(CTX_CONNECTOR, DataPlugin.Util.getString("ConnectionPool.New_conn", id));
                    }
                    return connection;
                }
            }
        }
        catch (ConnectorException e) {
            throw new ConnectionPoolException((Throwable)e);
        }
        throw new ConnectionPoolException(DataPlugin.Util.getString("ConnectionPool.Timeout_while_waiting_to_obtain_connection"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(SourceConnection connection) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.closeSourceConnection(connection);
            }
            finally {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(SourceConnection connection) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.closeSourceConnection(connection);
            }
            finally {
                this.lock.notifyAll();
            }
        }
    }

    public ConnectionStatus getStatus() {
        return new ConnectionStatus(AliveStatus.ALIVE);
    }

    public void shutDown() {
    }

    protected void cleanUp() {
    }

    private boolean closeSourceConnection(SourceConnection connection) {
        try {
            connection.closeSource();
            if (LogManager.isMessageToBeRecorded(CTX_CONNECTOR, 6)) {
                LogManager.logTrace(CTX_CONNECTOR, DataPlugin.Util.getString("ConnectionPool.Closed_conn"));
            }
            return true;
        }
        catch (Exception e) {
            DataPlugin.Util.log(4, DataPlugin.Util.getString("ConnectionPool.Failed_close_conn"));
            return false;
        }
    }

    protected static class Default {
        static final int DEFAULT_WAIT_FOR_SOURCE_TIME = 120000;

        private Default() {
        }
    }
}

