/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xa.atomikos.xaresource;

import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.TransactionControl;
import com.atomikos.icatch.UnavailableException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.xa.CommonXAPlugin;
import com.metamatrix.common.xa.atomikos.xaresource.Constants;
import java.util.Stack;
import javax.transaction.xa.Xid;

public class XATransaction
implements CompositeTransaction,
CompositeCoordinator,
RecoveryCoordinator {
    private Xid xid;

    public XATransaction() {
    }

    public XATransaction(Xid xid) {
        if (xid.toString().indexOf(Constants.TID_SEPERATOR) >= 0) {
            LogManager.logWarning("XA_TXN", CommonXAPlugin.Util.getString("ERR.003.031.0025", Constants.TID_SEPERATOR));
        }
        this.xid = xid;
    }

    public String getTid() {
        StringBuffer ret = new StringBuffer();
        ret.append(new String(this.xid.getGlobalTransactionId()));
        ret.append(Constants.TID_SEPERATOR);
        ret.append(new String(this.xid.getBranchQualifier()));
        return ret.toString();
    }

    public CompositeCoordinator getCompositeCoordinator() {
        return this;
    }

    public Stack getLineage() {
        Stack<XATransaction> ret = new Stack<XATransaction>();
        ret.push(this);
        return ret;
    }

    public boolean isAncestorOf(CompositeTransaction ct) {
        return false;
    }

    public boolean isDescendantOf(CompositeTransaction ct) {
        return false;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isRelatedTransaction(CompositeTransaction ct) {
        return this.isSameTransaction(ct);
    }

    public boolean isSameTransaction(CompositeTransaction ct) {
        return ct.getTid().equals(this.getTid());
    }

    public boolean isRoot() {
        return true;
    }

    public boolean isSerial() {
        return true;
    }

    public String getRootTid() {
        return this.getTid();
    }

    public HeuristicMessage[] getTags() {
        return null;
    }

    public RecoveryCoordinator getRecoveryCoordinator() {
        return this;
    }

    public Boolean replayCompletion(Participant participant) {
        return null;
    }

    public Object getState() {
        throw new UnavailableException(CommonXAPlugin.Util.getString("ERR.003.031.0026"));
    }

    public void registerSynchronization(Synchronization s) {
        throw new UnavailableException(CommonXAPlugin.Util.getString("ERR.003.031.0026"));
    }

    public RecoveryCoordinator addParticipant(Participant p) {
        throw new UnavailableException(CommonXAPlugin.Util.getString("ERR.003.031.0026"));
    }

    public void addSubTxAwareParticipant(SubTxAwareParticipant s) {
        throw new UnavailableException(CommonXAPlugin.Util.getString("ERR.003.031.0026"));
    }

    public TransactionControl getTransactionControl() {
        throw new UnavailableException(CommonXAPlugin.Util.getString("ERR.003.031.0026"));
    }
}

