/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.objects;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.objects.ProcessObject;
import com.metamatrix.admin.api.objects.QueueWorkerPool;
import com.metamatrix.admin.objects.MMAdminObject;
import java.net.InetAddress;

public final class MMProcess
extends MMAdminObject
implements ProcessObject {
    private long freeMemory = 0L;
    private String hostIdentifier = "";
    private InetAddress inetAddress = null;
    private int port = 0;
    private boolean running = false;
    private int threadCount = 0;
    private long totalMemory = 0L;
    private long processID = -1L;
    private int sockets = 0;
    private int maxSockets = 0;
    private int virtualSockets = 0;
    private int maxVirtualSockets = 0;
    private long objectsRead = 0L;
    private long objectsWritten = 0L;
    private QueueWorkerPool queueWorkerPool = null;

    public MMProcess(String[] identifierParts) {
        super(identifierParts);
        this.hostIdentifier = identifierParts[0];
    }

    public static String[] buildIdentifierArray(String identifier) {
        int index = identifier.lastIndexOf(124);
        String host = identifier.substring(0, index);
        String process = identifier.substring(index + 1);
        return new String[]{host, process};
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public String getHostIdentifier() {
        return this.hostIdentifier;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public int getPort() {
        return this.port;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(AdminPlugin.Util.getString("MMProcess.MMProcess")).append(this.getIdentifier());
        result.append(AdminPlugin.Util.getString("MMProcess.Properties")).append(this.getPropertiesAsString());
        result.append(AdminPlugin.Util.getString("MMProcess.Created")).append(this.getCreatedDate());
        result.append(AdminPlugin.Util.getString("MMProcess.CreatedBy")).append(this.getCreatedBy());
        result.append(AdminPlugin.Util.getString("MMProcess.Updated")).append(this.getLastChangedDate());
        result.append(AdminPlugin.Util.getString("MMProcess.UpdatedBy")).append(this.getLastChangedBy());
        result.append(AdminPlugin.Util.getString("MMProcess.IsRunning")).append(this.isRunning());
        result.append(AdminPlugin.Util.getString("MMProcess.IsDeployed")).append(this.isDeployed());
        result.append(AdminPlugin.Util.getString("MMProcess.TotalMemory")).append(this.totalMemory);
        result.append(AdminPlugin.Util.getString("MMProcess.FreeMemory")).append(this.freeMemory);
        result.append(AdminPlugin.Util.getString("MMProcess.ThreadCount")).append(this.threadCount);
        result.append(AdminPlugin.Util.getString("MMProcess.HostIdentifier")).append(this.hostIdentifier);
        result.append(AdminPlugin.Util.getString("MMProcess.Port")).append(this.port);
        result.append(AdminPlugin.Util.getString("MMProcess.InetAddress")).append(this.inetAddress);
        result.append(AdminPlugin.Util.getString("MMProcess.Sockets")).append(this.sockets);
        result.append(AdminPlugin.Util.getString("MMProcess.MaxSockets")).append(this.maxSockets);
        result.append(AdminPlugin.Util.getString("MMProcess.VirtualSockets")).append(this.virtualSockets);
        result.append(AdminPlugin.Util.getString("MMProcess.MaxVirtualSockets")).append(this.maxVirtualSockets);
        result.append(AdminPlugin.Util.getString("MMProcess.ObjectsRead")).append(this.objectsRead);
        result.append(AdminPlugin.Util.getString("MMProcess.ObjectsWritten")).append(this.objectsWritten);
        if (this.queueWorkerPool != null) {
            result.append(AdminPlugin.Util.getString("MMProcess.QueueWorkerPool")).append(this.queueWorkerPool.toString());
        }
        return result.toString();
    }

    public int getMaxSockets() {
        return this.maxSockets;
    }

    public void setMaxSockets(int maxSockets) {
        this.maxSockets = maxSockets;
    }

    public int getMaxVirtualSockets() {
        return this.maxVirtualSockets;
    }

    public void setMaxVirtualSockets(int maxVirtualSockets) {
        this.maxVirtualSockets = maxVirtualSockets;
    }

    public long getObjectsRead() {
        return this.objectsRead;
    }

    public void setObjectsRead(long objectsRead) {
        this.objectsRead = objectsRead;
    }

    public long getObjectsWritten() {
        return this.objectsWritten;
    }

    public void setObjectsWritten(long objectsWritten) {
        this.objectsWritten = objectsWritten;
    }

    public int getSockets() {
        return this.sockets;
    }

    public void setSockets(int sockets) {
        this.sockets = sockets;
    }

    public int getVirtualSockets() {
        return this.virtualSockets;
    }

    public void setVirtualSockets(int virtualSockets) {
        this.virtualSockets = virtualSockets;
    }

    public QueueWorkerPool getQueueWorkerPool() {
        return this.queueWorkerPool;
    }

    public void setQueueWorkerPool(QueueWorkerPool queueWorkerPool) {
        this.queueWorkerPool = queueWorkerPool;
    }

    public long getProcessID() {
        return this.processID;
    }

    public void setProcessID(long processID) {
        this.processID = processID;
    }

    public String getHostName() {
        return this.identifierParts[0];
    }
}

