/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.util;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.CriteriaSelector;
import com.metamatrix.query.sql.proc.TranslateCriteria;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.validator.UpdateValidationVisitor;
import com.metamatrix.query.validator.ValidatorReport;
import java.util.ArrayList;
import java.util.List;

public class UpdateProcedureGenerator {
    public static final int INSERT_PROCEDURE = 1;
    public static final int UPDATE_PROCEDURE = 2;
    public static final int DELETE_PROCEDURE = 3;

    public static CreateUpdateProcedureCommand createProcedure(int procedureType, String virtualGroup, Command queryTransformation, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        UpdateValidationVisitor updateVisitor = new UpdateValidationVisitor(metadata);
        PreOrderNavigator.doVisit(queryTransformation, (LanguageVisitor)updateVisitor);
        ValidatorReport report = updateVisitor.getReport();
        if (report.hasItems()) {
            return null;
        }
        Query query = (Query)queryTransformation;
        List selectSymbols = query.getProjectedSymbols();
        if (query.getFrom() == null) {
            return null;
        }
        GroupSymbol pGroup = (GroupSymbol)query.getFrom().getGroups().iterator().next();
        String pGroupName = pGroup.getName();
        if (pGroup.getDefinition() != null) {
            pGroupName = pGroup.getDefinition();
        }
        List elementsInVG = metadata.getElementIDsInGroupID(metadata.getGroupID(virtualGroup));
        ElementSymbol rowsUpdated = new ElementSymbol("ROWS_UPDATED");
        CreateUpdateProcedureCommand cupc = null;
        switch (procedureType) {
            case 1: {
                ArrayList variables = new ArrayList();
                ArrayList values = new ArrayList();
                UpdateProcedureGenerator.mapElements(selectSymbols, elementsInVG, pGroupName, metadata, variables, values);
                Insert insert = new Insert();
                insert.setGroup(new GroupSymbol(pGroupName));
                insert.setVariables(variables);
                insert.setValues(values);
                AssignmentStatement assignStmt = new AssignmentStatement(rowsUpdated, insert);
                Block b = new Block();
                b.addStatement(assignStmt);
                cupc = new CreateUpdateProcedureCommand(b);
                break;
            }
            case 2: {
                ArrayList variables = new ArrayList();
                ArrayList values = new ArrayList();
                UpdateProcedureGenerator.mapElements(selectSymbols, elementsInVG, pGroupName, metadata, variables, values);
                Update update = new Update();
                update.setGroup(new GroupSymbol(pGroupName));
                for (int i = 0; i < variables.size(); ++i) {
                    ElementSymbol variable = (ElementSymbol)variables.get(i);
                    Expression value = (Expression)values.get(i);
                    update.addChange(variable, value);
                }
                update.setCriteria(new TranslateCriteria(new CriteriaSelector()));
                AssignmentStatement assignStmt = new AssignmentStatement(rowsUpdated, update);
                Block b = new Block();
                b.addStatement(assignStmt);
                cupc = new CreateUpdateProcedureCommand(b);
                break;
            }
            case 3: {
                Delete delete = new Delete();
                delete.setGroup(new GroupSymbol(pGroupName));
                delete.setCriteria(new TranslateCriteria(new CriteriaSelector()));
                AssignmentStatement assignStmt = new AssignmentStatement(rowsUpdated, delete);
                Block b = new Block();
                b.addStatement(assignStmt);
                cupc = new CreateUpdateProcedureCommand(b);
                break;
            }
        }
        return cupc;
    }

    private static void mapElements(List physicalElements, List virtualElements, String physicalGroup, QueryMetadataInterface metadata, List variables, List values) throws MetaMatrixComponentException, QueryMetadataException {
        if (physicalElements.size() != virtualElements.size()) {
            throw new QueryMetadataException("ERR.015.010.0018", QueryPlugin.Util.getString("ERR.015.010.0018"));
        }
        for (int i = 0; i < physicalElements.size(); ++i) {
            Object mid;
            boolean supportsUpdate;
            SingleElementSymbol pSymbol = (SingleElementSymbol)physicalElements.get(i);
            if (pSymbol instanceof AliasSymbol) {
                pSymbol = ((AliasSymbol)pSymbol).getSymbol();
            }
            if (!(pSymbol instanceof ElementSymbol) || !(supportsUpdate = metadata.elementSupports(mid = ((ElementSymbol)pSymbol).getMetadataID(), 5))) continue;
            String properName = metadata.getFullElementName(physicalGroup, pSymbol.getShortName());
            variables.add(new ElementSymbol(properName));
            String virtualElementName = metadata.getFullName(virtualElements.get(i));
            String virtualElementShortName = metadata.getShortElementName(virtualElementName);
            ElementSymbol inputElement = new ElementSymbol("INPUT." + virtualElementShortName);
            values.add(inputElement);
        }
    }
}

