/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.security.api.Credentials;
import java.io.Serializable;
import java.util.Date;

public class PasswordCredentials
implements Credentials,
Serializable {
    private char[] credentials = null;
    private byte[] bytecredentials = null;
    private boolean encrypted = false;
    private boolean digested = false;
    private String lastChangedBy;
    private Date lastChangedDate;

    public PasswordCredentials(byte[] credentials, boolean encrypted, boolean digested) {
        this.bytecredentials = credentials;
        this.encrypted = encrypted;
        this.digested = digested;
    }

    public PasswordCredentials(char[] credentials, boolean encrypted) {
        this.credentials = credentials;
        this.encrypted = encrypted;
    }

    public PasswordCredentials(char[] credentials) {
        this(credentials, false);
    }

    private PasswordCredentials() {
    }

    public byte[] getByteCredentials() {
        return this.bytecredentials;
    }

    public byte[] getCredentialsAsByteArray() {
        return String.valueOf(this.credentials).getBytes();
    }

    public char[] getCredentialsAsCharArray() {
        return this.credentials;
    }

    public boolean isDigested() {
        return this.digested;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public String getLastChangedBy() {
        return this.lastChangedBy;
    }

    public Date getLastChangedDate() {
        return this.lastChangedDate;
    }

    public void setLastChangedBy(String lastChangedByName) {
        this.lastChangedBy = lastChangedByName;
    }

    public void setLastChangedDate(Date lastChangedByDate) {
        this.lastChangedDate = lastChangedByDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PasswordCredentials)) {
            return false;
        }
        int theLen = this.credentials.length;
        char[] other = ((PasswordCredentials)o).credentials;
        if (theLen != other.length) {
            return false;
        }
        for (int i = 0; i < theLen; ++i) {
            if (this.credentials[i] == other[i]) continue;
            return false;
        }
        return true;
    }
}

