/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.net.SocketHelper;
import com.metamatrix.common.util.VMNaming;
import java.io.DataOutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class NetUtils {
    public static final String DOT_DELIMITER = ".";
    public static final String SLASH_DELIMITER = "/";
    public static final String COMMA_DELIMITER = ",";
    public static final String COLON_DELIMITER = ":";
    public static final String BACKSLASH_DELIMITER = "\\";
    public static final String METAMATRIX_PROTOCOL = "mm";
    public static final String SECURE_METAMATRIX_PROTOCOL = "mms";
    public static final String STANDALONE = "standalone";
    public static final String APPSERVER_PROPERTY = "metamatrix.deployment.platform";
    private static final String PING = "Ping";
    private static String hostName = null;

    public static String createAppServerURL(String appHostName, String appHostPort) {
        return appHostName + COLON_DELIMITER + appHostPort;
    }

    public static synchronized String getHostname() throws UnknownHostException {
        if (hostName == null) {
            return NetUtils.resolveHostName();
        }
        return hostName;
    }

    public static synchronized String getHostShortName() throws UnknownHostException {
        if (hostName == null) {
            return NetUtils.getHostShortName(InetAddress.getLocalHost().getHostName());
        }
        return NetUtils.getHostShortName(hostName);
    }

    public static synchronized String getHostShortName(String hostname) throws UnknownHostException {
        StringTokenizer tokens = new StringTokenizer(hostname, DOT_DELIMITER);
        return tokens.nextToken();
    }

    public static String resolveHostName() {
        try {
            String hname = InetAddress.getLocalHost().getCanonicalHostName();
            if (hname != null) {
                return hname;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            InetAddress haddress = NetUtils.getFirstNonLoopbackAddress();
            return haddress.getHostName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static synchronized void setHostName(String name) {
        hostName = name;
    }

    public static String getHostAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public static String getFilename(String uri) {
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        int index = uri.lastIndexOf(SLASH_DELIMITER);
        if (index != -1) {
            return uri.substring(++index).trim();
        }
        return uri.trim();
    }

    public static String getFilenameWithoutSuffix(String uri) {
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        String filename = NetUtils.getFilename(uri);
        int index = filename.indexOf(DOT_DELIMITER);
        if (index != -1) {
            return filename.substring(0, index);
        }
        return filename;
    }

    public static String parseHost(String serverURL) {
        int portIndex = serverURL.lastIndexOf(COLON_DELIMITER);
        if (portIndex < 0) {
            portIndex = serverURL.length();
        }
        int urlProtocolIndex = serverURL.lastIndexOf(SLASH_DELIMITER);
        if (urlProtocolIndex < 0) {
            urlProtocolIndex = serverURL.lastIndexOf(BACKSLASH_DELIMITER);
        }
        if (urlProtocolIndex < 0) {
            return "";
        }
        return serverURL.substring(urlProtocolIndex + 1, portIndex);
    }

    public static String parsePort(String serverURL) {
        int portIndex = serverURL.lastIndexOf(COLON_DELIMITER);
        if (portIndex >= 0) {
            return serverURL.substring(portIndex + 1);
        }
        return "";
    }

    public static boolean ping(String host, int port) throws UnknownHostException {
        InetAddress inet = InetAddress.getByName(host);
        try {
            Socket ss = SocketHelper.getClientSocket((InetAddress)inet, (int)port);
            DataOutputStream out = new DataOutputStream(ss.getOutputStream());
            out.write(PING.getBytes());
            try {
                ss.close();
            }
            catch (Exception ce) {
                // empty catch block
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isPortAvailable(String host, int port) throws UnknownHostException {
        InetAddress inet = InetAddress.getByName(host);
        try {
            ServerSocket ss = new ServerSocket(port, 50, inet);
            try {
                ss.close();
            }
            catch (Exception ce) {
                // empty catch block
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isLocalHost(String mmurl) {
        if (VMNaming.getVMName() == null) {
            return false;
        }
        String localHostName = null;
        String fullHostName = null;
        try {
            localHostName = NetUtils.getHostShortName();
            fullHostName = NetUtils.getHostname();
        }
        catch (UnknownHostException err) {
            return false;
        }
        MMURL url = new MMURL(mmurl);
        Iterator it = url.getHostInfo().iterator();
        while (it.hasNext()) {
            HostInfo hi = (HostInfo)it.next();
            if (!hi.getHostName().equalsIgnoreCase(localHostName) && !hi.getHostName().equalsIgnoreCase(fullHostName) || VMNaming.getVMPort() != hi.getPortNumber()) continue;
            return true;
        }
        return false;
    }

    public static InetAddress getFirstNonLoopbackAddress() throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        boolean preferIpv4 = Boolean.getBoolean("java.net.preferIPv4Stack");
        boolean preferIPv6 = Boolean.getBoolean("java.net.preferIPv6Addresses");
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress()) continue;
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    return addr;
                }
                if (!(addr instanceof Inet6Address) || preferIpv4) continue;
                return addr;
            }
        }
        return null;
    }

    public static List getAllAvailableInterfaces() throws SocketException {
        ArrayList<NetworkInterface> retval = new ArrayList<NetworkInterface>(10);
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface intf = en.nextElement();
            retval.add(intf);
        }
        return retval;
    }
}

