/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.api.objects;

import com.metamatrix.admin.AdminPlugin;
import java.io.Serializable;

public class AdminOptions
implements Serializable {
    public static final int BINDINGS_IGNORE_DECRYPT_ERROR = 8;
    private static final int ALLOWABLEOPTIONS = 15;
    private int optionsMask;

    public AdminOptions(int option) throws RuntimeException {
        this.addOption(option);
    }

    public void addOption(int anOption) {
        if (anOption != 0 && (0xF & anOption) == anOption) {
            this.optionsMask |= anOption;
        } else {
            throw new RuntimeException(AdminPlugin.Util.getString("AdminOptions.Unknown_option", new Object[]{"" + anOption}));
        }
    }

    public boolean containsOption(int anOption) {
        return (this.optionsMask & anOption) == anOption;
    }

    public String toString() {
        StringBuffer optionString = new StringBuffer("[");
        if ((this.optionsMask & 1) == 1) {
            optionString.append("OnConflict_OVERWRITE, ");
        }
        if ((this.optionsMask & 2) == 2) {
            optionString.append("OnConflict_IGNORE, ");
        }
        if ((this.optionsMask & 4) == 4) {
            optionString.append("OnConflict_EXCEPTION, ");
        }
        if ((this.optionsMask & 8) == 8) {
            optionString.append("BINDINGS_IGNORE_DECRYPT_ERROR, ");
        }
        if (optionString.length() == 1) {
            optionString.append("UNKNOWN");
        } else if (optionString.length() > 2 && optionString.charAt(optionString.length() - 2) == ',') {
            optionString.setLength(optionString.length() - 2);
        }
        optionString.append(']');
        return optionString.toString();
    }

    public static interface OnConflict {
        public static final int OVERWRITE = 1;
        public static final int IGNORE = 2;
        public static final int EXCEPTION = 4;
    }
}

