/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.lang.XQuery;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VariableReplacementVisitor
extends LanguageVisitor {
    private Map paramValues;
    private MetaMatrixException exception;
    private boolean replaceWithExternalReference = false;

    public VariableReplacementVisitor(Map paramValues, QueryMetadataInterface metadata) {
        this.paramValues = paramValues;
    }

    public MetaMatrixException getException() {
        return this.exception;
    }

    public void visit(BetweenCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        obj.setLowerExpression(this.replaceExpression(obj.getLowerExpression()));
        obj.setUpperExpression(this.replaceExpression(obj.getUpperExpression()));
    }

    public void visit(CaseExpression obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            whens.add(this.replaceExpression(obj.getWhenExpression(i)));
            thens.add(this.replaceExpression(obj.getThenExpression(i)));
        }
        obj.setWhen(whens, thens);
        obj.setElseExpression(this.replaceExpression(obj.getElseExpression()));
    }

    public void visit(CompareCriteria obj) {
        obj.setLeftExpression(this.replaceExpression(obj.getLeftExpression()));
        obj.setRightExpression(this.replaceExpression(obj.getRightExpression()));
    }

    public void visit(Function obj) {
        Expression[] args = obj.getArgs();
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.replaceExpression(args[i]);
            }
        }
    }

    public void visit(IsNullCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    public void visit(MatchCriteria obj) {
        obj.setLeftExpression(this.replaceExpression(obj.getLeftExpression()));
        obj.setRightExpression(this.replaceExpression(obj.getRightExpression()));
    }

    public void visit(SearchedCaseExpression obj) {
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            thens.add(this.replaceExpression(obj.getThenExpression(i)));
        }
        obj.setWhen(obj.getWhen(), thens);
        obj.setElseExpression(this.replaceExpression(obj.getElseExpression()));
    }

    public void visit(SetCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        List values = obj.getValues();
        ArrayList<Expression> newValues = new ArrayList<Expression>(values.size());
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            Expression expr = (Expression)iter.next();
            newValues.add(this.replaceExpression(expr));
        }
        obj.setValues(newValues);
    }

    public void visit(DependentSetCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    private Expression replaceExpression(Expression expression) {
        if (expression instanceof ElementSymbol) {
            String name = ((ElementSymbol)expression).getCanonicalName();
            Object id = ((ElementSymbol)expression).getMetadataID();
            String aliasName = name;
            if (id instanceof TempMetadataID) {
                aliasName = ((TempMetadataID)id).getID();
            }
            if (this.paramValues.containsKey(name) || this.paramValues.containsKey(aliasName)) {
                Expression replacement = (Expression)this.paramValues.get(name);
                if (replacement == null) {
                    replacement = (Expression)this.paramValues.get(aliasName);
                }
                if (replacement != null) {
                    if (!this.replaceWithExternalReference && replacement instanceof ElementSymbol && ((ElementSymbol)replacement).isExternalReference()) {
                        return expression;
                    }
                    replacement = (Expression)replacement.clone();
                }
                return replacement;
            }
        }
        return expression;
    }

    public void visit(Insert obj) {
        List values = obj.getValues();
        ArrayList<Expression> newValues = new ArrayList<Expression>(values.size());
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            Expression value = (Expression)iter.next();
            newValues.add(this.replaceExpression(value));
        }
        obj.setValues(newValues);
    }

    public void visit(Update obj) {
        List changes = obj.getChangeList();
        Iterator iter = changes.iterator();
        while (iter.hasNext()) {
            CompareCriteria change = (CompareCriteria)iter.next();
            this.visit(change);
        }
    }

    public void visit(StoredProcedure obj) {
        Iterator paramIter = obj.getInputParameters().iterator();
        this.replaceWithExternalReference = true;
        while (paramIter.hasNext()) {
            SPParameter param = (SPParameter)paramIter.next();
            Expression expr = param.getExpression();
            if (expr == null) continue;
            if (expr instanceof ElementSymbol) {
                param.setExpression(this.replaceExpression(expr));
                continue;
            }
            expr.acceptVisitor(this);
        }
        this.replaceWithExternalReference = false;
    }

    public void visit(AssignmentStatement obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    public void visit(Select obj) {
        List values = obj.getSymbols();
        ArrayList newValues = new ArrayList(values.size());
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            Object replacedValue = iter.next();
            if (replacedValue instanceof SingleElementSymbol) {
                SingleElementSymbol elementValue = (SingleElementSymbol)replacedValue;
                if ((replacedValue = this.replaceExpression(elementValue)) instanceof Constant) {
                    replacedValue = new ExpressionSymbol(elementValue.getCanonicalName(), (Constant)replacedValue);
                } else if (replacedValue instanceof Function) {
                    replacedValue = new ExpressionSymbol(elementValue.getCanonicalName(), (Function)replacedValue);
                }
            }
            newValues.add(replacedValue);
        }
        obj.setSymbols(newValues);
    }

    public void visit(AliasSymbol obj) {
        Expression replacedValue = this.replaceExpression(obj.getSymbol());
        if (replacedValue instanceof Constant) {
            replacedValue = new ExpressionSymbol(obj.getCanonicalName(), (Constant)replacedValue);
        } else if (replacedValue instanceof Function) {
            replacedValue = new ExpressionSymbol(obj.getCanonicalName(), (Function)replacedValue);
        }
        if (obj != replacedValue) {
            obj.setSymbol((SingleElementSymbol)replacedValue);
        }
    }

    public void visit(XQuery obj) {
        obj.getCompiledXQuery().setParameters(this.paramValues);
    }
}

