/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.LogicalCriteria;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompoundCriteria
extends LogicalCriteria {
    public static final int OR = 1;
    public static final int AND = 0;
    private List criteria = new ArrayList();
    private int operator = 0;

    public CompoundCriteria() {
    }

    public CompoundCriteria(List criteria) {
        this();
        Iterator iter = criteria.iterator();
        while (iter.hasNext()) {
            this.addCriteria((Criteria)iter.next());
        }
    }

    public CompoundCriteria(int operator, Criteria left, Criteria right) {
        this();
        this.set(operator, left, right);
    }

    public CompoundCriteria(int operator, List criteria) {
        this();
        this.set(operator, criteria);
    }

    public int getOperator() {
        return this.operator;
    }

    private boolean isValidOperator(int operator) {
        return operator == 1 || operator == 0;
    }

    public void setOperator(int operator) {
        if (!this.isValidOperator(operator)) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0002", operator));
        }
        this.operator = operator;
    }

    public List getCriteria() {
        return this.criteria;
    }

    public void setCriteria(List criteria) {
        this.criteria = criteria;
    }

    public int getCriteriaCount() {
        return this.criteria.size();
    }

    public Criteria getCriteria(int index) {
        return (Criteria)this.criteria.get(index);
    }

    public void addCriteria(Criteria criteria) {
        this.criteria.add(criteria);
    }

    protected void reset() {
        this.criteria.clear();
    }

    public void set(int operator, Criteria left, Criteria right) {
        this.reset();
        this.setOperator(operator);
        this.addCriteria(left);
        this.addCriteria(right);
    }

    public void set(int operator, Criteria criteria) {
        this.reset();
        this.setOperator(operator);
        this.addCriteria(criteria);
    }

    public void set(int operator, List criteria) {
        this.reset();
        this.setOperator(operator);
        Iterator iter = criteria.iterator();
        while (iter.hasNext()) {
            this.addCriteria((Criteria)iter.next());
        }
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode(hc, this.getOperator());
        hc = HashCodeUtil.hashCode(hc, this.getCriteria());
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CompoundCriteria cc = (CompoundCriteria)obj;
        return cc.getOperator() == this.getOperator() && EquivalenceUtil.areEqual(cc.getCriteria(), this.getCriteria());
    }

    public Object clone() {
        CompoundCriteria copy = new CompoundCriteria();
        copy.setOperator(this.getOperator());
        List crits = this.getCriteria();
        for (int i = 0; i < crits.size(); ++i) {
            Criteria crit = (Criteria)crits.get(i);
            if (crit == null) {
                copy.addCriteria(null);
                continue;
            }
            copy.addCriteria((Criteria)crit.clone());
        }
        return copy;
    }
}

