/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.core.log.Logger;
import com.metamatrix.data.api.ValueChunk;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.query.util.ValueID;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class StreamImpl
extends InputStream {
    private ValueID valueID;
    private MMStatement statement;
    private long clientID = -1L;
    public static final int DEFAULT_CHUNK_SIZE = 102400;
    private byte[] buf;
    private char[] charBuf;
    private int bufferLength;
    private int pos;
    private int count;
    private boolean isClosed = false;
    private int offset;
    private long length = -1L;
    private boolean charBinary;
    private boolean streamEnded;
    static /* synthetic */ Class class$com$metamatrix$jdbc$StreamImpl;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMStatement;
    static /* synthetic */ Class class$com$metamatrix$query$util$ValueID;

    public static StreamImpl newInstance(MMStatement statement, ValueID valueID, boolean charBinary) throws SQLException {
        if (AOP.useproxy()) {
            return (StreamImpl)ProxyFactory.extend(class$com$metamatrix$jdbc$StreamImpl == null ? (class$com$metamatrix$jdbc$StreamImpl = StreamImpl.class$("com.metamatrix.jdbc.StreamImpl")) : class$com$metamatrix$jdbc$StreamImpl, new Class[]{class$com$metamatrix$jdbc$MMStatement == null ? (class$com$metamatrix$jdbc$MMStatement = StreamImpl.class$("com.metamatrix.jdbc.MMStatement")) : class$com$metamatrix$jdbc$MMStatement, class$com$metamatrix$query$util$ValueID == null ? (class$com$metamatrix$query$util$ValueID = StreamImpl.class$("com.metamatrix.query.util.ValueID")) : class$com$metamatrix$query$util$ValueID, Boolean.TYPE}, new Object[]{statement, valueID, new Boolean(charBinary)});
        }
        return new StreamImpl(statement, valueID, charBinary);
    }

    public static StreamImpl newInstance(MMStatement statement, ValueID valueID) throws SQLException {
        return StreamImpl.newInstance(statement, valueID, false);
    }

    public StreamImpl(MMStatement statement, ValueID valueID, boolean charBinary) throws SQLException {
        this.statement = statement;
        this.valueID = valueID;
        this.clientID = statement.getCurrentRequestID();
        this.charBinary = charBinary;
    }

    public StreamImpl(MMStatement statement, ValueID valueID) throws SQLException {
        this(statement, valueID, false);
    }

    public Logger getLogger() {
        return this.statement.getLogger();
    }

    public int read() throws IOException {
        this.ensureOpen();
        if (this.pos < this.count) {
            int currentPos = this.pos - this.offset;
            ++this.pos;
            return this.buf[currentPos++] & 0xFF;
        }
        this.getValueChunk(this.valueID, this.count, 102400);
        this.count += this.buf.length;
        int currentPos = this.pos - this.offset;
        ++this.pos;
        return this.pos < this.count ? this.buf[currentPos++] & 0xFF : -1;
    }

    int read(byte[] b, int size) throws IOException {
        return this.read(b, 0, size);
    }

    int read(char[] c, int off, int len) throws IOException {
        return this.read(c, off, len, false, c.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(b, off, len, true, b.length);
    }

    private Object getBuffer(boolean binary) {
        return binary ? this.buf : (byte[])this.charBuf;
    }

    private int read(Object b, int off, int len, boolean binary, int inputBufferLength) throws IOException {
        int start = this.pos;
        this.ensureOpen();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > inputBufferLength || len < 0 || off + len > inputBufferLength || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int remaining = len;
        while (remaining > 0) {
            if (this.pos < this.count) {
                if (remaining + this.pos <= this.count) {
                    System.arraycopy(this.getBuffer(binary), this.pos - this.offset, b, off, len);
                    off += len;
                    this.pos += len;
                    remaining -= len;
                    continue;
                }
                System.arraycopy(this.getBuffer(binary), this.pos - this.offset, b, off, this.count - this.pos);
                off += this.count - this.pos;
                remaining -= this.count - this.pos;
                this.pos += this.count - this.pos;
                continue;
            }
            this.getValueChunk(this.valueID, this.count, 102400);
            if (this.bufferLength == 0) break;
            this.count += this.bufferLength;
            if (remaining <= this.bufferLength) {
                System.arraycopy(this.getBuffer(binary), this.pos - this.offset, b, off, remaining);
                off += remaining;
                this.pos += remaining;
                remaining -= remaining;
                continue;
            }
            System.arraycopy(this.getBuffer(binary), this.pos - this.offset, b, off, this.bufferLength);
            off += this.bufferLength;
            this.pos += this.bufferLength;
            remaining -= this.bufferLength;
        }
        return this.pos - start > 0 ? this.pos - start : -1;
    }

    public long skip(long n) throws IOException {
        int start = this.pos;
        this.ensureOpen();
        if (n <= 0L) {
            return 0L;
        }
        long remaining = n;
        while (remaining > 0L) {
            if (this.pos < this.count) {
                if (remaining + (long)this.pos <= (long)this.count) {
                    this.pos = (int)((long)this.pos + n);
                    remaining -= n;
                    continue;
                }
                remaining -= (long)(this.count - this.pos);
                this.pos += this.count - this.pos;
                continue;
            }
            this.getValueChunk(this.valueID, this.count, 102400);
            if (this.bufferLength == 0) break;
            this.count += this.bufferLength;
            if (remaining <= (long)this.bufferLength) {
                this.pos = (int)((long)this.pos + remaining);
                remaining -= remaining;
                continue;
            }
            this.pos += this.bufferLength;
            remaining -= (long)this.bufferLength;
        }
        return this.pos - start;
    }

    public int available() throws IOException {
        this.ensureOpen();
        if (this.count - this.pos > 0) {
            return this.count - this.pos;
        }
        return 0;
    }

    protected long length() throws IOException {
        this.ensureOpen();
        if (this.length != -1L) {
            return this.length;
        }
        this.length = this.getStreamLength(this.valueID);
        return this.length;
    }

    public void close() throws IOException {
        this.valueID = null;
        this.isClosed = true;
        this.buf = null;
        this.charBuf = null;
        this.pos = 0;
        this.count = 0;
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException(JDBCPlugin.Util.getString("StreamImpl._Unable_to_operate_on_already_closed_stream._2"));
        }
    }

    private void getValueChunk(ValueID valueID, int startPos, int size) throws IOException {
        this.offset += this.bufferLength;
        this.bufferLength = 0;
        if (this.streamEnded) {
            this.buf = new byte[0];
            this.charBuf = new char[0];
            return;
        }
        try {
            RequestMessage request = new RequestMessage();
            request.setLobRequest(true);
            request.setValueID(valueID);
            request.setStartPosition(startPos);
            request.setChunkSize(size);
            request.setRequestID(new RequestID(this.clientID));
            request.setMessageKey("LOB_" + Long.toString(this.clientID));
            ResultsMessage message = (ResultsMessage)this.statement.executeAsynchAndWait(request, false);
            if (message.getException() != null) {
                throw message.getException();
            }
            ValueChunk chunk = message.getValueChunk();
            this.streamEnded = chunk.isLast();
            if (!chunk.isBinary()) {
                this.charBuf = message.getValueChunk().getChars();
                if (this.charBuf != null) {
                    this.bufferLength = this.charBuf.length;
                    if (this.charBinary) {
                        this.buf = new String(this.charBuf).getBytes("ASCII");
                    }
                }
            } else {
                this.buf = chunk.getBytes();
                if (this.buf != null) {
                    this.bufferLength = this.buf.length;
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.isClosed = true;
            throw new IOException(JDBCPlugin.Util.getString("StreamImpl.Unable_to_read_data_from_stream", ex.getMessage()));
        }
    }

    private long getStreamLength(ValueID valueID) throws IOException {
        try {
            RequestMessage request = new RequestMessage();
            request.setLobRequest(true);
            request.setValueID(valueID);
            request.setRequestID(new RequestID(this.clientID));
            request.setMessageKey("LOB_" + Long.toString(this.clientID));
            ResultsMessage message = (ResultsMessage)this.statement.executeAsynchAndWait(request, false);
            if (message.getException() != null) {
                throw message.getException();
            }
            this.length = message.getStreamLength();
        }
        catch (Throwable ex) {
            this.isClosed = true;
            throw new IOException(JDBCPlugin.Util.getString("StreamImpl.Unable_to_get_stream_length", ex.getMessage()));
        }
        return this.length;
    }

    public void reset() throws IOException {
        if (this.pos == 0) {
            return;
        }
        this.offset = 0;
        this.length = -1L;
        this.pos = 0;
        this.buf = null;
        this.charBuf = null;
        this.streamEnded = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

