/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.jdbc.DataTypeTransformer;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.api.ResultSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public abstract class MMResultSet
implements ResultSet {
    protected Object currentValue;
    protected boolean isClosed = false;

    public void cancelRowUpdates() throws SQLException {
        this.checkClosed();
    }

    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            String msg = JDBCPlugin.Util.getString("MMResultSet.Cant_call_closed_resultset");
            throw new MMSQLException(msg);
        }
    }

    public void deleteRow() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public Array getArray(int columnIndex) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public Array getArray(String columnName) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return null;
        }
        return DataTypeTransformer.getBigDecimal(this.currentValue);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return null;
        }
        BigDecimal bigDecimalObject = DataTypeTransformer.getBigDecimal(this.currentValue);
        return bigDecimalObject.setScale(scale);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof Blob) {
            return ((Blob)value).getBinaryStream();
        }
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return null;
        }
        return DataTypeTransformer.getBlob(this.currentValue);
    }

    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return false;
        }
        return DataTypeTransformer.getBoolean(this.currentValue);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return -1;
        }
        return DataTypeTransformer.getByte(this.currentValue);
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return null;
        }
        return DataTypeTransformer.getBytes(this.currentValue);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof Clob) {
            return ((Clob)value).getCharacterStream();
        }
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return null;
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        return DataTypeTransformer.getDate(this.currentValue, this.getDefaultCalendar(), cal);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return 0.0;
        }
        return DataTypeTransformer.getDouble(this.currentValue);
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    public float getFloat(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return 0.0f;
        }
        return DataTypeTransformer.getFloat(this.currentValue).floatValue();
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public int getInt(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return 0;
        }
        return DataTypeTransformer.getInteger(this.currentValue);
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return 0L;
        }
        return DataTypeTransformer.getLong(this.currentValue);
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public Ref getRef(int columnIndex) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public Ref getRef(String columnName) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public URL getURL(String columnName) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public URL getURL(int columnIndex) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public short getShort(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return 0;
        }
        return DataTypeTransformer.getShort(this.currentValue);
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public String getString(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return null;
        }
        return this.currentValue.toString();
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return null;
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        return DataTypeTransformer.getTime(this.currentValue, this.getDefaultCalendar(), cal);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.currentValue = this.getObject(columnIndex);
        if (this.currentValue == null) {
            return null;
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        return DataTypeTransformer.getTimestamp(this.currentValue, this.getDefaultCalendar(), cal);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void insertRow() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void refreshRow() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public boolean rowDeleted() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public boolean rowInserted() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public boolean rowUpdated() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setFetchDirection(int direction) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setFetchSize(int rows) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateBlob(String columnName, Blob b) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateBlob(int columnIndex, Blob b) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateClob(String columnName, Clob c) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateClob(int columnIndex, Clob c) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateNull(int columnIndex) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateNull(String columnName) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateRow() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateString(String columnName, String x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateRef(String columnName, Ref r) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void updateRef(int columnIndex, Ref r) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.currentValue == null;
    }

    protected abstract Calendar getDefaultCalendar();

    protected abstract Map getUpdatedPlanDescription();
}

