/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.log;

import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.HashCodeUtil;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;

public class EclipsePlatformLogListener
implements LogListener {
    private final ILog pluginLog;
    private final String pluginID;

    public EclipsePlatformLogListener(Plugin plugin) {
        Assertion.isNotNull(plugin);
        this.pluginLog = plugin.getLog();
        this.pluginID = plugin.getBundle().getSymbolicName();
    }

    public void logMessage(IStatus msg, long timestamp, String pluginID, String threadName) {
        if ((msg.getSeverity() == 4 || msg.getSeverity() == 2) && this.pluginID.equals(msg.getPlugin())) {
            this.pluginLog.log(msg);
        }
    }

    public void shutdown() {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof EclipsePlatformLogListener)) {
            return false;
        }
        EclipsePlatformLogListener that = (EclipsePlatformLogListener)obj;
        return this.pluginID.equals(that.pluginID);
    }

    public String toString() {
        return "EclipsePlatformLogListener " + this.pluginID;
    }

    public int hashCode() {
        int hash = 0;
        hash = HashCodeUtil.hashCode(hash, this.pluginID);
        return hash;
    }
}

