/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.properties;

import com.metamatrix.common.properties.AbstractMultiValuedProperty;
import com.metamatrix.common.properties.MultiValuedProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class OrderedMultiValuedProperty
extends AbstractMultiValuedProperty {
    private List values;
    private List unmodifiableValues;

    public OrderedMultiValuedProperty(String name, Collection values) {
        super(name);
        this.setValues(values);
        this.unmodifiableValues = Collections.unmodifiableList(this.values);
    }

    public OrderedMultiValuedProperty(String name, String value) {
        super(name);
        this.values = new ArrayList(1);
        this.values.add(value);
        this.unmodifiableValues = Collections.unmodifiableList(this.values);
    }

    public OrderedMultiValuedProperty(String name) {
        this(name, (Collection)null);
    }

    protected OrderedMultiValuedProperty(MultiValuedProperty obj) {
        super(obj);
        this.setValues(obj.getValues());
        this.unmodifiableValues = Collections.unmodifiableList(this.values);
    }

    public String getValue(int index) {
        return (String)this.values.get(index);
    }

    public Collection getValues() {
        return this.unmodifiableValues;
    }

    public boolean containsValue(String value) {
        return this.values.contains(value);
    }

    public int size() {
        return this.values.size();
    }

    public void clear() {
        this.values.clear();
    }

    public boolean isOrdered() {
        return true;
    }

    public void setValues(Collection values) {
        int initialSize;
        int n = initialSize = values != null ? values.size() : 0;
        if (this.values != null) {
            this.values.clear();
        } else {
            this.values = new ArrayList(initialSize);
            this.unmodifiableValues = Collections.unmodifiableList(this.values);
        }
        if (values != null) {
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                String str = obj != null ? obj.toString() : "";
                this.values.add(str);
            }
        }
    }

    public String remove(int index) {
        return (String)this.values.remove(index);
    }

    public boolean remove(String value) {
        String newValue = value != null ? value : "";
        return this.values.remove(newValue);
    }

    public String set(int index, String value) {
        String newValue = value != null ? value : "";
        return this.values.set(index, newValue);
    }

    public void add(int index, String value) {
        String newValue = value != null ? value : "";
        this.values.add(index, newValue);
    }

    public void add(String value) {
        String newValue = value != null ? value : "";
        this.values.add(newValue);
    }

    public void add(Collection values) {
        this.values.addAll(values);
    }

    public Object clone() {
        return new OrderedMultiValuedProperty(this);
    }

    public static void main(String[] args) {
        OrderedMultiValuedProperty mvp1 = new OrderedMultiValuedProperty("Property.A");
        mvp1.add("Value1");
        mvp1.add("Value2");
        mvp1.add("Value1");
        System.out.println("mvp1 -> " + ((Object)mvp1).toString());
        mvp1.set(1, "Value1");
        System.out.println("mvp1 -> " + ((Object)mvp1).toString());
        System.out.println("\n");
        OrderedMultiValuedProperty mvp2 = new OrderedMultiValuedProperty("Property.B");
        mvp2.add("Value1");
        mvp2.add("Value2");
        mvp2.add("Value1");
        System.out.println("mvp2 -> " + ((Object)mvp2).toString());
        mvp2.set(2, "Value1");
        System.out.println("mvp2 -> " + ((Object)mvp2).toString());
        System.out.println("\n");
        OrderedMultiValuedProperty mvp1a = new OrderedMultiValuedProperty("Property.A");
        mvp1a.add("Value1");
        mvp1a.add("Value2");
        mvp1a.add("Value1");
        System.out.println("mvp1a-> " + ((Object)mvp1a).toString());
    }
}

