/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDARequest;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public class DRDABindRequest
extends DRDARequest {
    private static String footprint = "$Revision:   3.16.1.0  $";
    protected String packageName = null;
    public BaseParameters parameterDescriptions;
    protected String isolationLevel;
    protected String defaultQualifier;
    protected String packageOwner;
    protected String collectionId;
    protected String packageVersion;
    protected int dynamicSections;
    protected boolean replace;
    protected DRDAPkgNamCsn packageConsistencyToken;

    public DRDABindRequest(DB2ImplConnection dB2ImplConnection, DRDACommunication dRDACommunication, DRDAByteOrderedDataReader dRDAByteOrderedDataReader, DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter, String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        super(dB2ImplConnection, dRDACommunication, dRDAByteOrderedDataReader, dRDAByteOrderedDataWriter);
        this.collectionId = string2;
        this.isolationLevel = string3;
        this.defaultQualifier = string4;
        this.packageOwner = string5;
        this.packageVersion = string6;
        this.replace = bl;
        this.packageConsistencyToken = new DRDAPkgNamCsn(dB2ImplConnection.databaseName, this.collectionId, this.packageName, 1, null);
    }

    public void setPackageName(String string) {
        this.packageName = string;
        this.packageConsistencyToken.setPackageName(string);
    }

    public void setReplace(boolean bl) {
        this.replace = bl;
    }

    public void setIsoLvl(String string) {
        this.isolationLevel = string;
    }

    public void writeBGNBND() throws UtilException {
        int n;
        int n2;
        int n3 = this.writer.writePacketHeader((short)1, (short)0, 1);
        int n4 = this.writer.writeCodePoint((short)8194);
        this.writer.writeInt16(22);
        this.writer.writeInt16(8464);
        this.writer.writeFixedLengthEncodedString(this.implConn.databaseName, this.comm.defaultCCSIDTransliterator, 18, (byte)64);
        this.writer.writePKGNAMCT(this.packageConsistencyToken);
        if (this.comm.SQLAMLevel >= 6 && this.comm.serverOS == 3) {
            n2 = this.writer.writeCodePoint((short)4420);
            this.writer.writeString(this.packageVersion);
            this.writer.writeCodePointLength(n2);
            if (this.replace) {
                n = this.writer.writeCodePoint((short)8493);
                this.writer.writeString(this.packageVersion);
                this.writer.writeCodePointLength(n);
            }
        }
        this.writer.writeInt16(6);
        this.writer.writeInt16(8475);
        this.writer.writeInt16(9244);
        this.writer.writeInt16(6);
        this.writer.writeInt16(8477);
        this.writer.writeInt16(9250);
        this.writer.writeInt16(6);
        this.writer.writeInt16(8496);
        this.writer.writeInt16(9274);
        if (this.comm.serverOS != 8 && this.comm.serverType != 9) {
            this.writer.writeInt16(6);
            this.writer.writeInt16(8454);
            this.writer.writeInt16(31);
        }
        if (this.defaultQualifier != null) {
            this.writer.writeInt16(22);
            this.writer.writeInt16(8488);
            this.writer.writeFixedLengthEncodedString(this.defaultQualifier, this.comm.defaultCCSIDTransliterator, 18, (byte)64);
        }
        this.writer.writeInt16(6);
        this.writer.writeInt16(8495);
        this.writer.writeInt16(1);
        this.writer.writeInt16(6);
        this.writer.writeInt16(8478);
        this.writer.writeInt16(9253);
        n2 = 0;
        if (this.isolationLevel.equalsIgnoreCase("U")) {
            n2 = 9281;
        } else if (this.isolationLevel.equalsIgnoreCase("C")) {
            n2 = 9282;
        } else if (this.isolationLevel.equalsIgnoreCase("R")) {
            n2 = 9283;
        } else if (this.isolationLevel.equalsIgnoreCase("S")) {
            n2 = 9284;
        } else if (this.isolationLevel.equalsIgnoreCase("N")) {
            n2 = 9285;
        } else {
            String[] stringArray = new String[]{this.isolationLevel};
            throw new UtilException(7072, stringArray);
        }
        this.writer.writeInt16(6);
        this.writer.writeInt16(8484);
        this.writer.writeInt16(n2);
        this.writer.writeInt16(6);
        this.writer.writeInt16(8476);
        if (this.replace) {
            this.writer.writeInt16(9247);
        } else {
            this.writer.writeInt16(9248);
        }
        if (this.packageOwner != null) {
            n = this.writer.writeCodePoint((short)8497);
            this.writer.writeString(this.packageOwner);
            this.writer.writeCodePointLength(n);
        }
        this.writer.writeInt16(6);
        this.writer.writeInt16(8498);
        this.writer.writeInt16(9239);
        this.writer.writeInt16(6);
        this.writer.writeInt16(8482);
        this.writer.writeInt16(9257);
        this.writer.writeInt16(6);
        this.writer.writeInt16(8483);
        this.writer.writeInt16(9262);
        if (this.comm.SQLAMLevel >= 7 && this.comm.serverOS != 3) {
            this.writer.writeInt16(5);
            this.writer.writeInt16(8551);
            this.writer.writeInt8(243);
        }
        this.writer.writeCodePointLength(n4);
        this.writer.writePacketLength(n3);
    }

    public void writeBNDSQLSTT(String string, int n, BaseParameters baseParameters) throws UtilException, SQLException {
        this.parameterDescriptions = baseParameters;
        int n2 = this.writer.writePacketHeader((short)1, (short)80, 1);
        int n3 = this.writer.writeCodePoint((short)8196);
        this.writer.writeInt16(22);
        this.writer.writeInt16(8464);
        this.writer.writeFixedLengthEncodedString(this.implConn.databaseName, this.comm.defaultCCSIDTransliterator, 18, (byte)64);
        this.packageConsistencyToken.setSectionNumber(n);
        this.writer.writePKGNAMCSN(this.packageConsistencyToken);
        this.writer.writeInt16(8);
        this.writer.writeInt16(8471);
        this.writer.writeInt32(n);
        if (this.comm.SQLAMLevel >= 7) {
            this.writer.writeInt16(6);
            this.writer.writeInt16(8486);
            this.writer.writeInt16(9270);
        }
        this.writer.writeCodePointLength(n3);
        this.writer.writePacketLength(n2);
        int n4 = 0;
        short s = 3;
        if (this.comm.encryptData) {
            s = 4;
        }
        n4 = baseParameters != null ? this.writer.writePacketHeader(s, (short)80, 1) : this.writer.writePacketHeader(s, (short)0, 1);
        int n5 = this.writer.writeCodePoint((short)9236);
        if (this.comm.SQLAMLevel > 6) {
            this.writer.writeInt8(255);
            this.writer.writeInt8(0);
            this.writer.writeEncodedStringWithLength32(string, this.comm.SingleByteClientTransliterator);
        } else {
            this.writer.writeEncodedStringWithLength32(string, this.comm.SingleByteClientTransliterator);
        }
        this.writer.writeCodePointLength(n5);
        if (this.comm.encryptData) {
            this.writer.writeEncryptedPacketLength(n4);
        } else {
            this.writer.writePacketLength(n4);
        }
        if (baseParameters != null) {
            int n6 = this.writer.writePacketHeader((short)3, (short)0, 1);
            int n7 = this.writer.writeCodePoint((short)9241);
            this.writeSQLSTTVRB();
            this.writer.writeCodePointLength(n6);
            this.writer.writePacketLength(n7);
        }
    }

    public void writeENDBND(int n) throws UtilException {
        int n2 = this.writer.writePacketHeader((short)1, (short)0, 1);
        int n3 = this.writer.writeCodePoint((short)8201);
        this.writer.writeInt16(22);
        this.writer.writeInt16(8464);
        this.writer.writeFixedLengthEncodedString(this.implConn.databaseName, this.comm.defaultCCSIDTransliterator, 18, (byte)64);
        this.writer.writePKGNAMCT(this.packageConsistencyToken);
        this.writer.writeInt16(6);
        this.writer.writeInt16(8487);
        this.writer.writeInt16(n);
        this.writer.writeCodePointLength(n3);
        this.writer.writePacketLength(n2);
    }

    public void writeDRPPKG() throws UtilException {
        int n = this.writer.writePacketHeader((short)1, (short)0, 1);
        int n2 = this.writer.writeCodePoint((short)8199);
        this.writer.writeInt16(22);
        this.writer.writeInt16(8464);
        this.writer.writeFixedLengthEncodedString(this.implConn.databaseName, this.comm.defaultCCSIDTransliterator, 18, (byte)64);
        this.writer.writePKGNAM(this.packageConsistencyToken);
        int n3 = this.writer.writeCodePoint((short)4420);
        this.writer.writeString(this.packageVersion);
        this.writer.writeCodePointLength(n3);
        this.writer.writeCodePointLength(n2);
        this.writer.writePacketLength(n);
    }

    public boolean processCodePoint(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (n2) {
                case 8728: {
                    break;
                }
                case 8712: {
                    break;
                }
                case 8713: {
                    this.exception = this.comm.exceptions.getException(7039);
                    break;
                }
                case 8710: {
                    this.exception = this.comm.exceptions.getException(7041);
                    break;
                }
                case 47: 
                case 53: {
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                default: {
                    return super.processCodePoint(n, n2, baseWarnings);
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
        return true;
    }

    private void writeSQLSTTVRB() throws UtilException {
        try {
            if (this.comm.serverOS != 3 && this.comm.serverOS != 8) {
                this.writer.setToLittleEndian();
            }
            this.writer.writeInt16(this.parameterDescriptions.count());
            for (int i = 0; i < this.parameterDescriptions.count(); ++i) {
                BaseParameter baseParameter = this.parameterDescriptions.get(i + 1, 1);
                this.writer.writeInt16(0);
                this.writer.writeInt16(0);
                if (this.comm.SQLAMLevel >= 6) {
                    if (baseParameter.sqlType == 1111) {
                        this.writer.writeInt64(0L);
                    } else {
                        this.writer.writeInt64(44L);
                    }
                } else if (baseParameter.sqlType == 1111) {
                    this.writer.writeInt32(0);
                } else {
                    this.writer.writeInt32(44);
                }
                this.writer.writeInt16(this.drdaUtil.JdbcToDB2Type(baseParameter.sqlType, false));
                if (baseParameter.sqlType == 1111) {
                    this.writer.writeInt16(0);
                } else {
                    this.writer.writeInt16(this.comm.clientSBCS);
                }
                String string = baseParameter.getString(-1, this.comm.exceptions);
                if (string != null) {
                    this.writer.setToBigEndian();
                    this.writer.writeEncodedStringWithLength32(string, this.comm.SingleByteClientTransliterator);
                    this.writer.setToLittleEndian();
                } else {
                    this.writer.writeInt16(0);
                }
                this.writer.writeInt32(0);
                if (this.comm.SQLAMLevel < 7) continue;
                this.writer.writeInt8(255);
            }
            this.writer.setToBigEndian();
        }
        catch (SQLException sQLException) {
            throw new UtilException(6024);
        }
    }
}

