/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class AggregateSymbolCollectorVisitor
extends LanguageVisitor {
    private Collection aggregates;
    private Collection elements;

    public AggregateSymbolCollectorVisitor(Collection aggregates, Collection elements) {
        this.aggregates = aggregates == null ? new ArrayList() : aggregates;
        this.elements = elements == null ? new ArrayList() : elements;
    }

    public Collection getAggregates() {
        return this.aggregates;
    }

    public Collection getElements() {
        return this.elements;
    }

    public void visit(AggregateSymbol obj) {
        this.aggregates.add(obj);
    }

    public void visit(BetweenCriteria obj) {
        this.collectFromExpression(obj.getExpression());
        this.collectFromExpression(obj.getLowerExpression());
        this.collectFromExpression(obj.getUpperExpression());
    }

    public void visit(CompareCriteria obj) {
        this.collectFromExpression(obj.getLeftExpression());
        this.collectFromExpression(obj.getRightExpression());
    }

    public void visit(IsNullCriteria obj) {
        this.collectFromExpression(obj.getExpression());
    }

    public void visit(MatchCriteria obj) {
        this.collectFromExpression(obj.getLeftExpression());
        this.collectFromExpression(obj.getRightExpression());
    }

    public void visit(SetCriteria obj) {
        this.collectFromExpression(obj.getExpression());
        Iterator valIter = obj.getValues().iterator();
        while (valIter.hasNext()) {
            this.collectFromExpression((Expression)valIter.next());
        }
    }

    public void visit(ExpressionSymbol obj) {
        this.collectFromExpression(obj);
    }

    public void visit(ElementSymbol obj) {
        this.elements.add(obj);
    }

    private void collectFromExpression(Expression expr) {
        if (expr instanceof ElementSymbol || expr instanceof ExpressionSymbol) {
            this.elements.add(expr);
        } else if (expr instanceof Function) {
            Expression[] args = ((Function)expr).getArgs();
            for (int i = 0; i < args.length; ++i) {
                this.collectFromExpression(args[i]);
            }
        } else if (expr instanceof CaseExpression) {
            CaseExpression caseExpr = (CaseExpression)expr;
            this.collectFromExpression(caseExpr.getExpression());
            for (int i = 0; i < caseExpr.getWhenCount(); ++i) {
                this.collectFromExpression(caseExpr.getWhenExpression(i));
                this.collectFromExpression(caseExpr.getThenExpression(i));
            }
            if (caseExpr.getElseExpression() != null) {
                this.collectFromExpression(caseExpr.getElseExpression());
            }
        } else if (expr instanceof SearchedCaseExpression) {
            SearchedCaseExpression caseExpr = (SearchedCaseExpression)expr;
            for (int i = 0; i < caseExpr.getWhenCount(); ++i) {
                this.collectFromExpression(caseExpr.getThenExpression(i));
            }
            if (caseExpr.getElseExpression() != null) {
                this.collectFromExpression(caseExpr.getElseExpression());
            }
        }
    }

    public static final void getAggregates(LanguageObject obj, Collection aggregates, Collection elements) {
        AggregateSymbolCollectorVisitor visitor = new AggregateSymbolCollectorVisitor(aggregates, elements);
        PreOrderNavigator.doVisit(obj, visitor);
    }

    public static final Collection getAggregates(LanguageObject obj, boolean removeDuplicates) {
        AbstractCollection aggregates = null;
        aggregates = removeDuplicates ? new HashSet() : new ArrayList();
        AggregateSymbolCollectorVisitor visitor = new AggregateSymbolCollectorVisitor(aggregates, new ArrayList());
        PreOrderNavigator.doVisit(obj, visitor);
        return aggregates;
    }
}

