/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.symbol.AllInGroupSymbol;
import com.metamatrix.query.sql.symbol.AllSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.MultipleElementSymbol;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Select
implements LanguageObject {
    private List symbols;
    private boolean distinct;

    public Select() {
        this.symbols = new ArrayList();
    }

    public Select(List symbols) {
        this.symbols = new ArrayList(symbols);
    }

    public int getCount() {
        return this.symbols.size();
    }

    public boolean isStar() {
        return this.symbols.size() == 1 && this.symbols.get(0) instanceof AllSymbol;
    }

    public List getSymbols() {
        return this.symbols;
    }

    public void setSymbols(List symbols) {
        this.symbols = symbols;
    }

    public SelectSymbol getSymbol(int index) {
        return (SelectSymbol)this.symbols.get(index);
    }

    public void addSymbol(SelectSymbol symbol) {
        if (symbol != null) {
            this.symbols.add(symbol);
        }
    }

    public void addSymbols(Collection symbols) {
        if (symbols != null) {
            this.symbols.addAll(symbols);
        }
    }

    public void clearSymbols() {
        this.symbols.clear();
    }

    public boolean containsSymbol(SelectSymbol symbol) {
        return this.symbols.contains(symbol);
    }

    public boolean isElementBeingSelected(ElementSymbol elementSymbol) {
        boolean isBeingSelected = this.containsSymbol(elementSymbol);
        if (!isBeingSelected) {
            GroupSymbol g = elementSymbol.getGroupSymbol();
            String groupDotStarName = g.getName() + ".*";
            Iterator i = this.getSymbols().iterator();
            while (i.hasNext()) {
                AllInGroupSymbol aigSymbol;
                Object selectSymbol = i.next();
                if (selectSymbol instanceof AllSymbol) {
                    isBeingSelected = true;
                    break;
                }
                if (!(selectSymbol instanceof AllInGroupSymbol) || !(aigSymbol = (AllInGroupSymbol)selectSymbol).getName().equalsIgnoreCase(groupDotStarName)) continue;
                isBeingSelected = true;
                break;
            }
        }
        return isBeingSelected;
    }

    public void setDistinct(boolean isDistinct) {
        this.distinct = isDistinct;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public List getProjectedSymbols() {
        ArrayList<SelectSymbol> projectedSymbols = new ArrayList<SelectSymbol>();
        Iterator iter = this.symbols.iterator();
        while (iter.hasNext()) {
            SelectSymbol symbol = (SelectSymbol)iter.next();
            if (symbol instanceof SingleElementSymbol) {
                projectedSymbols.add(symbol);
                continue;
            }
            List multiSymbols = ((MultipleElementSymbol)symbol).getElementSymbols();
            if (multiSymbols == null) continue;
            projectedSymbols.addAll(multiSymbols);
        }
        return projectedSymbols;
    }

    public Object clone() {
        List thisSymbols = this.getSymbols();
        ArrayList<Object> copySymbols = new ArrayList<Object>(thisSymbols.size());
        Iterator iter = thisSymbols.iterator();
        while (iter.hasNext()) {
            SelectSymbol ss = (SelectSymbol)iter.next();
            copySymbols.add(ss.clone());
        }
        Select copy = new Select(copySymbols);
        copy.setDistinct(this.isDistinct());
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Select other = (Select)obj;
        return other.isDistinct() == this.isDistinct() && EquivalenceUtil.areEqual(this.getSymbols(), other.getSymbols());
    }

    public int hashCode() {
        return HashCodeUtil.hashCode(0, this.getSymbols());
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

