/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.vm.controller;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.platform.PlatformPlugin;
import java.io.Serializable;

public class VMControllerID
implements Serializable {
    private long id;
    private String hostName;

    public VMControllerID(long id, String hostName) {
        this.id = id;
        this.hostName = hostName.toUpperCase();
    }

    public String getHostName() {
        return this.hostName;
    }

    public long getID() {
        return this.id;
    }

    public String toString() {
        return "VMControllerID<" + this.id + ">:" + this.hostName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return ((VMControllerID)obj).getID() == this.getID();
    }

    public int hashCode() {
        return (int)this.id;
    }

    public static String convertToString(VMControllerID vmID) {
        ArgCheck.isNotNull(vmID);
        return vmID.getHostName() + "," + vmID.getID();
    }

    public static VMControllerID convertToID(String vmIDStr) {
        long id;
        ArgCheck.isNotNull(vmIDStr);
        int index = vmIDStr.lastIndexOf(",");
        ArgCheck.isNonNegative(index, PlatformPlugin.Util.getString("ERR.014.010.0003", vmIDStr));
        String host = vmIDStr.substring(0, index);
        String idStr = vmIDStr.substring(index + 1);
        try {
            id = Long.parseLong(idStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.010.0004", vmIDStr));
        }
        return new VMControllerID(id, host);
    }
}

