/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.api;

import java.util.HashSet;
import java.util.Set;

public class SQLStates {
    public static final String DEFAULT = "38000";
    public static final SQLStateClass CLASS_USAGE_ERROR = new SQLStateClass("50");
    public static final String USAGE_ERROR = "50000";
    public static final String VIRTUAL_PROCEDURE_ERROR = "50001";
    private static final SQLStateClass[] stateClasses = new SQLStateClass[]{CLASS_USAGE_ERROR};

    public static boolean isSystemErrorState(String sqlStateCode) {
        return !SQLStates.isUsageErrorState(sqlStateCode);
    }

    public static boolean isUsageErrorState(String sqlStateCode) {
        return SQLStates.belongsToClass(sqlStateCode, CLASS_USAGE_ERROR);
    }

    public static boolean belongsToClass(String sqlStateCode, SQLStateClass sqlStateClass) {
        return sqlStateCode.startsWith(sqlStateClass.codeBeginsWith);
    }

    public static SQLStateClass getClass(String sqlStateCode) {
        for (int i = 0; i < stateClasses.length; ++i) {
            if (!stateClasses[i].containsSQLState(sqlStateCode)) continue;
            return stateClasses[i];
        }
        return null;
    }

    static {
        CLASS_USAGE_ERROR.stateCodes.add(USAGE_ERROR);
        CLASS_USAGE_ERROR.stateCodes.add(VIRTUAL_PROCEDURE_ERROR);
    }

    public static final class SQLStateClass {
        private String codeBeginsWith;
        private Set stateCodes = new HashSet();

        private SQLStateClass(String beginsWith) {
            this.codeBeginsWith = beginsWith;
        }

        public boolean containsSQLState(String sqlState) {
            return this.stateCodes.contains(sqlState);
        }
    }
}

