/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerInstance;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.jdbc.BaseDriver;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMCallableStatement;
import com.metamatrix.jdbc.MMDatabaseMetaData;
import com.metamatrix.jdbc.MMPreparedStatement;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.api.Connection;
import com.metamatrix.jdbc.api.DatabaseMetaData;
import com.metamatrix.jdbc.util.JDBCTraceLogger;
import com.metamatrix.jdbc.util.TransactionHelper;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionEventListener;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public abstract class MMConnection
implements Connection {
    private static final String DEFAULT_APP_NAME = "JDBC";
    private ServerConnection serverConn;
    private long requestIDGenerator;
    private String url;
    protected Properties propInfo;
    private int logLevel = 0;
    private PrintWriter pw;
    private String applicationName;
    private boolean closed = false;
    private boolean autoCommitFlag = true;
    private Collection statements = null;
    private UserTransaction transaction = null;
    private DatabaseMetaData dbmm = null;
    private ServerInstance serverInstance;
    private Xid transactionXid;
    private boolean readOnly = false;
    static /* synthetic */ Class class$com$metamatrix$jdbc$api$DatabaseMetaData;

    MMConnection(ServerConnection serverConn, Properties info, String url) {
        String defaultFetchSize;
        this.url = url;
        this.serverConn = serverConn;
        String overrideProp = info.getProperty("txnAutoWrap");
        if (overrideProp == null || overrideProp.trim().length() == 0) {
            info.put("txnAutoWrap", "OPTIMISTIC");
        }
        this.applicationName = info.getProperty("ApplicationName");
        if (this.applicationName == null) {
            this.applicationName = DEFAULT_APP_NAME;
        }
        if ((defaultFetchSize = info.getProperty("fetchSize")) != null) {
            info.put("fetchSize", defaultFetchSize);
        } else {
            info.put("fetchSize", "2000");
        }
        String partialResultsMode = info.getProperty("partialResultsMode");
        if (partialResultsMode != null) {
            info.put("partialResultsMode", partialResultsMode);
        } else {
            info.put("partialResultsMode", "FALSE");
        }
        String resultSetCacheMode = info.getProperty("resultSetCacheMode");
        if (resultSetCacheMode != null) {
            info.put("resultSetCacheMode", resultSetCacheMode);
        } else {
            info.put("resultSetCacheMode", "TRUE");
        }
        String allowDblQuotes = info.getProperty("allowDoubleQuotedVariable");
        if (allowDblQuotes != null) {
            info.put("allowDoubleQuotedVariable", allowDblQuotes);
        } else {
            info.put("allowDoubleQuotedVariable", Boolean.FALSE.toString());
        }
        String logFile = info.getProperty("logFile");
        this.logLevel = MMConnection.readLoggingLevel(info, this.logLevel);
        if (logFile != null && this.logLevel > 0) {
            try {
                this.pw = new PrintWriter((Writer)new FileWriter(logFile, true), true);
            }
            catch (IOException ioe) {
                String msg = JDBCPlugin.Util.getString("MMDriver.Invalid_log_name", logFile);
                this.logMessage(msg, ioe);
            }
        }
        String logMsg = JDBCPlugin.Util.getString("MMConnection.Session_success");
        this.logMessage(logMsg, null);
        if (this.logLevel >= 1) {
            this.logConnectionProperties(url, info);
        }
        this.propInfo = info;
        this.statements = Collections.synchronizedList(new ArrayList());
    }

    private void logConnectionProperties(String connUrl, Properties info) {
        StringBuffer modifiedUrl = new StringBuffer();
        if (connUrl != null) {
            int startIndex = connUrl.indexOf("password=");
            if (startIndex != -1) {
                modifiedUrl.append(connUrl.substring(0, startIndex));
                modifiedUrl.append("password=***");
                int endIndex = connUrl.indexOf(";", startIndex + 9);
                if (endIndex != -1) {
                    modifiedUrl.append(";").append(connUrl.substring(endIndex));
                }
            }
            this.logMessage("Connection Url=" + modifiedUrl, null);
        }
        if (info != null) {
            Enumeration<Object> enumeration = info.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Object anObj = info.get(key);
                if ("password".equalsIgnoreCase(key) || "clientToken".equalsIgnoreCase(key)) continue;
                this.logMessage(key + "=" + anObj, null);
            }
        }
    }

    public static int readLoggingLevel(Properties info, int defaultValue) {
        String loggingLevel = info.getProperty("logLevel");
        if (loggingLevel != null) {
            return Integer.parseInt(loggingLevel);
        }
        return defaultValue;
    }

    public static boolean isLoggingOn(Properties info) {
        int logLevel = MMConnection.readLoggingLevel(info, 0);
        return logLevel > 0;
    }

    String getUrl() {
        return this.url;
    }

    void logMessage(String message, Throwable e) {
        message = new Timestamp(System.currentTimeMillis()) + ": " + message;
        if (this.pw != null) {
            this.pw.println(message);
            if (this.logLevel > 1 && e != null) {
                e.printStackTrace(this.pw);
                if (e instanceof MetaMatrixException) {
                    MetaMatrixException me = (MetaMatrixException)e;
                    Throwable child = me.getChild();
                    while (child != null) {
                        child.printStackTrace(this.pw);
                        if (child instanceof MetaMatrixException) {
                            child = ((MetaMatrixException)child).getChild();
                            continue;
                        }
                        child = null;
                    }
                }
            }
        } else {
            DriverManager.println(message);
        }
    }

    synchronized long nextRequestID() {
        return this.requestIDGenerator++;
    }

    public void clearWarnings() throws SQLException {
    }

    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        try {
            block8: {
                try {
                    this.closeStatements();
                    if (this.serverConn == null) break block8;
                    this.serverConn.shutdown();
                }
                catch (SQLException se) {
                    String logMsg = JDBCPlugin.Util.getString("MMConnection.Err_connection_close", se.getMessage());
                    this.logMessage(logMsg, null);
                    throw MMSQLException.create(se, logMsg);
                }
                catch (CommunicationException e) {
                    String logMsg = JDBCPlugin.Util.getString("MMConnection.Err_connection_close", e.getMessage());
                    this.logMessage(logMsg, e);
                    String msg = JDBCPlugin.Util.getString("MMConnection.Err_closing_conn");
                    throw MMSQLException.create(e, msg);
                }
            }
            Object var5_1 = null;
            if (this.pw != null) {
                this.pw.close();
                this.pw = null;
            }
            this.serverConn = null;
            String logMsg = JDBCPlugin.Util.getString("MMConnection.Connection_close_success");
            this.logMessage(logMsg, null);
            this.closed = true;
        }
        catch (Throwable throwable) {
            Object var5_2 = null;
            if (this.pw != null) {
                this.pw.close();
                this.pw = null;
            }
            this.serverConn = null;
            String logMsg = JDBCPlugin.Util.getString("MMConnection.Connection_close_success");
            this.logMessage(logMsg, null);
            this.closed = true;
            throw throwable;
        }
    }

    private void closeStatements() throws SQLException {
        try {
            ArrayList statementsSafe = new ArrayList(this.statements);
            Iterator statementIter = statementsSafe.iterator();
            while (statementIter.hasNext()) {
                Statement statement = (Statement)statementIter.next();
                statement.close();
            }
        }
        catch (SQLException e) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Err_closing_stmts");
            throw MMSQLException.create(e, msg);
        }
        finally {
            this.statements = null;
        }
    }

    void closeStatement(Statement statement) {
        this.statements.remove(statement);
    }

    public void commit() throws SQLException {
        this.checkConnection();
        try {
            if (this.transaction != null) {
                this.transaction.commit();
                String logMsg = JDBCPlugin.Util.getString("MMConnection.Commit_success");
                this.logMessage(logMsg, null);
            }
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMConnection.Commit_failed", e.getMessage());
            this.logMessage(logMsg, e);
            String msg = JDBCPlugin.Util.getString("MMConnection.Err_committing");
            throw MMSQLException.create(e, msg);
        }
        finally {
            this.transaction = null;
            this.serverInstance = null;
        }
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        MMStatement newStatement = new MMStatement(this, resultSetType, resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    private void validateResultSetType(int resultSetType) throws MMSQLException {
        if (resultSetType == 1005) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Scrollable_type_not_supported", "ResultSet.TYPE_SCROLL_SENSITIVE");
            throw new MMSQLException(msg);
        }
    }

    private void validateResultSetConcurrency(int resultSetConcurrency) throws MMSQLException {
        if (resultSetConcurrency == 1008) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Concurrency_type_not_supported", "ResultSet.CONCUR_UPDATABLE");
            throw new MMSQLException(msg);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkConnection();
        return this.autoCommitFlag;
    }

    public String getCatalog() throws SQLException {
        this.checkConnection();
        return null;
    }

    ServerConnection getConnection() throws SQLException {
        this.checkConnection();
        return this.serverConn;
    }

    String getSchema() throws SQLException {
        this.checkConnection();
        return (String)this.propInfo.get("VirtualDatabaseName");
    }

    String getVDBVersion() throws SQLException {
        this.checkConnection();
        if (this.propInfo.get("VirtualDatabaseVersion") != null) {
            return (String)this.propInfo.get("VirtualDatabaseVersion");
        }
        return null;
    }

    String getUserName() throws SQLException {
        this.checkConnection();
        return (String)this.propInfo.get("user");
    }

    String getPassword() throws SQLException {
        this.checkConnection();
        return (String)this.propInfo.get("password");
    }

    protected java.sql.DatabaseMetaData getMetaData(BaseDriver driver) throws SQLException {
        this.checkConnection();
        if (this.dbmm != null) {
            return this.dbmm;
        }
        if (this.logLevel > 2) {
            DatabaseMetaData wrapper;
            MMDatabaseMetaData real = new MMDatabaseMetaData(driver, this);
            this.dbmm = wrapper = (DatabaseMetaData)JDBCTraceLogger.newInstance(real, new Class[]{class$com$metamatrix$jdbc$api$DatabaseMetaData == null ? (class$com$metamatrix$jdbc$api$DatabaseMetaData = MMConnection.class$("com.metamatrix.jdbc.api.DatabaseMetaData")) : class$com$metamatrix$jdbc$api$DatabaseMetaData}, this.pw);
        } else {
            this.dbmm = new MMDatabaseMetaData(driver, this);
        }
        return this.dbmm;
    }

    abstract String getDatabaseName();

    public int getHoldability() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    UserTransaction getTransaction(Statement statementObj) throws SQLException {
        this.checkConnection();
        return this.transaction;
    }

    public int getTransactionIsolation() throws SQLException {
        return 8;
    }

    public Map getTypeMap() throws SQLException {
        this.checkConnection();
        return new HashMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection();
        return null;
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1004, 1007);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        this.validateSQL(sql);
        MMCallableStatement newStatement = new MMCallableStatement(this, sql, resultSetType, resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    private void validateSQL(String sql) throws MMSQLException {
        if (sql == null) {
            String msg = JDBCPlugin.Util.getString("MMConnection.SQL_cannot_be_null");
            throw new MMSQLException(msg);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndex) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        this.validateSQL(sql);
        MMPreparedStatement newStatement = new MMPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void rollback() throws SQLException {
        this.checkConnection();
        try {
            if (this.transaction != null) {
                this.transaction.rollback();
                String logMsg = JDBCPlugin.Util.getString("MMConnection.Rollback_success");
                this.logMessage(logMsg, null);
            }
        }
        catch (Exception e) {
            String logMsg = JDBCPlugin.Util.getString("MMConnection.Rollback_failed", e.getMessage());
            this.logMessage(logMsg, e);
            String msg = JDBCPlugin.Util.getString("MMConnection.Err_rollingback", e.getMessage());
            throw MMSQLException.create(e, msg);
        }
        finally {
            this.transaction = null;
            this.serverInstance = null;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkConnection();
        if (autoCommit) {
            this.commit();
        }
        this.autoCommitFlag = autoCommit;
    }

    boolean allowExplicitTransactions() {
        String autoWrapMode = this.propInfo.getProperty("txnAutoWrap");
        return autoWrapMode == null || !autoWrapMode.equalsIgnoreCase("OFF");
    }

    public void setCatalog(String catalog) throws SQLException {
    }

    public void setHoldability(int holdability) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.readOnly == readOnly) {
            return;
        }
        if (!this.getAutoCommit() || this.transaction != null || this.getTransactionXid() != null) {
            String logMsg = JDBCPlugin.Util.getString("MMStatement.Invalid_During_Transaction", "setReadOnly(" + readOnly + ")");
            this.logMessage(logMsg, null);
            throw new MMSQLException(logMsg);
        }
        this.readOnly = readOnly;
    }

    void setTransaction(UserTransaction tx) {
        this.transaction = tx;
        String logMsg = JDBCPlugin.Util.getString("MMStatement.Starting_transaction", tx);
        this.logMessage(logMsg, null);
    }

    void checkConnection() throws SQLException {
        if (this.closed) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Cant_use_closed_connection");
            this.logMessage(msg, null);
            throw new MMSQLException(msg);
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
    }

    public void setTypeMap(Map map) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void releaseSavepoint(Savepoint sp) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void rollback(Savepoint sp) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public XAResource getXAResource() throws SQLException {
        return null;
    }

    public void addConnectionEventListener(ConnectionEventListener arg0) {
    }

    public void removeConnectionEventListener(ConnectionEventListener arg0) {
    }

    protected ServerInstance getServerInstance() throws CommunicationException, SQLException {
        if (this.serverInstance != null) {
            return this.serverInstance;
        }
        return this.serverConn.selectServerInstance(null);
    }

    protected void setServerInstance(ServerInstance si) {
        this.serverInstance = si;
    }

    protected void commitTransaction(Xid arg0, boolean arg1) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        ServerInstance si = this.serverInstance;
        TransactionHelper.commitTransaction(this.serverConn, si, arg0, arg1);
    }

    protected void endTransaction(Xid arg0, int arg1) throws SQLException {
        this.checkConnection();
        TransactionHelper.endTransaction(this.serverConn, this.serverInstance, arg0, arg1);
    }

    protected void forgetTransaction(Xid arg0) throws SQLException {
        this.checkConnection();
        TransactionHelper.forgetTransaction(this.serverConn, this.serverInstance, arg0);
    }

    protected int prepareTransaction(Xid arg0) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        ServerInstance si = this.serverInstance;
        return TransactionHelper.prepareTransaction(this.serverConn, si, arg0);
    }

    protected Xid[] recoverTransaction(int arg0) throws SQLException {
        this.checkConnection();
        return TransactionHelper.recoverTransaction(this.serverConn, this.serverInstance, arg0);
    }

    protected void rollbackTransaction(Xid arg0) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        ServerInstance si = this.serverInstance;
        TransactionHelper.rollbackTransaction(this.serverConn, si, arg0);
    }

    protected void startTransaction(Xid arg0, int arg1) throws SQLException {
        this.checkConnection();
        TransactionHelper.startTransaction(this.serverConn, this.serverInstance, arg0, arg1);
        this.transactionXid = arg0;
    }

    protected void setTransactionTimeout(int seconds) throws SQLException {
        this.checkConnection();
        TransactionHelper.setTransactionTimeout(this.serverConn, this.serverInstance, seconds);
    }

    protected void createServerInstance() {
        try {
            this.serverInstance = this.serverConn.selectServerInstance(null);
        }
        catch (CommunicationException e) {
            MMSQLException.create(e);
        }
    }

    protected Xid getTransactionXid() {
        return this.transactionXid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

