/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.api.MMURL_Properties;
import com.metamatrix.jdbc.JDBCPlugin;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.sql.DataSource;

public abstract class BaseDataSource
implements DataSource,
Serializable,
MMURL_Properties {
    public static final String VDB_NAME = "VirtualDatabaseName";
    public static final String VDB_VERSION = "VirtualDatabaseVersion";
    public static final String VERSION = "version";
    public static final String APP_NAME = "ApplicationName";
    public static final String USER_NAME = "user";
    public static final String PASSWORD = "password";
    public static final String LOG_FILE = "logFile";
    public static final String LOG_LEVEL = "logLevel";
    public static final int LOG_NONE = 0;
    public static final int LOG_INFO = 1;
    public static final int LOG_DETAIL = 2;
    public static final int LOG_TRACE = 3;
    protected static final int DEFAULT_TIMEOUT = 0;
    protected static final int DEFAULT_LOG_LEVEL = 0;
    private String databaseName;
    private String dataSourceName;
    private String description;
    private Serializable clientToken;
    private String user;
    private String password;
    private String databaseVersion;
    private String applicationName;
    private String logFile;
    private int logLevel = 0;
    private String partialResultsMode;
    private int fetchSize = 2000;
    private String resultSetCacheMode;
    private int loginTimeout = 0;
    private String sqlOptions;
    private String transactionAutoWrap;
    private transient PrintWriter logWriter;
    public static final String METAMATRIX_PROTOCOL = "metamatrix";
    public static final String JDBC = "jdbc:";
    protected static final int DEFAULT_FETCH_SIZE = 2000;
    protected static final String DEFAULT_PARTIAL_RESULTS_MODE = "FALSE";
    protected static final String DEFAULT_RESULT_SET_CACHE_MODE = "TRUE";
    public static final String TXN_AUTO_WRAP_OFF = "OFF";
    public static final String TXN_AUTO_WRAP_ON = "ON";
    public static final String TXN_AUTO_WRAP_PESSIMISTIC = "PESSIMISTIC";
    public static final String TXN_AUTO_WRAP_OPTIMISTIC = "OPTIMISTIC";
    private static final String BUNDLE_NAME = "com.metamatrix.jdbc.basic_i18n";

    protected Properties buildProperties(String userName, String password) {
        Serializable token;
        Properties props = new Properties();
        props.setProperty(VDB_NAME, this.getDatabaseName());
        if (this.getDatabaseVersion() != null && this.getDatabaseVersion().trim().length() != 0) {
            props.setProperty(VDB_VERSION, this.getDatabaseVersion());
        }
        if (userName != null && userName.trim().length() != 0) {
            props.setProperty(USER_NAME, userName);
        } else if (this.getUser() != null && this.getUser().trim().length() != 0) {
            props.setProperty(USER_NAME, this.getUser());
        }
        if (password != null && password.trim().length() != 0) {
            props.setProperty(PASSWORD, password);
        } else if (this.getPassword() != null && this.getPassword().trim().length() != 0) {
            props.setProperty(PASSWORD, this.getPassword());
        }
        if (this.getApplicationName() != null && this.getApplicationName().trim().length() != 0) {
            props.setProperty(APP_NAME, this.getApplicationName());
        }
        if ((token = this.getClientToken()) != null) {
            props.put("clientToken", token);
        }
        if (this.getLogFile() != null && this.getLogFile().trim().length() != 0) {
            props.setProperty(LOG_FILE, this.getLogFile().trim());
        }
        if (this.getLogLevel() != 0) {
            props.setProperty(LOG_LEVEL, Integer.toString(this.getLogLevel()));
        }
        if (this.getPartialResultsMode() != null && this.getPartialResultsMode().trim().length() != 0) {
            props.setProperty("partialResultsMode", this.getPartialResultsMode());
        }
        if (this.getFetchSize() > 0) {
            props.setProperty("fetchSize", "" + this.getFetchSize());
        }
        if (this.getResultSetCacheMode() != null && this.getResultSetCacheMode().trim().length() != 0) {
            props.setProperty("resultSetCacheMode", this.getResultSetCacheMode());
        }
        if (this.getSqlOptions() != null) {
            props.setProperty("sqlOptions", this.getSqlOptions());
        }
        if (this.getTransactionAutoWrap() != null && this.getTransactionAutoWrap().trim().length() != 0) {
            props.setProperty("txnAutoWrap", this.getTransactionAutoWrap());
        }
        return props;
    }

    protected void validateProperties(String userName, String password) throws SQLException {
        String reason = BaseDataSource.reasonWhyInvalidApplicationName(this.applicationName);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidClientToken(this.clientToken);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidDatabaseName(this.databaseName);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidDatabaseVersion(this.databaseVersion);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidDataSourceName(this.dataSourceName);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidDescription(this.description);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidLogFile(this.logFile);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidLogLevel(this.logLevel);
        if (reason != null) {
            throw new SQLException(reason);
        }
        String pwd = password != null ? password : this.getPassword();
        reason = BaseDataSource.reasonWhyInvalidPassword(pwd);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidPartialResultsMode(this.partialResultsMode);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidFetchSize(this.fetchSize);
        if (reason != null) {
            throw new SQLException(reason);
        }
        String user = userName != null ? userName : this.getUser();
        reason = BaseDataSource.reasonWhyInvalidUser(user);
        if (reason != null) {
            throw new SQLException(reason);
        }
        reason = BaseDataSource.reasonWhyInvalidTransactionAutoWrap(this.transactionAutoWrap);
        if (reason != null) {
            throw new SQLException(reason);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    public abstract Connection getConnection(String var1, String var2) throws SQLException;

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLogWriter(PrintWriter writer) throws SQLException {
        this.logWriter = writer;
    }

    public void setLoginTimeout(int timeOut) throws SQLException {
        this.loginTimeout = timeOut;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Serializable getClientToken() {
        return this.clientToken;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setDatabaseVersion(String databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setClientToken(Serializable clientToken) {
        this.clientToken = clientToken;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void setPartialResultsMode(String partialResultsMode) {
        this.partialResultsMode = partialResultsMode;
    }

    public String getPartialResultsMode() {
        return this.partialResultsMode;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setResultSetCacheMode(String resultSetCacheMode) {
        this.resultSetCacheMode = resultSetCacheMode;
    }

    public String getResultSetCacheMode() {
        return this.resultSetCacheMode;
    }

    public String getSqlOptions() {
        return this.sqlOptions;
    }

    public void setSqlOptions(String sqlOptions) {
        this.sqlOptions = sqlOptions;
    }

    public String getTransactionAutoWrap() {
        return this.transactionAutoWrap;
    }

    public void setTransactionAutoWrap(String transactionAutoWrap) {
        this.transactionAutoWrap = transactionAutoWrap;
    }

    public static String reasonWhyInvalidApplicationName(String applicationName) {
        return null;
    }

    public static String reasonWhyInvalidClientToken(Serializable clientToken) {
        return null;
    }

    public static String reasonWhyInvalidDatabaseName(String databaseName) {
        if (databaseName == null || databaseName.trim().length() == 0) {
            return BaseDataSource.getResourceMessage("MMDataSource.Virtual_database_name_must_be_specified");
        }
        return null;
    }

    public static String reasonWhyInvalidUser(String userName) {
        return null;
    }

    public static String reasonWhyInvalidTransactionAutoWrap(String autoWrap) {
        if (autoWrap == null || autoWrap.trim().length() == 0) {
            return null;
        }
        String trimmedAutoWrap = autoWrap.trim();
        if (TXN_AUTO_WRAP_ON.equals(trimmedAutoWrap)) {
            return null;
        }
        if (TXN_AUTO_WRAP_OFF.equals(trimmedAutoWrap)) {
            return null;
        }
        if (TXN_AUTO_WRAP_OPTIMISTIC.equals(trimmedAutoWrap)) {
            return null;
        }
        if (TXN_AUTO_WRAP_PESSIMISTIC.equals(trimmedAutoWrap)) {
            return null;
        }
        Object[] params = new Object[]{TXN_AUTO_WRAP_ON, TXN_AUTO_WRAP_OFF, TXN_AUTO_WRAP_OPTIMISTIC, TXN_AUTO_WRAP_PESSIMISTIC};
        return JDBCPlugin.Util.getString("MMDataSource.Invalid_trans_auto_wrap_mode", params);
    }

    public static String reasonWhyInvalidDatabaseVersion(String databaseVersion) {
        return null;
    }

    public static String reasonWhyInvalidDataSourceName(String dataSourceName) {
        return null;
    }

    public static String reasonWhyInvalidPassword(String pwd) {
        return null;
    }

    public static String reasonWhyInvalidDescription(String description) {
        return null;
    }

    public static String reasonWhyInvalidLogFile(String logFile) {
        return null;
    }

    public static String reasonWhyInvalidLogLevel(int logLevel) {
        if (logLevel < 0 || logLevel > 3) {
            Object[] params = new Object[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3)};
            return BaseDataSource.getResourceMessage("MMDataSource.Log_level_invalid", params);
        }
        return null;
    }

    public static String reasonWhyInvalidPartialResultsMode(String partialMode) {
        if (partialMode != null) {
            if (partialMode.equalsIgnoreCase("true") || partialMode.equalsIgnoreCase("false")) {
                return null;
            }
            return BaseDataSource.getResourceMessage("MMDataSource.The_partial_mode_must_be_boolean._47");
        }
        return null;
    }

    public static String reasonWhyInvalidFetchSize(int fetchSize) {
        if (fetchSize <= 0) {
            return BaseDataSource.getResourceMessage("MMDataSource.The_fetch_size_must_be_greater_than_zero");
        }
        return null;
    }

    static String getResourceMessage(String key, Object[] args) {
        ResourceBundle messages = ResourceBundle.getBundle(BUNDLE_NAME);
        String messageTemplate = messages.getString(key);
        return MessageFormat.format(messageTemplate, args);
    }

    static String getResourceMessage(String key) {
        ResourceBundle messages = ResourceBundle.getBundle(BUNDLE_NAME);
        String messageTemplate = messages.getString(key);
        return MessageFormat.format(messageTemplate, null);
    }
}

