/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.Cryptor;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.common.util.crypto.PasswordCryptoFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import org.apache.xerces.impl.dv.util.Base64;

public class CryptoUtil {
    public static final String DEFAULT_JCE_PROVIDER = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final String[] MD_ALGORITMS = new String[]{"SHA", "MD5"};
    private static boolean encryptionEnabled = false;
    private static boolean encryptionFlagInitialized = false;

    public static String getProviderName() {
        String provider = System.getProperty("metamatrix.encryption.jce.provider");
        if (provider == null || provider.trim().length() == 0) {
            try {
                provider = CurrentConfiguration.getBootStrapProperty((String)"metamatrix.encryption.jce.provider");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (provider == null || provider.trim().length() == 0) {
            provider = DEFAULT_JCE_PROVIDER;
        }
        return provider;
    }

    public static Provider initJCEProvider() {
        String providerName = CryptoUtil.getProviderName();
        if (providerName.equalsIgnoreCase("none")) {
            encryptionEnabled = false;
            encryptionFlagInitialized = true;
            return null;
        }
        encryptionEnabled = true;
        encryptionFlagInitialized = true;
        try {
            Class<?> clazz = Class.forName(providerName);
            Provider provider = (Provider)clazz.newInstance();
            if (System.getProperty("java.vendor").indexOf("IBM") != -1) {
                Security.insertProviderAt(provider, 3);
            } else if (Security.getProvider(provider.getName()) == null) {
                Security.addProvider(provider);
            }
            return provider;
        }
        catch (Exception e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0060", providerName));
            return null;
        }
    }

    public static void unloadJCEProvider() {
        String provider = CryptoUtil.getProviderName();
        if (!provider.equals("none")) {
            try {
                Class<?> clazz = Class.forName(provider);
                Provider p = (Provider)clazz.newInstance();
                Provider p1 = Security.getProvider(p.getName());
                p1.clear();
                Security.removeProvider(p.getName());
            }
            catch (Exception e) {
                System.out.println(CommonPlugin.Util.getString("ERR.003.030.0060", provider));
            }
        }
    }

    public static boolean isEncryptionEnabled() {
        if (!encryptionFlagInitialized) {
            String provider = null;
            provider = System.getProperty("metamatrix.encryption.jce.provider");
            if (provider == null || provider.trim().length() == 0) {
                try {
                    provider = CurrentConfiguration.getBootStrapProperty((String)"metamatrix.encryption.jce.provider");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (provider == null || provider.trim().length() == 0) {
                encryptionEnabled = true;
                encryptionFlagInitialized = true;
            } else if (provider.equalsIgnoreCase("none")) {
                encryptionEnabled = false;
                encryptionFlagInitialized = true;
            } else {
                encryptionEnabled = true;
                encryptionFlagInitialized = true;
            }
        }
        return encryptionEnabled;
    }

    public static byte[] getDigestedMessage(char[] msg) throws NoSuchAlgorithmException {
        return CryptoUtil.getDigestedMessage(new String(msg).getBytes());
    }

    public static byte[] getDigestedMessage(byte[] msg) throws NoSuchAlgorithmException {
        byte[] result = null;
        for (int i = 0; i < MD_ALGORITMS.length; ++i) {
            try {
                MessageDigest md = MessageDigest.getInstance(MD_ALGORITMS[i]);
                md.update(msg);
                result = md.digest();
                return result;
            }
            catch (NoSuchAlgorithmException ex) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(CommonPlugin.Util.getString("ERR.003.030.0061"));
    }

    public static Properties propertyEncrypt(Set match, Properties props) throws CryptoException {
        Cryptor theCryptor = PasswordCryptoFactory.getCryptor();
        Properties modifiedProps = new Properties();
        Enumeration<?> propEnum = props.propertyNames();
        while (propEnum.hasMoreElements()) {
            String propName = (String)propEnum.nextElement();
            if (match.contains(propName)) {
                String propVal = props.getProperty(propName);
                if (propVal == null) continue;
                if (propVal.trim().length() > 0) {
                    char[] cryptValue = theCryptor.encrypt(propVal.toCharArray());
                    modifiedProps.setProperty(propName, new String(cryptValue));
                    continue;
                }
                modifiedProps.setProperty(propName, propVal);
                continue;
            }
            modifiedProps.setProperty(propName, props.getProperty(propName));
        }
        return modifiedProps;
    }

    public static Properties propertyDecrypt(Set match, Properties props) throws CryptoException {
        Cryptor theCryptor = PasswordCryptoFactory.getCryptor();
        Properties modifiedProps = new Properties();
        Enumeration<?> propEnum = props.propertyNames();
        while (propEnum.hasMoreElements()) {
            String propName = (String)propEnum.nextElement();
            if (match.contains(propName)) {
                String propVal = props.getProperty(propName);
                if (propVal == null) continue;
                if (propVal.trim().length() > 0) {
                    char[] cryptValue = theCryptor.decrypt(propVal.toCharArray());
                    modifiedProps.setProperty(propName, new String(cryptValue));
                    continue;
                }
                modifiedProps.setProperty(propName, propVal);
                continue;
            }
            modifiedProps.setProperty(propName, props.getProperty(propName));
        }
        return modifiedProps;
    }

    public static Properties propertyEncrypt(String match, Properties props) throws CryptoException {
        Cryptor theCryptor = PasswordCryptoFactory.getCryptor();
        Properties modifiedProps = new Properties();
        Enumeration<?> propEnum = props.propertyNames();
        while (propEnum.hasMoreElements()) {
            String propName = (String)propEnum.nextElement();
            if (match.equalsIgnoreCase(propName)) {
                String propVal = props.getProperty(propName);
                if (propVal == null) continue;
                if (propVal.trim().length() > 0) {
                    char[] cryptValue = theCryptor.encrypt(propVal.toCharArray());
                    modifiedProps.setProperty(propName, new String(cryptValue));
                    continue;
                }
                modifiedProps.setProperty(propName, propVal);
                continue;
            }
            modifiedProps.setProperty(propName, props.getProperty(propName));
        }
        return modifiedProps;
    }

    public static Properties propertyDecrypt(String match, Properties props) throws CryptoException {
        Cryptor theCryptor = PasswordCryptoFactory.getCryptor();
        Properties modifiedProps = new Properties();
        Enumeration<?> propEnum = props.propertyNames();
        while (propEnum.hasMoreElements()) {
            String propName = (String)propEnum.nextElement();
            if (match.equalsIgnoreCase(propName)) {
                String propVal = props.getProperty(propName);
                if (propVal == null) continue;
                if (propVal.trim().length() > 0) {
                    char[] cryptValue = theCryptor.decrypt(propVal.toCharArray());
                    modifiedProps.setProperty(propName, new String(cryptValue));
                    continue;
                }
                modifiedProps.setProperty(propName, propVal);
                continue;
            }
            modifiedProps.setProperty(propName, props.getProperty(propName));
        }
        return modifiedProps;
    }

    public static Properties propertyEncryptEndsWith(String pattern, Properties props) throws CryptoException {
        return CryptoUtil.propertyEncryptEndsWith(PasswordCryptoFactory.getCryptor(), pattern, props);
    }

    public static Properties propertyEncryptEndsWith(Encryptor encryptor, String pattern, Properties props) throws CryptoException {
        Properties modifiedProps = new Properties();
        Enumeration<?> propEnum = props.propertyNames();
        pattern = pattern.toUpperCase();
        while (propEnum.hasMoreElements()) {
            String propName = (String)propEnum.nextElement();
            if (propName.toUpperCase().endsWith(pattern)) {
                String propVal = props.getProperty(propName);
                if (propVal == null) continue;
                if (propVal.trim().length() > 0) {
                    char[] cryptValue = encryptor.encrypt(propVal.toCharArray());
                    modifiedProps.setProperty(propName, new String(cryptValue));
                    continue;
                }
                modifiedProps.setProperty(propName, propVal);
                continue;
            }
            modifiedProps.setProperty(propName, props.getProperty(propName));
        }
        return modifiedProps;
    }

    public static Properties propertyDecryptEndsWith(String pattern, Properties props) throws CryptoException {
        Cryptor theCryptor = PasswordCryptoFactory.getCryptor();
        Properties modifiedProps = new Properties();
        Enumeration<?> propEnum = props.propertyNames();
        pattern = pattern.toUpperCase();
        while (propEnum.hasMoreElements()) {
            String propName = (String)propEnum.nextElement();
            if (propName.toUpperCase().endsWith(pattern)) {
                String propVal = props.getProperty(propName);
                if (propVal == null) continue;
                if (propVal.trim().length() > 0) {
                    char[] cryptValue = theCryptor.decrypt(propVal.toCharArray());
                    modifiedProps.setProperty(propName, new String(cryptValue));
                    continue;
                }
                modifiedProps.setProperty(propName, propVal);
                continue;
            }
            modifiedProps.setProperty(propName, props.getProperty(propName));
        }
        return modifiedProps;
    }

    public static char[] stringEncrypt(char[] clearText) throws CryptoException {
        return CryptoUtil.stringEncrypt(PasswordCryptoFactory.getCryptor(), clearText);
    }

    public static char[] stringEncrypt(Encryptor encryptor, char[] clearText) throws CryptoException {
        String v = new String(clearText);
        if (v.trim().length() > 0) {
            char[] cypherText = encryptor.encrypt(clearText);
            return cypherText;
        }
        return clearText;
    }

    public static char[] stringDecrypt(char[] cypherText) throws CryptoException {
        String v = new String(cypherText);
        if (v.trim().length() > 0) {
            Cryptor theCryptor = PasswordCryptoFactory.getCryptor();
            char[] clearText = theCryptor.decrypt(cypherText);
            return clearText;
        }
        return cypherText;
    }

    public static byte[] decodeDigestString(String digestString) {
        return Base64.decode((String)digestString);
    }

    public static String encodeDigestBytes(byte[] digtestbytes) {
        if (digtestbytes != null) {
            if (digtestbytes.length == 0) {
                return "";
            }
            return Base64.encode((byte[])digtestbytes);
        }
        return null;
    }
}

