'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: send.n,v 1.11 2003/03/19 23:02:00 cagney Exp $
'\" 
.so man.macros
.TH send n 4.0 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
send \- Execute a command in a different application
.SH SYNOPSIS
\fBsend ?\fIoptions\fR? \fIapp cmd \fR?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
This command arranges for \fIcmd\fR (and \fIarg\fRs) to be executed in the
application named by \fIapp\fR.  It returns the result or
error from that command execution.
\fIApp\fR may be the name of any application whose main window is
on the display containing the sender's main window;  it need not
be within the same process.
If no \fIarg\fR arguments are present, then the command to be executed is
contained entirely within the \fIcmd\fR argument.  If one or
more \fIarg\fRs are present, they are concatenated to form the
command to be executed, just as for the \fBeval\fR command.
.PP
If the initial arguments of the command begin with ``\-''
they are treated as options.  The following options are
currently defined:
.TP
\fB\-async\fR
Requests asynchronous invocation.  In this case the \fBsend\fR
command will complete immediately without waiting for \fIcmd\fR
to complete in the target application;  no result will be available
and errors in the sent command will be ignored.
If the target application is in the same process as the sending
application then the \fB\-async\fR option is ignored.
.TP
\fB\-displayof\fR \fIpathName\fR
Specifies that the target application's main window is on the display
of the window given by \fIpathName\fR, instead of the display containing
the application's main window.
.TP
\fB\-\|\-\fR
Serves no purpose except to terminate the list of options.  This
option is needed only if \fIapp\fR could contain a leading ``\-''
character.

.SH "APPLICATION NAMES"
.PP
The name of an application is set initially from the name of the
program or script that created the application.
You can query and change the name of an application with the
\fBtk appname\fR command.

.SH "DISABLING SENDS"
.PP
If the \fBsend\fR command is removed from an application (e.g.
with the command \fBrename send {}\fR) then the application
will not respond to incoming send requests anymore,  nor will it
be able to issue outgoing requests.
Communication can be reenabled by invoking the \fBtk appname\fR
command.

.SH SECURITY
.PP
The \fBsend\fR command is potentially a serious security loophole. On Unix,
any application that can connect to your X server can send
scripts to your applications.
These incoming scripts can use Tcl to read and
write your files and invoke subprocesses under your name.
Host-based access control such as that provided by \fBxhost\fR
is particularly insecure, since it allows anyone with an account
on particular hosts to connect to your server, and if disabled it
allows anyone anywhere to connect to your server.
In order to provide at least a small amount of
security, Tk checks the access control being used by the server
and rejects incoming sends unless (a) \fBxhost\fR-style access control
is enabled (i.e. only certain hosts can establish connections) and (b) the
list of enabled hosts is empty.
This means that applications cannot connect to your server unless
they use some other form of authorization
such as that provide by \fBxauth\fR.
.VS
Under Windows, \fBsend\fR is currently disabled.  Most of the
functionality is provided by the \fBdde\fR command instead.
.VE
.SH KEYWORDS
.VS
application, dde, name, remote execution, security, send
.VE
