/*
   (c) Copyright 2002-2003  Denis Oliver Kropp <dok@directfb.org>
   All rights reserved.

   XDirectFB is mainly based on XDarwin and
   also contains some KDrive, XFree and XWin code.
*/
/*
   Copyright (c) 1999 -  The XFree86 Project, Inc.

   Written by Mark Vojkovich
*/
/* $XFree86: xc/programs/Xserver/hw/xfree86/common/xf86DGA.c,v 1.46 2002/12/03 18:17:40 tsi Exp $ */

#include "dgaproc.h"
#include "colormapst.h"
#include "pixmapstr.h"
#include "inputstr.h"
#include "globals.h"
#include "servermd.h"
#include "scrnintstr.h"
#include "micmap.h"
#ifdef XKB
#include "XKBsrv.h"
#endif

#include "directfbScreen.h"
#include "directfbKeyboard.h"
#include "directfbX.h"

#include "directfbDGA.h"


#if 0
#define DEBUG_TRACE() fprintf(stderr,"XDirectFB: %s()\n", __FUNCTION__)
#else
#define DEBUG_TRACE() do {} while (0)
#endif

static unsigned long DGAGeneration = 0;
static int DGAScreenIndex = -1;

static Bool DGACloseScreen(int i, ScreenPtr pScreen);
static void DGADestroyColormap(ColormapPtr pmap);
static void DGAInstallColormap(ColormapPtr pmap);
static void DGAUninstallColormap(ColormapPtr pmap);

#if !defined(XFreeXDGA)
int *XDGAEventBase = NULL;
#else
int *XDGAEventBase = &DGAEventBase;
#endif

#define DGA_GET_SCREEN_PRIV(pScreen) \
	((XDirectFBDGAScreenPtr)((pScreen)->devPrivates[DGAScreenIndex].ptr))


typedef struct _FakedVisualList {
     Bool free;
     VisualPtr pVisual;
     struct _FakedVisualList *next;
} FakedVisualList;

typedef struct _XDirectFBDGAMode {
     int                       num;
     char                     *name;

     int                       width;
     int                       height;
     int                       bpp;

     struct _XDirectFBDGAMode *next;
} XDirectFBDGAModeRec, *XDirectFBDGAModePtr;

typedef struct {
     CloseScreenProcPtr       CloseScreen;
     DestroyColormapProcPtr   DestroyColormap;
     InstallColormapProcPtr   InstallColormap;
     UninstallColormapProcPtr UninstallColormap;

     int                      numModes;
     XDirectFBDGAModePtr      modes;

     int                      input;
     ClientPtr                client;
     int                      pixmapMode;
     FakedVisualList         *fakedVisuals;
     ColormapPtr              dgaColormap;
     ColormapPtr              savedColormap;
     Bool                     grabMouse;
     Bool                     grabKeyboard;
     Bool                     active;
} XDirectFBDGAScreenRec, *XDirectFBDGAScreenPtr;

/*
 * Called for each supported video mode.
 */
static DFBEnumerationResult
XDirectFBVideoModeCallback( int width, int height, int bpp, void *callbackdata )
{
     char                  name[100];
     XDirectFBDGAScreenPtr pScreenPriv = callbackdata;
     XDirectFBDGAModePtr   pMode       = pScreenPriv->modes;

     /* Reject unsupported modes. */
     switch (bpp) {
          case 15:
          case 16:
          case 24:
          case 32:
               break;
          default:
               return DFENUM_OK;
     }

     if (pMode) {
          /* Find last mode. */
          while (pMode->next)
               pMode = pMode->next;

          /* Allocate and append to list. */
          pMode->next = xcalloc( 1, sizeof(XDirectFBDGAModeRec) );
          if (!pMode->next) {
               XDIRECTFB_OUTOFMEMORY();
               return DFENUM_CANCEL;
          }

          pMode = pMode->next;
     }
     else {
          /* Allocate list head. */
          pMode = xcalloc( 1, sizeof(XDirectFBDGAModeRec) );
          if (!pMode) {
               XDIRECTFB_OUTOFMEMORY();
               return DFENUM_CANCEL;
          }

          pScreenPriv->modes = pMode;
     }

     /* Fill mode info. */
     snprintf( name, sizeof(name), "%dx%d %d bit", width, height, bpp );

     pMode->num    = ++pScreenPriv->numModes;
     pMode->name   = strdup( name );
     pMode->width  = width;
     pMode->height = height;
     pMode->bpp    = bpp;

     return DFENUM_OK;
}

static void
XDirectFBDGACopyModeInfo( XDirectFBDGAModePtr dfb, XDGAModePtr dga )
{
     memset( dga, 0, sizeof(XDGAModeRec) );

     dga->num              = dfb->num;
     dga->name             = dfb->name;

     dga->imageWidth       = dfb->width;
     dga->imageHeight      = dfb->height;

     dga->pixmapWidth      = dfb->width;
     dga->pixmapHeight     = dfb->height;

     dga->bytesPerScanline = dfb->width * ((dfb->bpp + 7) >> 3);
     dga->byteOrder        = LSBFirst;  /* FIXME */

     dga->depth            = dfb->bpp;  /* FIXME */
     dga->bitsPerPixel     = dfb->bpp;

     dga->viewportWidth    = dfb->width;
     dga->viewportHeight   = dfb->height;
     dga->viewportFlags    = DGA_FLIP_IMMEDIATE | DGA_FLIP_RETRACE;

     /* FIXME: The real pixel format isn't known yet. */
     switch (dfb->bpp) {
          case 15:
               dga->red_mask   = 0x00007C00;
               dga->green_mask = 0x000003E0;
               dga->blue_mask  = 0x0000001F;
               break;
          case 16:
               dga->red_mask   = 0x0000F800;
               dga->green_mask = 0x000007E0;
               dga->blue_mask  = 0x0000001F;
               break;
          case 24:
          case 32:
               dga->red_mask   = 0x00FF0000;
               dga->green_mask = 0x0000FF00;
               dga->blue_mask  = 0x000000FF;
               break;
          default:
               ErrorF( "Unexpected pixelformat in %s()!\n", __FUNCTION__ );
               break;
     }

     dga->visualClass = TrueColor;
}

/******************************************************************************/

Bool
XDirectFBDGAInit( ScreenPtr pScreen )
{
     DFBResult             ret;
     XDirectFBDGAScreenPtr pScreenPriv;

     DEBUG_TRACE();

     if (DGAGeneration != serverGeneration) {
          if ((DGAScreenIndex = AllocateScreenPrivateIndex()) < 0)
               return FALSE;
          DGAGeneration = serverGeneration;
     }

     if (!(pScreenPriv = xcalloc(1, sizeof(XDirectFBDGAScreenRec))))
          return FALSE;

     ret = dfb->EnumVideoModes( dfb, XDirectFBVideoModeCallback, pScreenPriv );
     if (ret) {
          DirectFBError( "IDirectFB::EnumVideoModes() failed", ret );
          xfree( pScreenPriv );
          return FALSE;
     }

     pScreenPriv->input = 0;
     pScreenPriv->client = NULL;
     pScreenPriv->fakedVisuals = NULL;
     pScreenPriv->dgaColormap = NULL;
     pScreenPriv->savedColormap = NULL;
     pScreenPriv->grabMouse = FALSE;
     pScreenPriv->grabKeyboard = FALSE;

     pScreen->devPrivates[DGAScreenIndex].ptr = (pointer)pScreenPriv;
     pScreenPriv->CloseScreen = pScreen->CloseScreen;
     pScreen->CloseScreen = DGACloseScreen;
     pScreenPriv->DestroyColormap = pScreen->DestroyColormap;
     pScreen->DestroyColormap = DGADestroyColormap;
     pScreenPriv->InstallColormap = pScreen->InstallColormap;
     pScreen->InstallColormap = DGAInstallColormap;
     pScreenPriv->UninstallColormap = pScreen->UninstallColormap;
     pScreen->UninstallColormap = DGAUninstallColormap;

     return TRUE;
}


static void
FreeMarkedVisuals( ScreenPtr pScreen )
{
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(pScreen);
     FakedVisualList *prev, *curr, *tmp;

     DEBUG_TRACE();

     if (!pScreenPriv->fakedVisuals)
          return;

     prev = NULL;
     curr = pScreenPriv->fakedVisuals;

     while (curr) {
          if (curr->free) {
               tmp = curr;
               curr = curr->next;
               if (prev)
                    prev->next = curr;
               else
                    pScreenPriv->fakedVisuals = curr;
               xfree(tmp->pVisual);
               xfree(tmp);
          }
          else {
               prev = curr;
               curr = curr->next;
          }
     }
}


static Bool 
DGACloseScreen( int i, ScreenPtr pScreen )
{
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(pScreen);
     XDirectFBDGAModePtr   pMode       = pScreenPriv->modes;

     DEBUG_TRACE();

     FreeMarkedVisuals(pScreen);

     pScreen->CloseScreen = pScreenPriv->CloseScreen;
     pScreen->DestroyColormap = pScreenPriv->DestroyColormap;
     pScreen->InstallColormap = pScreenPriv->InstallColormap;
     pScreen->UninstallColormap = pScreenPriv->UninstallColormap;

     /* DGAShutdown() should have ensured that no DGA
       screen were active by here */

     while (pMode) {
          XDirectFBDGAModePtr next = pMode->next;

          free( pMode->name );
          xfree( pMode );

          pMode = next;
     }

     xfree(pScreenPriv);

     return((*pScreen->CloseScreen)(i, pScreen));
}


static void 
DGADestroyColormap( ColormapPtr pmap )
{
     ScreenPtr pScreen = pmap->pScreen;
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(pScreen);

     DEBUG_TRACE();

#if 0
     VisualPtr pVisual = pmap->pVisual;

     if (pScreenPriv->fakedVisuals) {
          FakedVisualList *curr = pScreenPriv->fakedVisuals;

          while (curr) {
               if (curr->pVisual == pVisual) {
                    /* We can't get rid of them yet since FreeColormap
                       still needs the pVisual during the cleanup */
                    curr->free = TRUE;
                    break;
               }
               curr = curr->next;
          }
     }
#endif

     if (pScreenPriv->DestroyColormap) {
          pScreen->DestroyColormap = pScreenPriv->DestroyColormap;
          (*pScreen->DestroyColormap)(pmap);
          pScreen->DestroyColormap = DGADestroyColormap;
     }
}


static void 
DGAInstallColormap( ColormapPtr pmap )
{
     ScreenPtr pScreen = pmap->pScreen;
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(pScreen);

     DEBUG_TRACE();

#if 0
     if (pScreenPriv->current && pScreenPriv->dgaColormap) {
          if (pmap != pScreenPriv->dgaColormap) {
               pScreenPriv->savedColormap = pmap;
               pmap = pScreenPriv->dgaColormap;
          }
     }
#endif

     pScreen->InstallColormap = pScreenPriv->InstallColormap;
     (*pScreen->InstallColormap)(pmap);
     pScreen->InstallColormap = DGAInstallColormap;
}

static void 
DGAUninstallColormap( ColormapPtr pmap )
{
     ScreenPtr pScreen = pmap->pScreen;
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(pScreen);

     DEBUG_TRACE();

     /* This is to fixup state after client has been killed.
      * It's the wrong place, but I didn't see any app yet causing
      * this method to be called without using DGA.
      */
     pScreenPriv->grabMouse = FALSE;
     pScreenPriv->grabKeyboard = FALSE;

#if 0
     if (pScreenPriv->current && pScreenPriv->dgaColormap) {
          if (pmap == pScreenPriv->dgaColormap) {
               pScreenPriv->dgaColormap = NULL;
          }
     }
#endif

     pScreen->UninstallColormap = pScreenPriv->UninstallColormap;
     (*pScreen->UninstallColormap)(pmap);
     pScreen->UninstallColormap = DGAUninstallColormap;
}


/*********** exported ones ***************/

void
DGASetInputMode( int index, Bool keyboard, Bool mouse )
{
     ScreenPtr              pScreen     = screenInfo.screens[index];
     XDirectFBDGAScreenPtr  pScreenPriv = DGA_GET_SCREEN_PRIV(pScreen);
     IDirectFBDisplayLayer *layer       = DIRECTFB_PRIV(pScreen)->layer;

     DEBUG_TRACE();

     if (!pScreenPriv)
          return;

     pScreenPriv->grabMouse = mouse;
     pScreenPriv->grabKeyboard = keyboard;

     if (mouse)
          layer->EnableCursor( layer, DFB_FALSE );
     else
          layer->EnableCursor( layer, DFB_TRUE );
}

Bool
DGAChangePixmapMode( int index, int *x, int *y, int mode )
{
     DEBUG_TRACE();

     return FALSE;
}

Bool
DGAAvailable( int index )
{
     DEBUG_TRACE();

     if (DGAScreenIndex < 0)
          return FALSE;

     if (DGA_GET_SCREEN_PRIV(screenInfo.screens[index]))
          return TRUE;

     return FALSE;
}

Bool
DGAActive( int index )
{
     XDirectFBDGAScreenPtr pScreenPriv;

     DEBUG_TRACE();

     if (DGAScreenIndex < 0)
          return FALSE;

     pScreenPriv = DGA_GET_SCREEN_PRIV(screenInfo.screens[index]);

     if (pScreenPriv && pScreenPriv->active)
          return TRUE;

     return FALSE;
}



/* Called by the event code in case the server is abruptly terminated */

void 
DGAShutdown()
{
     DEBUG_TRACE();
}

/* Called by the extension to initialize a mode */

int
DGASetMode( int          index,
            int          num,
            XDGAModePtr  mode,
            PixmapPtr   *pPix )
{
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(screenInfo.screens[index]);
     XDirectFBDGAModePtr   pMode       = pScreenPriv->modes;

     DEBUG_TRACE();

     /* We rely on the extension to check that DGA is available */

     if (!num)
          return Success;

     if ((num < 0) || (num > pScreenPriv->numModes))
          return BadValue;

     while (pMode->num != num)
          pMode = pMode->next;

     ErrorF( "XDirectFB: %s (%d, %dx%d %d bit) unimplemented\n",
             __FUNCTION__, num, pMode->width, pMode->height, pMode->bpp);

     XDirectFBDGACopyModeInfo( pMode, mode );

     return BadImplementation;
}

/* Called from the extension to let the DDX know which events are requested */

void
DGASelectInput( int       index,
                ClientPtr client,
                long      mask )
{
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(screenInfo.screens[index]);

     DEBUG_TRACE();

     ErrorF( "DGASelectInput is unimplemented!\n" );

     /* We rely on the extension to check that DGA is available */
     pScreenPriv->client = client;
     pScreenPriv->input  = mask;
}

int 
DGAGetViewportStatus( int index )
{
     DEBUG_TRACE();

     return 0;
}

int
DGASetViewport( int index, int x, int y, int mode )
{
     DEBUG_TRACE();

     return BadImplementation;
}


#if 0
static int
BitsClear( CARD32 data )
{
     int bits = 0;
     CARD32 mask;

     DEBUG_TRACE();

     for (mask = 1; mask; mask <<= 1) {
          if (!(data & mask)) bits++;
          else break;
     }

     return bits;
}
#endif

int
DGACreateColormap( int index, ClientPtr client, int id, int mode, int alloc )
{
     DEBUG_TRACE();

     return BadImplementation;
#if 0
     ScreenPtr pScreen = screenInfo.screens[index];
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(pScreen);
     FakedVisualList *fvlp;
     VisualPtr pVisual;
     DGAModePtr pMode;
     ColormapPtr pmap;

     if (!mode || (mode > pScreenPriv->numModes))
          return BadValue;

     if ((alloc != AllocNone) && (alloc != AllocAll))
          return BadValue;

     pMode = &(pScreenPriv->modes[mode - 1]);

     if (!(pVisual = xalloc(sizeof(VisualRec))))
          return BadAlloc;

     pVisual->vid = FakeClientID(0);
     pVisual->class = pMode->visualClass;
     pVisual->nplanes = pMode->depth;
     pVisual->ColormapEntries = 1 << pMode->depth;
     pVisual->bitsPerRGBValue = (pMode->depth + 2) / 3;

     switch (pVisual->class) {
          case PseudoColor:
          case GrayScale:
          case StaticGray:
               pVisual->bitsPerRGBValue = 8; /* not quite */
               pVisual->redMask     = 0;
               pVisual->greenMask   = 0;
               pVisual->blueMask    = 0;
               pVisual->offsetRed   = 0;
               pVisual->offsetGreen = 0;
               pVisual->offsetBlue  = 0;
               break;
          case DirectColor:
          case TrueColor:
               pVisual->ColormapEntries = 1 << pVisual->bitsPerRGBValue;
               /* fall through */
          case StaticColor:
               pVisual->redMask = pMode->red_mask;
               pVisual->greenMask = pMode->green_mask;
               pVisual->blueMask = pMode->blue_mask;
               pVisual->offsetRed   = BitsClear(pVisual->redMask);
               pVisual->offsetGreen = BitsClear(pVisual->greenMask);
               pVisual->offsetBlue  = BitsClear(pVisual->blueMask);
     }

     if (!(fvlp = xalloc(sizeof(FakedVisualList)))) {
          xfree(pVisual);
          return BadAlloc;
     }

     fvlp->free = FALSE;
     fvlp->pVisual = pVisual;
     fvlp->next = pScreenPriv->fakedVisuals;
     pScreenPriv->fakedVisuals = fvlp;

     LEGAL_NEW_RESOURCE(id, client);

     return CreateColormap(id, pScreen, pVisual, &pmap, alloc, client->index);
#endif
}

/*  Called by the extension to install a colormap on DGA active screens */

void
DGAInstallCmap( ColormapPtr cmap )
{
     DEBUG_TRACE();

#if 0
     ScreenPtr pScreen = cmap->pScreen;
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(pScreen);

     /* We rely on the extension to check that DGA is active */ 

     if (!pScreenPriv->dgaColormap)
          pScreenPriv->savedColormap = miInstalledMaps[pScreen->myNum];

     pScreenPriv->dgaColormap = cmap;    

     (*pScreen->InstallColormap)(cmap);
#endif
}

int
DGASync( int index )
{
     DEBUG_TRACE();

     if (dfb->WaitIdle( dfb ))
          return BadImplementation;

     return Success;
}

int
DGAFillRect( int index, int x, int y, int w, int h, unsigned long color )
{
     DEBUG_TRACE();

     return BadImplementation;
}

int
DGABlitRect( int index, int srcx, int srcy, int w, int h, int dstx, int dsty )
{
     DEBUG_TRACE();

     return BadImplementation;
}

int
DGABlitTransRect( int index, int srcx, int srcy,
                  int w, int h, int dstx, int dsty, unsigned long color )
{
     DEBUG_TRACE();

     return BadImplementation;
}

int
DGAGetModes( int index )
{
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(screenInfo.screens[index]);

     DEBUG_TRACE();

     /* We rely on the extension to check that DGA is available */

     return pScreenPriv->numModes;
}

int
DGAGetModeInfo( int index, XDGAModePtr mode, int num )
{
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(screenInfo.screens[index]);
     XDirectFBDGAModePtr   pMode       = pScreenPriv->modes;

     DEBUG_TRACE();

     /* We rely on the extension to check that DGA is available */

     if ((num <= 0) || (num > pScreenPriv->numModes))
          return BadValue;

     while (pMode->num != num)
          pMode = pMode->next;

     XDirectFBDGACopyModeInfo( pMode, mode );

     return Success;
}

Bool 
DGAVTSwitch(void)
{
     DEBUG_TRACE();

     return FALSE;
}

Bool
DGAStealKeyEvent( int index, xEvent *e )
{
     DEBUG_TRACE();

     return FALSE;
}

Bool
DGAStealMouseEvent( int index, xEvent *e, int dx, int dy )
{
     DEBUG_TRACE();

     return FALSE;
}

Bool
DGAIsDgaEvent( xEvent *e )
{
     DEBUG_TRACE();

     return FALSE;
}

Bool
DGADeliverEvent( ScreenPtr pScreen, xEvent *e )
{
     DEBUG_TRACE();

     return FALSE;
}

Bool 
DGAOpenFramebuffer( int index, char **name, unsigned char **mem, int *size,
                    int *offset, int *flags )
{
     DEBUG_TRACE();

     return FALSE;
}

void
DGACloseFramebuffer( int index )
{
     DEBUG_TRACE();
}

/*  For DGA 1.0 backwards compatibility only */

int 
DGAGetOldDGAMode( int index )
{
     int                   w, h, b;
     ScreenPtr             pScreen     = screenInfo.screens[index];
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(pScreen);
     DirectFBScreenPtr     pScrn       = DIRECTFB_PRIV(pScreen);
     XDirectFBDGAModePtr   pMode       = pScreenPriv->modes;

     DEBUG_TRACE();

     /* We rely on the extension to check that DGA is available */

     w = pScrn->layer_config.width;
     h = pScrn->layer_config.height;
     b = DFB_BITS_PER_PIXEL(pScrn->layer_config.pixelformat);    /* FIXME */

     while (pMode) {
          if (pMode->width == w  &&  pMode->height == h  &&  pMode->bpp == b)
               return pMode->num;

          pMode = pMode->next;
     }

     return 0;
}

/******************************************************************************/

void
XDirectFBDGADispatchMotion( ScreenPtr pScreen,
                            DFBInputEvent *evt, DeviceIntPtr mouse )
{
     int                   dx, dy;
     Time                  t;
     xEvent                core;
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(pScreen);

     if (!pScreenPriv || !pScreenPriv->grabMouse) /* no direct mode */
          return;

     if (! (evt->flags & DIEF_AXISREL))
          return;

     switch (evt->axis) {
          case DIAI_X:
               dx = evt->axisrel;
               dy = 0;
               break;
          case DIAI_Y:
               dx = 0;
               dy = evt->axisrel;
               break;
          default:
               return;
     }

     if (evt->flags & DIEF_TIMESTAMP)
          t = (evt->timestamp.tv_sec * 1000) + (evt->timestamp.tv_usec / 1000);
     else
          t = GetTimeInMillis();

     /*
      * Deliver the DGA event
      */
     if (pScreenPriv->client) {
          /* If the DGA client has selected input, then deliver based on the usual filter */
          /*TryClientEvents (pScreenPriv->client, (xEvent *) de, 1, 
                           filters[coreEquiv], pScreenPriv->input, 0);*/
          ErrorF( "XDirectFBDGADispatchMotion() with "
                  "pScreenPriv->client != NULL is unimplemented!\n" );
     }
     else {
          /* If the pointer is actively grabbed, deliver a grabbed core event */
          if (mouse->grab && !mouse->fromPassiveGrab) {
               core.u.u.type                   = MotionNotify;
               core.u.u.detail                 = 0;
               core.u.keyButtonPointer.time    = t;
               core.u.keyButtonPointer.eventX  = dx;
               core.u.keyButtonPointer.eventY  = dy;
               core.u.keyButtonPointer.rootX   = dx;
               core.u.keyButtonPointer.rootY   = dy;
               core.u.keyButtonPointer.state   = mouse->button->state |
                                                 inputInfo.keyboard->key->state;
               DeliverGrabbedEvent (&core, mouse, FALSE, 1);
          }
     }
}

void
XDirectFBDGADispatchButton( ScreenPtr pScreen,
                            DFBInputEvent *evt, DeviceIntPtr mouse )
{
     Time                  t;
     int                   key;
     BYTE                 *kptr;
     int                   bit;
     xEvent                core;
     ButtonClassPtr        butc        = mouse->button;
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(pScreen);

     if (!pScreenPriv || !pScreenPriv->grabMouse) /* no direct mode */
          return;

     switch (evt->button) {
          case DIBI_LEFT:
               core.u.u.detail = 1;
               break;
          case DIBI_MIDDLE:
               core.u.u.detail = 2;
               break;
          case DIBI_RIGHT:
               core.u.u.detail = 3;
               break;
          default:
               return;
     }

     switch (evt->type) {
          case DIET_BUTTONPRESS:
               core.u.u.type = ButtonPress;
               break;
          case DIET_BUTTONRELEASE:
               core.u.u.type = ButtonRelease;
               break;
          default:
               return;
     }

     if (evt->flags & DIEF_TIMESTAMP)
          t = (evt->timestamp.tv_sec * 1000) + (evt->timestamp.tv_usec / 1000);
     else
          t = GetTimeInMillis();

     /*
      * Keep the core state in sync by duplicating what
      * CoreProcessPointerEvent does
      */
     key = core.u.u.detail;
     kptr = &butc->down[key >> 3];
     bit = 1 << (key & 7);
     switch (core.u.u.type) {
          case ButtonPress: 
               mouse->valuator->motionHintWindow = NullWindow;
               if (!(*kptr & bit))
                    butc->buttonsDown++;
               butc->motionMask = ButtonMotionMask;
               *kptr |= bit;
               if (key <= 5)
                    butc->state |= (Button1Mask >> 1) << key;
               break;
          case ButtonRelease: 
               mouse->valuator->motionHintWindow = NullWindow;
               if (*kptr & bit)
                    --butc->buttonsDown;
               if (!butc->buttonsDown)
                    butc->motionMask = 0;
               *kptr &= ~bit;
               if (key == 0)
                    return;
               if (key <= 5)
                    butc->state &= ~((Button1Mask >> 1) << key);
               break;
     }

     /*
      * Deliver the DGA event
      */
     if (pScreenPriv->client) {
          /* If the DGA client has selected input, then deliver based on the usual filter */
          /*TryClientEvents (pScreenPriv->client, (xEvent *) de, 1, 
                           filters[coreEquiv], pScreenPriv->input, 0);*/
          ErrorF( "XDirectFBDGADispatchButton() with "
                  "pScreenPriv->client != NULL is unimplemented!\n" );
     }
     else {
          /* If the pointer is actively grabbed, deliver a grabbed core event */
          if (mouse->grab && !mouse->fromPassiveGrab) {
               core.u.keyButtonPointer.time    = t;
               core.u.keyButtonPointer.eventX  = 0;
               core.u.keyButtonPointer.eventY  = 0;
               core.u.keyButtonPointer.rootX   = 0;
               core.u.keyButtonPointer.rootY   = 0;
               core.u.keyButtonPointer.state   = mouse->button->state |
                                                 inputInfo.keyboard->key->state;
               DeliverGrabbedEvent (&core, mouse, FALSE, 1);
          }
     }
}

void
XDirectFBDGADispatchKey( ScreenPtr pScreen,
                         DFBInputEvent *evt, DeviceIntPtr keyboard )
{
     Time                  t;
     xEvent                core;
     XDirectFBDGAScreenPtr pScreenPriv = DGA_GET_SCREEN_PRIV(pScreen);

     if (!pScreenPriv || !pScreenPriv->grabKeyboard) /* no direct mode */
          return;

     switch (evt->type) {
          case DIET_KEYPRESS:
               core.u.u.type = KeyPress;
               break;
          case DIET_KEYRELEASE:
               core.u.u.type = KeyRelease;
               break;
          default:
               return;
     }

     if (evt->key_code >= directfbMinScanCode &&
         evt->key_code <= directfbMaxScanCode) {
          core.u.u.detail = evt->key_code + DIRECTFB_MIN_KEYCODE - directfbMinScanCode;
     }
     else
          return;
     
     if (evt->flags & DIEF_TIMESTAMP)
          t = (evt->timestamp.tv_sec * 1000) + (evt->timestamp.tv_usec / 1000);
     else
          t = GetTimeInMillis();

     /*
      * Deliver the DGA event
      */
     if (pScreenPriv->client) {
          /* If the DGA client has selected input, then deliver based on the usual filter */
          /*TryClientEvents (pScreenPriv->client, (xEvent *) de, 1, 
                           filters[coreEquiv], pScreenPriv->input, 0);*/
          ErrorF( "XDirectFBDGADispatchKey() with "
                  "pScreenPriv->client != NULL is unimplemented!\n" );
     }
     else {
          /* If the pointer is actively grabbed, deliver a grabbed core event */
          if (keyboard->grab && !keyboard->fromPassiveGrab) {
               core.u.keyButtonPointer.time    = t;
               core.u.keyButtonPointer.eventX  = 0;
               core.u.keyButtonPointer.eventY  = 0;
               core.u.keyButtonPointer.rootX   = 0;
               core.u.keyButtonPointer.rootY   = 0;
               core.u.keyButtonPointer.state   = keyboard->key->state |
                                                 inputInfo.pointer->button->state;
               DeliverGrabbedEvent (&core, keyboard, FALSE, 1);
          }
     }
}

