.\"	$NetBSD: sh.1,v 1.40 2000/11/20 17:48:05 christos Exp $
.\" Copyright (c) 1991, 1993
.\"	The Regents of the University of California.  All rights reserved.
.\"
.\" This code is derived from software contributed to Berkeley by
.\" Kenneth Almquist.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgement:
.\"	This product includes software developed by the University of
.\"	California, Berkeley and its contributors.
.\" 4. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\"	@(#)sh.1	8.6 (Berkeley) 5/4/95
.\"
.Dd January 9, 1999
.Os
.Dt SH 1
.Sh NAME
sh \- command interpreter (shell)
.Sh SYNOPSIS
.Nm sh
.Op Fl /+aCefnuvxIimqsVEbc
.Op Fl o Ar longname
.Bk -words
.Op Ar target ...
.Ek
.Sh DESCRIPTION
Sh is the standard command interpreter for the system. The current version
of
.Nm
is in the process of being changed to conform with the
.Tn POSIX
1003.2 and 1003.2a specifications for the shell.  This version has many
features which make it appear similar in some respects to the Korn shell,
but it is not a Korn shell clone (see
.Xr ksh 1 ) .
Only features designated by
.Tn POSIX ,
plus a few Berkeley extensions, are being incorporated into this shell.
We expect
.Tn POSIX
conformance by the time 4.4 BSD is released. This man page is not intended
to be a tutorial or a complete specification of the shell.
.Ss Overview
The shell is a command that reads lines from either a file or the
terminal, interprets them, and generally executes other commands. It is
the program that is running when a user logs into the system (although a
user can select a different shell with the
.Xr chsh 1
command). The shell implements a language that has flow control
constructs, a macro facility that provides a variety of features in
addition to data storage, along with built in history and line editing
capabilities.  It incorporates many features to aid interactive use and
has the advantage that the interpretative language is common to both
interactive and non-interactive use (shell scripts).  That is, commands
can be typed directly to the running shell or can be put into a file and
the file can be executed directly by the shell.
.Ss Invocation
If no args are present and if the standard input of the shell
is connected to a terminal (or if the
.Fl i
flag is set),
and the 
.Fl c
option is not present, the shell is considered an interactive shell.  An
interactive shell generally prompts before each command and handles
programming and command errors differently (as described below). When
first starting, the shell inspects argument 0, and if it begins with a
dash
.Sq - ,
the shell is also considered
a login shell.  This is normally done automatically by the system
when the user first logs in. A login shell first reads commands
from the files
.Pa /etc/profile
and
.Pa .profile
if they exist.
If the environment variable
.Ev ENV
is set on entry to a shell, or is set in the
.Pa .profile
of a login shell, the shell next reads
commands from the file named in
.Ev ENV .
Therefore, a user should place commands that are to be executed only at
login time in the
.Pa .profile
file, and commands that are executed for every shell inside the
.Ev ENV
file.  To set the
.Ev ENV
variable to some file, place the following line in your
.Pa .profile
of your home directory
.Pp
.Dl ENV=$HOME/.shinit; export ENV
.Pp
substituting for
.Dq .shinit
any filename you wish. Since the
.Ev ENV
file is read for every invocation of the shell, including shell scripts
and non-interactive shells, the following paradigm is useful for
restricting commands in the
.Ev ENV
file to interactive invocations. Place commands within the
.Dq case
and
.Dq esac
below (these commands are described later):
.Pp
.Bl -item -compact -offset indent
.It
.Li case $- in *i*)
.Bl -item -compact -offset indent
.It
.Li # commands for interactive use only
.It
.Li ...
.El
.It
.Li esac
.El
.Pp
If command line arguments besides the options have been specified, then
the shell treats the first argument as the name of a file from which to
read commands (a shell script), and the remaining arguments are set as the
positional parameters of the shell ($1, $2, etc).  Otherwise, the shell
reads commands from its standard input.
.Ss Argument List Processing
All of the single letter options have a corresponding name that can be
used as an argument to the
.Fl o
option. The set
.Fl o
name is provided next to the single letter option in
the description below. Specifying a dash
.Dq -
turns the option on, while using a plus
.Dq +
disables the option.
The following options can be set from the command line or
with the
.Xr set 1
builtin (described later).
.Bl -tag -width aaaallexportfoo -offset indent
.It Fl a Em allexport
Export all variables assigned to. (UNIMPLEMENTED for 4.4alpha)
.It Fl c
Read commands from the command line.
No commands will be read from the standard input.
.It Fl C Em noclobber
Don't overwrite existing files with
.Dq > .
(UNIMPLEMENTED for 4.4alpha)
.It Fl e Em errexit
If not interactive, exit immediately if any untested command fails.
The exit status of a command is considered to be
explicitly tested if the command is used to control
an
.Ic if ,
.Ic elif ,
.Ic while ,
or
.Ic until ;
or if the command is the left hand operand of an
.Dq &&
or
.Dq ||
operator.
.It Fl f Em noglob
Disable pathname expansion.
.It Fl n Em noexec
If not interactive, read commands but do not execute them.  This is useful
for checking the syntax of shell scripts.
.It Fl u Em nounset
Write a message to standard error when attempting to expand a variable
that is not set, and if the shell is not interactive, exit immediately.
(UNIMPLEMENTED for 4.4alpha)
.It Fl v Em verbose
The shell writes its input to standard error as it is read.  Useful for
debugging.
.It Fl x Em xtrace
Write each command to standard error (preceded
by a
.Sq +\  )
before it is executed.  Useful for debugging.
.It Fl q Em quietprofile
If the
.Fl v
or
.Fl x
options have been set, do not apply them when reading
initialization files, these being
.Pa /etc/profile ,
.Pa .profile ,
and the file specified by the
.Ev ENV
environment variable.
.It Fl I Em ignoreeof
Ignore EOF's from input when interactive.
.It Fl i Em interactive
Force the shell to behave interactively.
.It Fl m Em monitor
Turn on job control (set automatically when interactive).
.It Fl s Em stdin
Read commands from standard input (set automatically if no file arguments
are present).  This option has no effect when set after the shell has
already started running (i.e. with
.Xr set 1 ) .
.It Fl V Em vi
Enable the built-in
.Xr vi 1
command line editor (disables
.Fl E
if it has been set).
.It Fl E Em emacs
Enable the built-in
.Xr emacs 1
command line editor (disables
.Fl V
if it has been set).
.It Fl b Em notify
Enable asynchronous notification of background job completion.
(UNIMPLEMENTED for 4.4alpha)
.El
.Ss Lexical Structure
The shell reads input in terms of lines from a file and breaks it up into
words at whitespace (blanks and tabs), and at certain sequences of
characters that are special to the shell called
.Dq operators .
There are two types of operators: control operators and redirection
operators (their meaning is discussed later). Following is a list of operators:
.Bl -ohang -offset indent
.It "Control operators:"
.Dl &  &&  (  )  ;  ;; | || <newline>
.It "Redirection operator:"
.Dl <  >  >|  <<  >>  <&  >&  <<-  <>
.El
.Ss Quoting
Quoting is used to remove the special meaning of certain characters or
words to the shell, such as operators, whitespace, or keywords.  There are
three types of quoting: matched single quotes, matched double quotes, and
backslash.
.Ss Backslash
A backslash preserves the literal meaning of the following
character, with the exception of
.Aq newline .
A backslash preceding a
.Aq newline
is treated as a line continuation.
.Ss Single Quotes
Enclosing characters in single quotes preserves the literal meaning of all
the characters (except single quotes, making it impossible to put
single-quotes in a single-quoted string).
.Ss Double Quotes
Enclosing characters within double quotes preserves the literal
meaning of all characters except dollarsign
.Pq $ ,
backquote
.Pq ` ,
and backslash
.Pq \e .
The backslash inside double quotes is historically weird, and serves to
quote only the following characters:
.Dl $  `  \*q  \e  <newline> .
Otherwise it remains literal.
.Ss Reserved Words
Reserved words are words that have special meaning to the
shell and are recognized at the beginning of a line and
after a control operator.  The following are reserved words:
.Bl -column while while while while while -offset indent
.It ! Ta elif Ta fi Ta while Ta case
.It else Ta for Ta then Ta { Ta }
.It do Ta done Ta until Ta if Ta esac
.El
.Pp
Their meaning is discussed later.
.Ss Aliases
An alias is a name and corresponding value set using the
.Xr alias 1
builtin command.  Whenever a reserved word may occur (see above),
and after checking for reserved words, the shell
checks the word to see if it matches an alias. If it does,
it replaces it in the input stream with its value.  For example,
if there is an alias called
.Dq lf
with the value
.Dq "ls -F" ,
then the input:
.Pp
.Dl lf foobar <return>
.Pp
would become
.Pp
.Dl ls -F foobar <return>
.Pp
Aliases provide a convenient way for naive users to create shorthands for
commands without having to learn how to create functions with arguments.
They can also be used to create lexically obscure code.  This use is
discouraged.
.Ss Commands
The shell interprets the words it reads according to a language, the
specification of which is outside the scope of this man page (refer to the
BNF in the
.Tn POSIX
1003.2 document).  Essentially though, a line is read and if the first
word of the line (or after a control operator) is not a reserved word,
then the shell has recognized a simple command.  Otherwise, a complex
command or some other special construct may have been recognized.
.Ss Simple Commands
If a simple command has been recognized, the shell performs
the following actions:
.Bl -enum -offset indent
.It
Leading words of the form
.Dq name=value
are stripped off and assigned to the environment of the simple command.
Redirection operators and their arguments (as described below) are
stripped off and saved for processing.
.It
The remaining words are expanded as described in
the section called
.Dq Expansions ,
and the first remaining word is considered the command name and the
command is located.  The remaining words are considered the arguments of
the command. If no command name resulted, then the
.Dq name=value
variable assignments recognized in item 1 affect the current shell.
.It
Redirections are performed as described in the next section.
.El
.Ss Redirections
Redirections are used to change where a command reads its input or sends
its output.  In general, redirections open, close, or duplicate an
existing reference to a file.  The overall format used for redirection is:
.Pp
.Dl [n] Va redir-op Ar file
.Pp
where
.Va redir-op
is one of the redirection operators mentioned previously.  Following is a
list of the possible redirections. The
.Bq n
is an optional number, as in
.Sq 3
(not
.Sq Bq 3 ,
that refers to a file descriptor.
.Bl -tag -width aaabsfiles -offset indent
.It [n] Ns > file
Redirect standard output (or n) to file.
.It [n] Ns >| file
Same, but override the
.Fl C
option.
.It [n] Ns >> file
Append standard output (or n) to file.
.It [n] Ns < file
Redirect standard input (or n) from file.
.It [n1] Ns <& Ns n2
Duplicate standard input (or n1) from file descriptor n2.
.It [n] Ns <&-
Close standard input (or n).
.It [n1] Ns >& Ns n2
Duplicate standard output (or n1) from n2.
.It [n] Ns >&-
Close standard output (or n).
.It [n] Ns <> file
Open file for reading and writing on standard input (or n).
.El
.Pp
The following redirection is often called a
.Dq here-document .
.Bl -item -offset indent
.It
.Li [n]<< delimiter
.Dl here-doc-text...
.Li delimiter
.El
.Pp
All the text on successive lines up to the delimiter is saved away and
made available to the command on standard input, or file descriptor n if
it is specified.  If the delimiter as specified on the initial line is
quoted, then the here-doc-text is treated literally, otherwise the text is
subjected to parameter expansion, command substitution, and arithmetic
expansion (as described in the section on
.Dq Expansions ) .
If the operator is
.Dq <<-
instead of
.Dq << ,
then leading tabs in the here-doc-text are stripped.
.Ss Search and Execution
There are three types of commands: shell functions, builtin commands, and
normal programs -- and the command is searched for (by name) in that
order.  They each are executed in a different way.
.Pp
When a shell function is executed, all of the shell positional parameters
(except $0, which remains unchanged) are set to the arguments of the shell
function. The variables which are explicitly placed in the environment of
the command (by placing assignments to them before the function name) are
made local to the function and are set to the values given. Then the
command given in the function definition is executed.  The positional
parameters are restored to their original values when the command
completes. This all occurs within the current shell.
.Pp
Shell builtins are executed internally to the shell, without spawning a
new process.
.Pp
Otherwise, if the command name doesn't match a function or builtin, the
command is searched for as a normal program in the filesystem (as
described in the next section). When a normal program is executed, the
shell runs the program, passing the arguments and the environment to the
program. If the program is not a normal executable file (i.e., if it does
not begin with the "magic number" whose
.Tn ASCII
representation is "#!", so
.Xr execve 2
returns
.Er ENOEXEC
then) the shell will interpret the program in a subshell.  The child shell
will reinitialize itself in this case, so that the effect will be as if a
new shell had been invoked to handle the ad-hoc shell script, except that
the location of hashed commands located in the parent shell will be
remembered by the child.
.Pp
Note that previous versions of this document and the source code itself
misleadingly and sporadically refer to a shell script without a magic
number as a "shell procedure".
.Ss Path Search
.Pp
When locating a command, the shell first looks to see if it has a shell
function by that name.  Then it looks for a builtin command by that name.
If a builtin command is not found, one of two things happen:
.Bl -enum
.It
Command names containing a slash are simply executed without performing
any searches.
.It
The shell searches each entry in
.Ev PATH
in turn for the command. The value of the
.Ev PATH
variable should be a series of entries separated by colons.  Each entry
consists of a directory name. The current directory may be indicated
implicitly by an empty directory name, or explicitly by a single period.
.El
.Ss Command Exit Status
Each command has an exit status that can influence the behavior
of other shell commands.  The paradigm is that a command exits
with zero for normal or success, and non-zero for failure,
error, or a false indication.  The man page for each command
should indicate the various exit codes and what they mean.
Additionally, the builtin commands return exit codes, as does
an executed shell function.
.Ss Complex Commands
Complex commands are combinations of simple commands with control
operators or reserved words, together creating a larger complex command.
More generally, a command is one of the following:
.Bl -bullet
.It
simple command
.It
pipeline
.It
list or compound-list
.It
compound command
.It
function definition
.El
.Pp
Unless otherwise stated, the exit status of a command is that of the last
simple command executed by the command.
.Ss Pipelines
.Pp
A pipeline is a sequence of one or more commands separated
by the control operator |.  The standard output of all but
the last command is connected to the standard input
of the next command.  The standard output of the last
command is inherited from the shell, as usual.
.Pp
The format for a pipeline is:
.Pp
.Dl [!] command1 [ | command2 ...]
.Pp
The standard output of command1 is connected to the standard input of
command2. The standard input, standard output, or both of a command is
considered to be assigned by the pipeline before any redirection specified
by redirection operators that are part of the command.
.Pp
If the pipeline is not in the background (discussed later), the shell
waits for all commands to complete.
.Pp
If the reserved word ! does not precede the pipeline, the exit status is
the exit status of the last command specified in the pipeline.
Otherwise, the exit status is the logical NOT of the exit status of the
last command.  That is, if the last command returns zero, the exit status
is 1; if the last command returns greater than zero, the exit status is
zero.
.Pp
Because pipeline assignment of standard input or standard output or both
takes place before redirection, it can be modified by redirection.  For
example:
.Pp
.Dl $ command1 2>&1 | command2
.Pp
sends both the standard output and standard error of command1
to the standard input of command2.
.Pp
A ; or <newline> terminator causes the preceding AND-OR-list (described
next) to be executed sequentially; a & causes asynchronous execution of
the preceding AND-OR-list.
.Pp
Note that unlike some other shells, each process in the pipeline is a
child of the invoking shell (unless it is a shell builtin, in which case
it executes in the current shell -- but any effect it has on the
environment is wiped).
.Ss Background Commands -- &
If a command is terminated by the control operator ampersand (&), the
shell executes the command asynchronously -- that is, the shell does not
wait for the command to finish before executing the next command.
.Pp
The format for running a command in background is:
.Pp
.Dl command1 & [command2 & ...]
.Pp
If the shell is not interactive, the standard input of an asynchronous
command is set to
.Pa /dev/null .
.Ss Lists -- Generally Speaking
A list is a sequence of zero or more commands separated by newlines,
semicolons, or ampersands, and optionally terminated by one of these three
characters. The commands in a list are executed in the order they are
written. If command is followed by an ampersand, the shell starts the
command and immediately proceed onto the next command; otherwise it waits
for the command to terminate before proceeding to the next one.
.Ss Short-Circuit List Operators
.Dq &&
and
.Dq ||
are AND-OR list operators.
.Dq &&
executes the first command, and then executes the second command iff the
exit status of the first command is zero.
.Dq ||
is similar, but executes the second command iff the exit status of the first
command is nonzero.
.Dq &&
and
.Dq ||
both have the same priority.
.Ss Flow-Control Constructs -- if, while, for, case
The syntax of the if command is
.Bd -literal -offset indent
if list
then list
[ elif list
then    list ] ...
[ else list ]
fi
.Ed
.Pp
The syntax of the while command is
.Bd -literal -offset indent
while list
do   list
done
.Ed
.Pp
The two lists are executed repeatedly while the exit status of the
first list is zero.  The until command is similar, but has the word
until in place of while, which causes it to
repeat until the exit status of the first list is zero.
.Pp
The syntax of the for command is
.Bd -literal -offset indent
for variable in word...
do   list
done
.Ed
.Pp
The words are expanded, and then the list is executed repeatedly with the
variable set to each word in turn.  do and done may be replaced with
.Dq {
and
.Dq } .
.Pp
The syntax of the break and continue command is
.Bd -literal -offset indent
break [ num ]
continue [ num ]
.Ed
.Pp
Break terminates the num innermost for or while loops.
Continue continues with the next iteration of the innermost loop.
These are implemented as builtin commands.
.Pp
The syntax of the case command is
.Bd -literal -offset indent
case word in
pattern) list ;;
\&...
esac
.Ed
.Pp
The pattern can actually be one or more patterns (see Shell
Patterns described later), separated by
.Dq \*(Ba
characters.
.Ss Grouping Commands Together
Commands may be grouped by writing either
.Pp
.Dl (list)
.Pp
or
.Pp
.Dl { list; }
.Pp
The first of these executes the commands in a subshell. Builtin commands
grouped into a (list) will not affect the current shell. The second form
does not fork another shell so is slightly more efficient. Grouping
commands together this way allows you to redirect their output as though
they were one program:
.Pp
.Bd -literal -offset indent
{ printf \*q hello \*q ; printf \*q world\\n" ; } > greeting
.Ed
.Pp
.Ss Functions
The syntax of a function definition is
.Pp
.Dl name ( ) command
.Pp
A function definition is an executable statement; when executed it
installs a function named name and returns an exit status of zero.  The
command is normally a list enclosed between
.Dq {
and
.Dq } .
.Pp
Variables may be declared to be local to a function by using a local
command.  This should appear as the first statement of a function, and the
syntax is
.Pp
.Dl local [ variable | - ] ...
.Pp
Local is implemented as a builtin command.
.Pp
When a variable is made local, it inherits the initial value and exported
and readonly flags from the variable with the same name in the surrounding
scope, if there is one.  Otherwise, the variable is initially unset.  The
shell uses dynamic scoping, so that if you make the variable x local to
function f, which then calls function g, references to the variable x made
inside g will refer to the variable x declared inside f, not to the global
variable named x.
.Pp
The only special parameter than can be made local is
.Dq - .
Making
.Dq -
local any shell options that are changed via the set command inside the
function to be restored to their original values when the function
returns.
.Pp
The syntax of the return command is
.Pp
.Dl return [ exitstatus ]
.Pp
It terminates the currently executing function.  Return is
implemented as a builtin command.
.Ss Variables and Parameters
The shell maintains a set of parameters.  A parameter denoted by a name is
called a variable. When starting up, the shell turns all the environment
variables into shell variables.  New variables can be set using the form
.Pp
.Dl name=value
.Pp
Variables set by the user must have a name consisting solely of
alphabetics, numerics, and underscores - the first of which must not be
numeric.  A parameter can also be denoted by a number or a special
character as explained below.
.Ss Positional Parameters
A positional parameter is a parameter denoted by a number (n > 0). The
shell sets these initially to the values of its command line arguments
that follow the name of the shell script. The
.Xr set 1
builtin can also be used to set or reset them.
.Ss Special Parameters
A special parameter is a parameter denoted by one of the following special
characters.  The value of the parameter is listed next to its character.
.Bl -tag -width thinhyphena
.It *
Expands to the positional parameters, starting from one.  When the
expansion occurs within a double-quoted string it expands to a single
field with the value of each parameter separated by the first character of
the
.Ev IFS
variable, or by a <space> if
.Ev IFS
is unset.
.It @
Expands to the positional parameters, starting from one.  When
the expansion occurs within double-quotes, each positional
parameter expands as a separate argument.
If there are no positional parameters, the
expansion of @ generates zero arguments, even when @ is
double-quoted.  What this basically means, for example, is
if $1 is
.Dq abc
and $2 is
.Dq def ghi ,
then
.Qq $@
expands to
the two arguments:
.Pp
.Sm off
.Dl \*q abc \*q \  \*q def\ ghi \*q
.Sm on
.It #
Expands to the number of positional parameters.
.It ?
Expands to the exit status of the most recent pipeline.
.It - (Hyphen.)
Expands to the current option flags (the single-letter
option names concatenated into a string) as specified on
invocation, by the set builtin command, or implicitly
by the shell.
.It $
Expands to the process ID of the invoked shell.  A subshell
retains the same value of $ as its parent.
.It !
Expands to the process ID of the most recent background
command executed from the current shell.  For a
pipeline, the process ID is that of the last command in the
pipeline.
.It 0 (Zero.)
Expands to the name of the shell or shell script.
.El
.Ss Word Expansions
This clause describes the various expansions that are performed on words.
Not all expansions are performed on every word, as explained later.
.Pp
Tilde expansions, parameter expansions, command substitutions, arithmetic
expansions, and quote removals that occur within a single word expand to a
single field.  It is only field splitting or pathname expansion that can
create multiple fields from a single word. The single exception to this
rule is the expansion of the special parameter @ within double-quotes, as
was described above.
.Pp
The order of word expansion is:
.Bl -enum
.It
Tilde Expansion, Parameter Expansion, Command Substitution,
Arithmetic Expansion (these all occur at the same time).
.It
Field Splitting is performed on fields
generated by step (1) unless the
.Ev IFS
variable is null.
.It
Pathname Expansion (unless set
.Fl f
is in effect).
.It
Quote Removal.
.El
.Pp
The $ character is used to introduce parameter expansion, command
substitution, or arithmetic evaluation.
.Ss Tilde Expansion (substituting a user's home directory)
A word beginning with an unquoted tilde character (~) is
subjected to tilde expansion.  All the characters up to
a slash (/) or the end of the word are treated as a username
and are replaced with the user's home directory.  If the
username is missing (as in
.Pa ~/foobar ) ,
the tilde is replaced with the value of the
.Va HOME
variable (the current user's home directory).
.Ss Parameter Expansion
The format for parameter expansion is as follows:
.Pp
.Dl ${expression}
.Pp
where expression consists of all characters until the matching
.Dq } .
Any
.Dq }
escaped by a backslash or within a quoted string, and characters in
embedded arithmetic expansions, command substitutions, and variable
expansions, are not examined in determining the matching
.Dq } .
.Pp
The simplest form for parameter expansion is:
.Pp
.Dl ${parameter}
.Pp
The value, if any, of parameter is substituted.
.Pp
The parameter name or symbol can be enclosed in braces, which are
optional except for positional parameters with more than one digit or
when parameter is followed by a character that could be interpreted as
part of the name.
If a parameter expansion occurs inside
double-quotes:
.Bl -enum
.It
Pathname expansion is not performed on the results of the
expansion.
.It
Field splitting is not performed on the results of the
expansion, with the exception of @.
.El
.Pp
In addition, a parameter expansion can be modified by using one of the
following formats.
.Bl -tag -width aaparameterwordaaaaa
.It ${parameter:-word}
Use Default Values.  If parameter is unset or null, the expansion of word
is substituted; otherwise, the value of parameter is substituted.
.It ${parameter:=word}
Assign Default Values.  If parameter is unset or null, the expansion of
word is assigned to parameter.  In all cases, the final value of parameter
is substituted.  Only variables, not positional parameters or special
parameters, can be assigned in this way.
.It ${parameter:?[word]}
Indicate Error if Null or Unset.  If parameter is unset or null, the
expansion of word (or a message indicating it is unset if word is omitted)
is written to standard error and the shell exits with a nonzero exit
status.  Otherwise, the value of parameter is substituted.  An interactive
shell need not exit.
.It ${parameter:+word}
Use Alternative Value.  If parameter is unset or null, null is
substituted; otherwise, the expansion of word is substituted.
.El
.Pp
In the parameter expansions shown previously, use of the colon in the
format results in a test for a parameter that is unset or null; omission
of the colon results in a test for a parameter that is only unset.
.Bl -tag -width aaparameterwordaaaaa
.It ${#parameter}
String Length.  The length in characters of
the value of parameter.
.El
.Pp
The following four varieties of parameter expansion provide for substring
processing.  In each case, pattern matching notation (see Shell Patterns),
rather than regular expression notation, is used to evaluate the patterns.
If parameter is * or @, the result of the expansion is unspecified.
Enclosing the full parameter expansion string in double-quotes does not
cause the following four varieties of pattern characters to be quoted,
whereas quoting characters within the braces has this effect.
.Bl -tag -width aaparameterwordaaaaa
.It ${parameter%word}
Remove Smallest Suffix Pattern.  The word is expanded to produce a
pattern.  The parameter expansion then results in parameter, with the
smallest portion of the suffix matched by the pattern deleted.
.It ${parameter%%word}
Remove Largest Suffix Pattern.  The word is expanded to produce a pattern.
The parameter expansion then results in parameter, with the largest
portion of the suffix matched by the pattern deleted.
.It ${parameter#word}
Remove Smallest Prefix Pattern.  The word is expanded to produce a
pattern.  The parameter expansion then results in parameter, with the
smallest portion of the prefix matched by the pattern deleted.
.It ${parameter##word}
Remove Largest Prefix Pattern.  The word is expanded to produce a pattern.
The parameter expansion then results in parameter, with the largest
portion of the prefix matched by the pattern deleted.
.El
.Ss Command Substitution
Command substitution allows the output of a command to be substituted in
place of the command name itself.  Command substitution occurs when
the command is enclosed as follows:
.Pp
.Dl $(command)
.Pp
or
.Po
.Dq backquoted
version
.Pc :
.Pp
.Dl `command`
.Pp
The shell expands the command substitution by executing command in a
subshell environment and replacing the command substitution with the
standard output of the command, removing sequences of one or more
<newline>s at the end of the substitution.  (Embedded <newline>s before
the end of the output are not removed; however, during field splitting,
they may be translated into <space>s, depending on the value of
.Ev IFS
and quoting that is in effect.)
.Ss Arithmetic Expansion
.Pp
Arithmetic expansion provides a mechanism for evaluating an arithmetic
expression and substituting its value. The format for arithmetic
expansion is as follows:
.Pp
.Dl $((expression))
.Pp
The expression is treated as if it were in double-quotes, except
that a double-quote inside the expression is not treated specially.  The
shell expands all tokens in the expression for parameter expansion,
command substitution, and quote removal.
.Pp
Next, the shell treats this as an arithmetic expression and
substitutes the value of the expression.
.Ss White Space Splitting (Field Splitting)
After parameter expansion, command substitution, and
arithmetic expansion the shell scans the results of
expansions and substitutions that did not occur in double-quotes for
field splitting and multiple fields can result.
.Pp
The shell treats each character of the
.Ev IFS
as a delimiter and use the delimiters to split the results of parameter
expansion and command substitution into fields.
.Ss Pathname Expansion (File Name Generation)
Unless the
.Fl f
flag is set, file name generation is performed after word splitting is
complete.  Each word is viewed as a series of patterns, separated by
slashes.  The process of expansion replaces the word with the names of all
existing files whose names can be formed by replacing each pattern with a
string that matches the specified pattern. There are two restrictions on
this: first, a pattern cannot match a string containing a slash, and
second, a pattern cannot match a string starting with a period unless the
first character of the pattern is a period. The next section describes the
patterns used for both Pathname Expansion and the
.Xr case 1
command.
.Ss Shell Patterns
A pattern consists of normal characters, which match themselves,
and meta-characters.   The meta-characters are
.Dq \&! ,
.Dq * ,
.Dq \&? ,
and
.Dq \&[ .
These characters lose their special meanings if they are quoted.  When
command or variable substitution is performed and the dollar sign or back
quotes are not double quoted, the value of the variable or the output of
the command is scanned for these characters and they are turned into
meta-characters.
.Pp
An asterisk
.Pq Dq *
matches any string of characters.  A question mark matches any single
character. A left bracket
.Pq Dq \&[
introduces a character class.  The end of
the character class is indicated by a
.Pq Dq \&] ;
if the
.Dq \&]
is missing then the
.Dq \&[
matches a
.Dq \&[
rather than introducing a character class.  A character class matches any
of the characters between the square brackets.  A range of characters may
be specified using a minus sign. The character class may be complemented
by making an exclamation point the first character of the character class.
.Pp
To include a
.Dq \&]
in a character class, make it the first character listed (after the
.Dq \&! ,
if any).  To include a minus sign, make it the first or last character listed
.Ss Builtins
.Pp
This section lists the builtin commands which are builtin because they
need to perform some operation that can't be performed by a separate
process. In addition to these, there are several other commands that may
be builtin for efficiency (e.g.
.Xr printf 1 ,
.Xr echo 1 ,
.Xr test 1 ,
etc).
.Bl -tag -width 5n
.It :
A null command that returns a 0 (true) exit value.
.It \&. file
The commands in the specified file are read and executed by the shell.
.It alias Op Ar name Ns Op Ar "=string ..."
If
.Ar name=string
is specified, the shell defines the alias
.Ar name
with value
.Ar string .
If just
.Ar name
is specified, the value of the alias
.Ar name
is printed. With no arguments, the
.Ic alias
builtin prints the
names and values of all defined aliases (see
.Ic unalias ) .
.It bg [ Ar job ] ...
Continue the specified jobs (or the current job if no
jobs are given) in the background.
.It command Ar command Ar arg...
Execute the specified builtin command.  (This is useful when you
have a shell function with the same name as a builtin command.)
.It cd Op Ar directory
Switch to the specified directory (default
.Ev $HOME ) .
If an entry for
.Ev CDPATH
appears in the environment of the
.Ic cd
command or the shell variable
.Ev CDPATH
is set and the directory name does not begin with a slash, then the
directories listed in
.Ev CDPATH
will be searched for the specified directory.  The format of
.Ev CDPATH
is the same as that of
.Ev PATH .
In an interactive shell, the
.Ic cd
command will print out the name of the
directory that it actually switched to if this is different from the name
that the user gave.  These may be different either because the
.Ev CDPATH
mechanism was used or because a symbolic link was crossed.
.It eval Ar string...
Concatenate all the arguments with spaces.  Then re-parse and execute
the command.
.It exec Op Ar command arg...
Unless command is omitted, the shell process is replaced with the
specified program (which must be a real program, not a shell builtin or
function).  Any redirections on the
.Ic exec
command are marked as permanent, so that they are not undone when the
.Ic exec
command finishes.
.It exit Op Ar exitstatus
Terminate the shell process.  If
.Ar exitstatus
is given it is used as the exit status of the shell; otherwise the
exit status of the preceding command is used.
.It export Ar name...
.It export Fl p
The specified names are exported so that they will appear in the
environment of subsequent commands. The only way to un-export a variable
is to unset it. The shell allows the value of a variable to be set at the
same time it is exported by writing
.Pp
.Dl export name=value
.Pp
With no arguments the export command lists the names of all exported variables.
With the
.Fl p
option specified the output will be formatted suitably for non-interactive use.
.It Xo fc Op Fl e Ar editor
.Op Ar first Op Ar last
.Xc
.It Xo fc Fl l
.Op Fl nr
.Op Ar first Op Ar last
.Xc
.It Xo fc Fl s Op Ar old=new
.Op Ar first
.Xc
The
.Ic fc
builtin lists, or edits and re-executes, commands previously entered
to an interactive shell.
.Bl -tag -width 5n
.It Fl e No editor
Use the editor named by editor to edit the commands.  The
editor string is a command name, subject to search via the
.Ev PATH
variable.  The value in the
.Ev FCEDIT
variable is used as a default when
.Fl e
is not specified.  If
.Ev FCEDIT
is null or unset, the value of the
.Ev EDITOR
variable is used.  If
.Ev EDITOR
is null or unset,
.Xr ed 1
is used as the editor.
.It Fl l No (ell)
List the commands rather than invoking an editor on them.  The commands
are written in the sequence indicated by the first and last operands, as
affected by
.Fl r ,
with each command preceded by the command number.
.It Fl n
Suppress command numbers when listing with -l.
.It Fl r
Reverse the order of the commands listed (with
.Fl l )
or edited (with neither
.Fl l
nor
.Fl s ) .
.It Fl s
Re-execute the command without invoking an editor.
.It first
.It last
Select the commands to list or edit.  The number of previous commands that
can be accessed are determined by the value of the
.Ev HISTSIZE
variable.  The value of first or last or both are one of the following:
.Bl -tag -width 5n
.It [+]number
A positive number representing a command number; command numbers can be
displayed with the
.Fl l
option.
.It Fl number
A negative decimal number representing the command that was executed
number of commands previously.  For example, -1 is the immediately
previous command.
.El
.It string
A string indicating the most recently entered command that begins with
that string.  If the old=new operand is not also specified with
.Fl s ,
the string form of the first operand cannot contain an embedded equal sign.
.El
.Pp
The following environment variables affect the execution of fc:
.Bl -tag -width HISTSIZE
.It Ev FCEDIT
Name of the editor to use.
.It Ev HISTSIZE
The number of previous commands that are accessible.
.El
.It fg Op Ar job
Move the specified job or the current job to the foreground.
.It getopts Ar optstring var
The
.Tn POSIX
.Ic getopts
command, not to be confused with the
.Em Bell Labs
-derived
.Xr getopt 1 .
.Pp
The first argument should be a series of letters, each of which may be
optionally followed by a colon to indicate that the option requires an
argument.  The variable specified is set to the parsed option.
.Pp
The
.Ic getopts
command deprecates the older
.Xr getopt 1
utility due to its handling of arguments containing whitespace.
.Pp
The
.Ic getopts
builtin may be used to obtain options and their arguments
from a list of parameters.  When invoked,
.Ic getopts
places the value of the next option from the option string in the list in
the shell variable specified by
.Va var
and it's index in the shell variable
.Ev OPTIND .
When the shell is invoked,
.Ev OPTIND
is initialized to 1.  For each option that requires an argument, the
.Ic getopts
builtin will place it in the shell variable
.Ev OPTARG .
If an option is not allowed for in the
.Va optstring ,
then
.Ev OPTARG
will be unset.
.Pp
.Va optstring
is a string of recognized option letters (see
.Xr getopt 3 ) .
If a letter is followed by a colon, the option is expected to have an
argument which may or may not be separated from it by white space.  If an
option character is not found where expected,
.Ic getopts
will set the variable
.Va var
to a
.Dq \&? ;
.Ic getopts
will then unset
.Ev OPTARG
and write output to standard error.  By specifying a colon as the
first character of
.Va optstring
all errors will be ignored.
.Pp
A nonzero value is returned when the last option is reached.
If there are no remaining arguments,
.Ic getopts
will set
.Va var
to the special option,
.Dq -- ,
otherwise, it will set
.Va var
to
.Dq \&? .
.Pp
The following code fragment shows how one might process the arguments
for a command that can take the options
.Op a
and
.Op b ,
and the option
.Op c ,
which requires an argument.
.Pp
.Bd -literal -offset indent
while getopts abc: f
do
	case $f in
	a | b)	flag=$f;;
	c)	carg=$OPTARG;;
	\\?)	echo $USAGE; exit 1;;
	esac
done
shift `expr $OPTIND - 1`
.Ed
.Pp
This code will accept any of the following as equivalent:
.Pp
.Bd -literal -offset indent
cmd \-acarg file file
cmd \-a \-c arg file file
cmd \-carg -a file file
cmd \-a \-carg \-\- file file
.Ed
.It hash Fl rv Ar command...
The shell maintains a hash table which remembers the
locations of commands.  With no arguments whatsoever,
the
.Ic hash
command prints out the contents of this table.  Entries which have not
been looked at since the last
.Ic cd
command are marked with an asterisk; it is possible for these entries
to be invalid.
.Pp
With arguments, the
.Ic hash
command removes the specified commands from the hash table (unless
they are functions) and then locates them.  With the
.Fl v
option, hash prints the locations of the commands as it finds them.  The
.Fl r
option causes the hash command to delete all the entries in the hash table
except for functions.
.It jobid Op Ar job
Print the process id's of the processes in the job.
If the
.Ar job
argument is omitted, the current job is used.
.It jobs
This command lists out all the background processes
which are children of the current shell process.
.It pwd
Print the current directory.  The builtin command may
differ from the program of the same name because the
builtin command remembers what the current directory
is rather than recomputing it each time.  This makes
it faster.  However, if the current directory is
renamed, the builtin version of
.Ic pwd
will continue to print the old name for the directory.
.It Xo read Op Fl p Ar prompt
.Op Fl r
.Ar variable...
.Xc
The prompt is printed if the
.Fl p
option is specified and the standard input is a terminal.  Then a line is
read from the standard input.  The trailing newline is deleted from the
line and the line is split as described in the section on word splitting
above, and the pieces are assigned to the variables in order.
At least one variable must be specified.
If there are
more pieces than variables, the remaining pieces (along with the
characters in
.Ev IFS
that separated them) are assigned to the last variable. If there are more
variables than pieces, the remaining variables are assigned the null
string. The
.Ic read
builtin will indicate success unless EOF is encountered on input, in
which case failure is returned.
.Pp
By default, unless the
.Fl r
option is specified, the backslash
.Dq \e
acts as an escape character, causing the following character to be treated
literally.  If a backslash is followed by a newline, the backslash and the
newline will be deleted.
.It readonly Ar name...
.It readonly Fl p
The specified names are marked as read only, so that they cannot be
subsequently modified or unset.  The shell allows the value of a variable
to be set at the same time it is marked read only by writing
.Pp
.Dl readonly name=value
.Pp
With no arguments the readonly command lists the names of all read only
variables.
With the
.Fl p
option specified the output will be formatted suitably for non-interactive use.
.Pp
.It Xo set
.Oo {
.Fl options | Cm +options | Cm -- }
.Oc Ar arg...
.Xc
The
.Ic set
command performs three different functions.
.Pp
With no arguments, it lists the values of all shell
variables.
.Pp
If options are given, it sets the specified option
flags, or clears them as described in the section
called
.Sx Argument List Processing .
.Pp
The third use of the set command is to set the values of the shell's
positional parameters to the specified args.  To change the positional
parameters without changing any options, use
.Dq --
as the first argument to set.  If no args are present, the set command
will clear all the positional parameters (equivalent to executing
.Dq shift $# . )
.It setvar Ar variable Ar value
Assigns value to variable. (In general it is better to write
variable=value rather than using
.Ic setvar .
.Ic setvar 
is intended to be used in
functions that assign values to variables whose names are passed as
parameters.)
.It shift Op Ar n
Shift the positional parameters n times.  A
.Ic shift
sets the value of
.Va $1
to the value of
.Va $2 ,
the value of
.Va $2
to the value of
.Va $3 ,
and so on, decreasing
the value of
.Va $#
by one. If n is greater than the number of positional parameters,
.Ic shift
will issue an error message, and exit with return status 2.
.It times
Print the accumulated user and system times for the shell and for processes
run from the shell.  The return status is 0.
.It Xo trap
.Ar action
.Ar signal...
.Xc
Cause the shell to parse and execute action when any of the specified
signals are received. The signals are specified by signal number. If
.Ar signal
is
.Li 0 ,
the action is executed when the shell exits.
.Ar action
may be null or
.Dq - ;
the former causes the specified signal to be
ignored and the latter causes the default action to be taken. When the
shell forks off a subshell, it resets trapped (but not ignored) signals to
the default action. The
.Ic trap
command has no effect on signals that were
ignored on entry to the shell.
.It type Op Ar name ...
Interpret each name as a command and print the resolution of the command
search. Possible resolutions are:
shell keyword, alias, shell builtin,
command, tracked alias and not found.  For aliases the alias expansion is
printed; for commands and tracked aliases the complete pathname of the
command is printed.
.It ulimit Xo
.Op Fl H \*(Ba Fl S
.Op Fl a \*(Ba Fl tfdscmlpn Op Ar value
.Xc
Inquire about or set the hard or soft limits on processes or set new
limits. The choice between hard limit (which no process is allowed to
violate, and which may not be raised once it has been lowered) and soft
limit (which causes processes to be signaled but not necessarily killed,
and which may be raised) is made with these flags:
.Bl -tag -width Fl
.It Fl H
set or inquire about hard limits
.It Fl S
set or inquire about soft limits. If neither
.Fl H
nor
.Fl S
is specified, the soft limit is displayed or both limits are set. If both
are specified, the last one wins.
.El
.Pp
.Bl -tag -width Fl
The limit to be interrogated or set, then, is chosen by specifying
any one of these flags:
.It Fl a
show all the current limits
.It Fl t
show or set the limit on CPU time (in seconds)
.It Fl f
show or set the limit on the largest file that can be created
(in 512-byte blocks)
.It Fl d
show or set the limit on the data segment size of a process (in kilobytes)
.It Fl s
show or set the limit on the stack size of a process (in kilobytes)
.It Fl c
show or set the limit on the largest core dump size that can be produced
(in 512-byte blocks)
.It Fl m
show or set the limit on the total physical memory that can be
in use by a process (in kilobytes)
.It Fl l
show or set the limit on how much memory a process can lock with
.Xr mlock 2
(in kilobytes)
.It Fl p
show or set the limit on the number of processes this user can
have at one time
.It Fl n
show or set the limit on the number files a process can have open at once
.El
.Pp
If none of these is specified, it is the limit on file size that is shown
or set. If value is specified, the limit is set to that number; otherwise
the current limit is displayed.
.Pp
Limits of an arbitrary process can be displayed or set using the
.Xr sysctl 8
utility.
.Pp
.It umask Op Ar mask
Set the value of umask (see
.Xr umask 2 )
to the specified octal value. If the argument is omitted, the umask value
is printed.
.It unalias Xo
.Op Fl a
.Op Ar name
.Xc
If
.Ar name
is specified, the shell removes that alias. If
.Fl a
is specified, all aliases are removed.
.It unset Ar name...
The specified variables and functions are unset and unexported. If a given
name corresponds to both a variable and a function, both the variable and
the function are unset.
.It wait Op Ar job
Wait for the specified job to complete and return the exit status of the
last process in the job. If the argument is omitted, wait for all jobs to
complete and the return an exit status of zero.
.El
.Ss Command Line Editing
When
.Nm
is being used interactively from a terminal, the current command
and the command history (see
.Ic fc
in
.Sx Builtins )
can be edited using vi-mode command-line editing. This mode uses commands,
described below, similar to a subset of those described in the vi man
page. The command
.Ql set -o vi
enables vi-mode editing and place sh into vi insert mode. With vi-mode
enabled, sh can be switched between insert mode and command mode. The
editor is not described in full here, but will be in a later document.
It's similar to vi: typing
.Aq ESC
will throw you into command VI command mode. Hitting
.Aq return
while in command mode will pass the line to the shell.
.Sh ENVIRONMENT
.Bl -tag -width MAILCHECK
.It Ev HOME
Set automaticly by
.Xr login 1
from the user's login directory in the password file
.Pq Xr passwd 4 .
This environment variable also functions as the default argument for the
cd builtin.
.It Ev PATH
The default search path for executables.  See the above section
.Sx Path Search .
.It Ev CDPATH
The search path used with the cd builtin.
.It Ev MAIL
The name of a mail file, that will be checked for the arrival of new mail.
Overridden by
.Ev MAILPATH .
.It Ev MAILCHECK
The frequency in seconds that the shell checks for the arrival of mail
in the files specified by the
.Ev MAILPATH
or the
.Ev MAIL
file.  If set to 0, the check will occur at each prompt.
.It Ev MAILPATH
A colon
.Dq \&:
separated list of file names, for the shell to check for incoming mail.
This environment setting overrides the
.Ev MAIL
setting.  There is a maximum of 10 mailboxes that can be monitored at once.
.It Ev PS1
The primary prompt string, which defaults to
.Dq $ \  ,
unless you are the superuser, in which case it defaults to
.Dq # \  .
.It Ev PS2
The secondary prompt string, which defaults to
.Dq > \  .
.It Ev IFS
Input Field Separators.  This is normally set to <space> <tab> and
<newline>.  See the
.Sx White Space Splitting
section for more details.
.It Ev TERM
The default terminal setting for the shell.  This is inherited by
children of the shell, and is used in the history editing modes.
.It Ev HISTSIZE
The number of lines in the history buffer for the shell.
.El
.Sh FILES
.Bl -item -width HOMEprofilexxxx
.It
.Pa $HOME/.profile
.It
.Pa /etc/profile
.El
.Sh SEE ALSO
.Xr csh 1 ,
.Xr getopt 1 ,
.Xr ksh 1 ,
.Xr login 1 ,
.Xr test 1 ,
.Xr getopt 3 ,
.Xr passwd 4 ,
.Xr profile 4 ,
.Xr environ 5
.Xr sysctl 8
.Sh HISTORY
A
.Nm
command appeared in
.At v1 .
It was, however, unmaintainable so we wrote this one.
.Sh EXIT STATUS
Errors that are detected by the shell, such as a syntax error, will cause the
shell to exit with a non-zero exit status.  If the shell is not an
interactive shell, the execution of the shell file will be aborted.  Otherwise
the shell will return the exit status of the last command executed, or
if the exit builtin is used with a numeric argument, it will return the
argument.
.Sh BUGS
Setuid shell scripts should be avoided at all costs, as they are a
significant security risk.