#
# xmlrpc-c
#
######################################################
ifneq ($(USE_CVS),true)
XMLRPC-C_SOURCE:=xmlrpc-c.tar.gz
XMLRPC-C_SITE:=http://download.sourceforge.net/xmlrpc-c/
XMLRPC-C_CAT:=zcat
XMLRPC-C_DIR:=$(BUILD_DIR)/xmlrpc-c
else
XMLRPC-C_DIR:=$(BUILD_DIR)/xmlrpc-c
endif
XMLRPC-C_PATCH:=$(SOURCE_DIR)/xmlrpc-c.patch

ifneq ($(USE_CVS),true)
xmlrpc-c-fetch:
	$(WGET) -P $(DL_DIR) $(XMLRPC-C_SITE)/$(XMLRPC-C_SOURCE)

xmlrpc-c-source: $(DL_DIR)/$(XMLRPC-C_SOURCE)
else
xmlrpc-c-source:
endif

XMLRPC_C_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d xmlrpc-c $(CVS_TAG) $(CVS_PREFIX)xmlrpc-c

xmlrpc-c-checkout:
	@$(XMLRPC_C_CVSCO)

$(XMLRPC-C_DIR)/.unpacked: $(DL_DIR)/$(XMLRPC-C_SOURCE)
ifneq ($(USE_CVS),true)
	$(XMLRPC-C_CAT) $(DL_DIR)/$(XMLRPC-C_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(XMLRPC_C_CVSCO)
endif
	sed -i -e 's,-D_FORK,,g' $(XMLRPC-C_DIR)/configure
	cp $(SOURCE_DIR)/config.sub $(XMLRPC-C_DIR)/
	touch $(XMLRPC-C_DIR)/.unpacked

$(XMLRPC-C_DIR)/.patched: $(XMLRPC-C_DIR)/.unpacked
	cat $(XMLRPC-C_PATCH) | patch -d $(XMLRPC-C_DIR) -p1
	touch $(XMLRPC-C_DIR)/.patched

$(XMLRPC-C_DIR)/.configured: $(XMLRPC-C_DIR)/.patched
	(cd $(XMLRPC-C_DIR); rm -rf config.cache; \
                $(TARGET_CONFIGURE_OPTS) \
                CFLAGS="$(TARGET_CFLAGS)" \
		LIBWWW_CONFIG=$(STAGING_DIR)/usr/bin/libwww-config \
                ./configure \
                --target=$(GNU_TARGET_NAME) \
                --host=$(GNU_TARGET_NAME) \
                --build=$(GNU_HOST_NAME) \
                --prefix=/usr \
                --exec-prefix=/usr \
                --bindir=/usr/bin \
                --sbindir=/usr/sbin \
                --libexecdir=/usr/lib \
                --sysconfdir=/etc \
                --datadir=/usr/share \
                --localstatedir=/var \
                --mandir=/usr/man \
                --infodir=/usr/info \
                $(DISABLE_NLS) \
                --disable-rpath \
                --disable-dependency-tracking \
        );
	touch $(XMLRPC-C_DIR)/.configured

$(XMLRPC-C_DIR)/src/.libs/libxmlrpc.so.3.3.0: $(XMLRPC-C_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(XMLRPC-C_DIR)

$(TARGET_DIR)/usr/lib/libxmlrpc.so.3.3.0: $(XMLRPC-C_DIR)/src/.libs/libxmlrpc.so.3.3.0
	$(MAKE) DESTDIR=$(STAGING_DIR) -C $(XMLRPC-C_DIR) install
	@echo "Installing XMLRPC-C shared libraries manually..."
	for p in `find $(XMLRPC-C_DIR) -name \*.so*` ; do \
	    cp -a $$p $(STAGING_DIR)/usr/lib/ ; \
	    cp -a $$p $(TARGET_DIR)/usr/lib/ ; \
	done
	-$(STRIP) $(TARGET_DIR)/usr/lib/libxmlrpc*.so* 2>/dev/null
	mkdir -p $(DOC_DIR)/doc/xmlrpc-c
	for f in BUGS README SECURITY doc/overview.txt doc/gpg-signature-info.txt doc/libwww-ssl.txt ; do \
	    install -m0644 $(XMLRPC-C_DIR)/$$f $(DOC_DIR)/doc/xmlrpc-c/ ; \
	done

xmlrpc-c: uclibc w3c-libwww $(TARGET_DIR)/usr/lib/libxmlrpc.so.3.3.0

xmlrpc-c-clean:
	$(MAKE) -C $(XMLRPC-C_DIR) clean
	$(MAKE) DESTDIR=$(STAGING_DIR) -C $(XMLRPC-C_DIR) uninstall
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(XMLRPC-C_DIR) uninstall
	-rm -f $(STAGING_DIR)/usr/lib/libxmlrpc*.so*
	-rm -f $(TARGET_DIR)/usr/lib/libxmlrpc*.so*
	-rm -rf $(DOC_DIR)/doc/xmlrpc-c

xmlrpc-c-dirclean:
	-rm -rf $(XMLRPC-C_DIR)

