#############################################################
#
# tftp
#
#############################################################
ifneq ($(USE_CVS), true)
TFTP_SOURCE:=tftp.tar.gz
TFTP_CAT:=zcat
endif

TFTP_DIR:=$(BUILD_DIR)/tftp
TFTP_BINARY:=tftp
TFTP_TARGET_BINARY:=usr/sbin/tftp

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(TFTP_SOURCE):

tftp-source: $(DL_DIR)/$(TFTP_SOURCE)
else
tftp-source:
endif

TFTP_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d tftp $(CVS_TAG) $(CVS_PREFIX)tftp

tftp-checkout:
	@$(TFTP_CVSCO)

$(TFTP_DIR)/.unpacked: $(DL_DIR)/$(TFTP_SOURCE)
ifneq ($(USE_CVS), true)
	$(TFTP_CAT) $(DL_DIR)/$(TFTP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(TFTP_CVSCO)
endif
	-cat $(SOURCE_DIR)/tftp.patch | patch -p1 -d $(TFTP_DIR)
	touch  $(TFTP_DIR)/.unpacked

$(TFTP_DIR)/.configured: $(TFTP_DIR)/.unpacked
	(cd $(TFTP_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share/misc \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
	);
	touch $(TFTP_DIR)/.configured $(TFTP_DIR)/configure

$(TFTP_DIR)/$(TFTP_BINARY): $(TFTP_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(TFTP_DIR)

$(TARGET_DIR)/$(TFTP_TARGET_BINARY): $(TFTP_DIR)/$(TFTP_BINARY)
	$(MAKE) INSTALLROOT=$(TARGET_DIR) -C $(TFTP_DIR) install

tftp: uclibc $(TARGET_DIR)/$(TFTP_TARGET_BINARY)

tftp-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(TFTP_DIR) uninstall
	-$(MAKE) -C $(TFTP_DIR) clean

tftp-dirclean:
	rm -rf $(TFTP_DIR)

