#############################################################
#
# readline
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
READLINE_SOURCE:=readline.tar.gz
READLINE_SITE:=ftp://ftp.gnu.org/gnu/readline
READLINE_CAT:=zcat
endif

READLINE_VERSION:=4.3
READLINE_DIR:=$(BUILD_DIR)/readline
READLINE_BINARY:=shlib/libreadline.so.$(READLINE_VERSION)
READLINE_TARGET_BINARY:=usr/lib/libreadline.so.$(READLINE_VERSION)

ifneq ($(USE_CVS),true)
readline-fetch:
	 $(WGET) -P $(DL_DIR) $(READLINE_SITE)/$(READLINE_SOURCE)

readline-source: $(DL_DIR)/$(READLINE_SOURCE)
else
readline-source:
endif

READLINE_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d readline $(CVS_TAG) $(CVS_PREFIX)readline

readline-checkout:
	@$(READLINE_CVSCO)

$(READLINE_DIR)/.unpacked: $(DL_DIR)/$(READLINE_SOURCE)
ifneq ($(USE_CVS),true)
	$(READLINE_CAT) $(DL_DIR)/$(READLINE_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(READLINE_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(READLINE_DIR)/
	ln -s /usr/share/automake-1.6/install-sh $(READLINE_DIR)/install-sh
	cat $(SOURCE_DIR)/readline-cygnus-makefile.patch | patch -d $(READLINE_DIR) -p0
	touch $(READLINE_DIR)/.unpacked

$(READLINE_DIR)/.configured: $(READLINE_DIR)/.unpacked
	(cd $(READLINE_DIR); rm -rf config.cache; \
		bash_cv_have_mbstate_t=yes \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(READLINE_DIR)/.configured

$(READLINE_DIR)/$(READLINE_BINARY): $(READLINE_DIR)/.configured
	$(MAKE) -C $(READLINE_DIR) all info
	$(MAKE) -C $(READLINE_DIR)/shlib all

$(STAGING_DIR)/$(READLINE_TARGET_BINARY): $(READLINE_DIR)/$(READLINE_BINARY)
	$(MAKE) DESTDIR=$(STAGING_DIR) -C $(READLINE_DIR) install install-shared

$(TARGET_DIR)/$(READLINE_TARGET_BINARY): $(STAGING_DIR)/$(READLINE_TARGET_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(READLINE_DIR) install install-shared
	-rm -rf $(TARGET_DIR)/usr/include/readline
	install -d $(DOC_DIR)/doc/readline
	@for f in COPYING ; do \
		install -m0644 $(READLINE_DIR)/$$f $(DOC_DIR)/doc/readline/$$f ;\
	done

readline: uclibc $(TARGET_DIR)/$(READLINE_TARGET_BINARY)

readline-clean:
	-$(MAKE) DESTDIR=$(STAGING_DIR) -C $(READLINE_DIR) uninstall
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(READLINE_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/readline
	-$(MAKE) -C $(READLINE_DIR) clean

readline-dirclean:
	rm -rf $(READLINE_DIR)
endif

