#############################################################
#
# parted
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
PARTED_SOURCE:=parted.tar.gz
PARTED_SITE:=ftp://ftp.gnu.org/gnu/parted
PARTED_CAT:=zcat
endif

PARTED_DIR:=$(BUILD_DIR)/parted
PARTED_BINARY:=parted/parted
PARTED_TARGET_BINARY:=sbin/parted

ifneq ($(USE_CVS),true)
partet-fetch:
	 $(WGET) -P $(DL_DIR) $(PARTED_SITE)/$(PARTED_SOURCE)

parted-source: $(DL_DIR)/$(PARTED_SOURCE)
else
parted-source:
endif

PARTED_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d parted $(CVS_TAG) $(CVS_PREFIX)parted

parted-checkout:
	@$(PARTED_CVSCO)

$(PARTED_DIR)/.unpacked: $(DL_DIR)/$(PARTED_SOURCE)
ifneq ($(USE_CVS),true)
	$(PARTED_CAT) $(DL_DIR)/$(PARTED_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(PARTED_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(PARTED_DIR)/
	touch $(PARTED_DIR)/.unpacked

$(PARTED_DIR)/.configured: $(PARTED_DIR)/.unpacked
	(cd $(PARTED_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--with-readline \
	);
	touch  $(PARTED_DIR)/.configured

$(PARTED_DIR)/$(PARTED_BINARY): $(PARTED_DIR)/.configured
	$(MAKE) CFLAGS="$(TARGET_CFLAGS)" CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(PARTED_DIR)

$(TARGET_DIR)/$(PARTED_TARGET_BINARY): $(PARTED_DIR)/$(PARTED_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(PARTED_DIR) install
	rm -rf $(TARGET_DIR)/usr/include/parted \
		$(TARGET_DIR)/usr/share/aclocal/parted.m4 \
		$(TARGET_DIR)/usr/lib/libparted*.la
	install -d $(DOC_DIR)/doc/parted
	@for f in AUTHORS BUGS COPYING NEWS README ; do \
		install -m0644 $(PARTED_DIR)/$$f $(DOC_DIR)/doc/parted/$$f ;\
	done

parted: uclibc $(TARGET_DIR)/$(PARTED_TARGET_BINARY)

parted-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(PARTED_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/parted
	-$(MAKE) -C $(PARTED_DIR) clean

parted-dirclean:
	rm -rf $(PARTED_DIR)
endif

