#
# nfs-utils
#
######################################################
ifneq ($(USE_CVS),true)
NFSUTILS_SOURCE:=nfs-utils.tar.gz
NFSUTILS_SITE:=http://download.sourceforge.net/nfs/
NFSUTILS_CAT:=zcat
NFSUTILS_DIR:=$(BUILD_DIR)/${shell basename $(NFSUTILS_SOURCE) .tar.gz}
else
# using CVS
NFSUTILS_DIR:=$(BUILD_DIR)/nfs-utils
endif

NFSUTILS_BINARY:=utils/exportfs/exportfs
NFSUTILS_TARGET_BINARY:=usr/sbin/exportfs

ifneq ($(USE_CVS),true)
nfs-utils-fetch:
	$(WGET) -P $(DL_DIR) $(NFSUTILS_SITE)/$(NFSUTILS_SOURCE)

nfs-utils-source: $(DL_DIR)/$(NFSUTILS_SOURCE)
else
nfs-utils-source:
endif

NFSUTILS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d nfs-utils $(CVS_TAG) $(CVS_PREFIX)nfs-utils

nfsutils-checkout:
	@$(NFSUTILS_CVSCO)

$(NFSUTILS_DIR)/.unpacked: $(DL_DIR)/$(NFSUTILS_SOURCE)
ifneq ($(USE_CVS),true)
	$(NFSUTILS_CAT) $(DL_DIR)/$(NFSUTILS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(NFSUTILS_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(NFSUTILS_DIR)/
	touch $(NFSUTILS_DIR)/.unpacked

$(NFSUTILS_DIR)/.configured: $(NFSUTILS_DIR)/.unpacked
	(cd $(NFSUTILS_DIR); rm -rf config.cache; \
                $(TARGET_CONFIGURE_OPTS) \
                CFLAGS="$(TARGET_CFLAGS)" \
		CC_FOR_BUILD=/usr/bin/gcc \
                ./configure \
                --target=$(GNU_TARGET_NAME) \
                --host=$(GNU_TARGET_NAME) \
                --build=$(GNU_HOST_NAME) \
                --prefix=/usr \
                --exec-prefix=/usr \
                --bindir=/usr/bin \
                --sbindir=/usr/sbin \
                --libexecdir=/usr/lib \
                --sysconfdir=/etc \
                --datadir=/usr/share \
                --localstatedir=/var \
                --mandir=/usr/man \
                --infodir=/usr/info \
                $(DISABLE_NLS) \
		--enable-nfsv3 \
        );
	touch $(NFSUTILS_DIR)/.configured

$(NFSUTILS_DIR)/$(NFSUTILS_BINARY): $(NFSUTILS_DIR)/.configured
	$(MAKE) -C $(NFSUTILS_DIR)
	rm -f $(TARGET_DIR)/$(NFSUTILS_TARGET_BINARY)

$(TARGET_DIR)/$(NFSUTILS_TARGET_BINARY): $(NFSUTILS_DIR)/$(NFSUTILS_BINARY)
	$(MAKE) -C $(NFSUTILS_DIR) install_prefix=$(TARGET_DIR) install
	$(STRIP) $(TARGET_DIR)/sbin/rpc.*d \
		$(TARGET_DIR)/usr/sbin/exportfs \
		$(TARGET_DIR)/usr/sbin/nfsstat \
		$(TARGET_DIR)/usr/sbin/rpc.mountd \
		$(TARGET_DIR)/usr/sbin/rpc.nfsd \
		$(TARGET_DIR)/usr/sbin/showmount
	if [ -d $(TARGET_DIR)/etc/rc.d/init.d ]; then \
		install -m0755 $(NFSUTILS_DIR)/etc/redhat/nfs.init \
			$(TARGET_DIR)/etc/rc.d/init.d/nfs ; \
		install -m0755 $(NFSUTILS_DIR)/etc/redhat/nfslock.init \
			$(TARGET_DIR)/etc/rc.d/init.d/nfslock ; \
	fi
	mkdir -p $(DOC_DIR)/doc/nfs-utils
	install -m0644 $(NFSUTILS_DIR)/COPYING $(DOC_DIR)/doc/nfs-utils/

nfsutils-clean:
	$(MAKE) -C $(NFSUTILS_DIR) clean
	-rm -f $(TARGET_DIR)/sbin/rpc.lockd
	-rm -f $(TARGET_DIR)/sbin/rpc.statd
	-rm -f $(TARGET_DIR)/usr/sbin/exportfs
	-rm -f $(TARGET_DIR)/usr/sbin/nfsstat
	-rm -f $(TARGET_DIR)/usr/sbin/nhfs*
	-rm -f $(TARGET_DIR)/usr/sbin/rpc.mountd
	-rm -f $(TARGET_DIR)/usr/sbin/rpc.nfsd
	-rm -f $(TARGET_DIR)/usr/sbin/showmount
	-rm -f $(TARGET_DIR)/etc/rc.d/init.d/nfs \
		$(TARGET_DIR)/etc/rc.d/init.d/nfslock
	-rm -rf $(DOC_DIR)/doc/nfs-utils

nfsutils-dirclean:
	-rm -rf $(NFSUTILS_DIR)

nfsutils: uclibc portmap $(TARGET_DIR)/$(NFSUTILS_TARGET_BINARY)

