#############################################################
#
# netkitrwall
#
#############################################################
ifneq ($(USE_CVS),true)
NETKITRWALL_SOURCE:=netkit-rwall.tar.gz
NETKITRWALL_SITE:=rwall://rwall.uk.linux.org/pub/linux/Networking/netkit/
NETKITRWALL_DIR:=$(BUILD_DIR)/${shell basename $(NETKITRWALL_SOURCE) .tar.gz}

NETKITRWALL_CAT:=zcat
else
# using CVS
NETKITRWALL_DIR:=$(BUILD_DIR)/netkit-rwall
endif

NETKITRWALL_BINARY:=rwall/rwall
NETKITRWALL_TARGET_BINARY:=usr/bin/rwall
NETKITRWALL_PATCH:=$(SOURCE_DIR)/netkitrwall.patch

ifneq ($(USE_CVS),true)
netkitrwall-fetch:
	 $(WGET) -P $(DL_DIR) $(NETKITRWALL_SITE)/$(NETKITRWALL_SOURCE)

netkitrwall-source: $(DL_DIR)/$(NETKITRWALL_SOURCE)
else
netkitrwall-source:
endif

NETKITRWALL_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d netkit-rwall $(CVS_TAG) $(CVS_PREFIX)netkit-rwall

netkitrwall-checkout:
	@$(NETKITRWALL_CVSCO)

$(NETKITRWALL_DIR)/.unpacked: $(DL_DIR)/$(NETKITRWALL_SOURCE)
ifneq ($(USE_CVS),true)
	$(NETKITRWALL_CAT) $(DL_DIR)/$(NETKITRWALL_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(NETKITRWALL_CVSCO)
endif
	touch $(NETKITRWALL_DIR)/.unpacked

$(NETKITRWALL_DIR)/.configured: $(NETKITRWALL_DIR)/.unpacked
	(cd $(NETKITRWALL_DIR); PATH=$(TARGET_PATH) CC=$(TARGET_CC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure --installroot=$(TARGET_DIR) --with-c-compiler=$(TARGET_CC) \
	)
	touch  $(NETKITRWALL_DIR)/.configured

$(NETKITRWALL_DIR)/$(NETKITRWALL_BINARY): $(NETKITRWALL_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(NETKITRWALL_DIR)

$(TARGET_DIR)/$(NETKITRWALL_TARGET_BINARY): $(NETKITRWALL_DIR)/$(NETKITRWALL_BINARY)
	$(MAKE) INSTALLROOT=$(TARGET_DIR) -C $(NETKITRWALL_DIR) install
	$(STRIP) $(TARGET_DIR)/$(NETKITRWALL_TARGET_BINARY) \
		$(TARGET_DIR)/usr/sbin/rpc.rwalld
	mkdir -p $(DOC_DIR)/doc/netkit-rwall
	sed -i -e "s~^# *walld.*~rwalld/1\tdgram\trpc/udp\twait\troot\t/usr/sbin/tcpd\trpc.rwalld~;" $(TARGET_DIR)/etc/inetd.conf
	for f in BUGS README ; do \
	    install -m0644 $(NETKITRWALL_DIR)/$$f $(DOC_DIR)/doc/netkit-rwall/$$f ; \
	done

netkitrwall: uclibc $(TARGET_DIR)/$(NETKITRWALL_TARGET_BINARY)

netkitrwall-clean:
	-rm -f $(TARGET_DIR)/$(NETKITRWALL_TARGET_BINARY) \
		$(TARGET_DIR)/usr/sbin/rpc.rwalld
	-$(MAKE) -C $(NETKITRWALL_DIR) clean
	-rm -rf $(DOC_DIR)/doc/netkit-rwall

netkitrwall-dirclean:
	rm -rf $(NETKITRWALL_DIR)

